/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   mock-interactions.js
 */

export {middleOfNode};


/**
 * Returns the (x,y) coordinates representing the middle of a node.
 */
declare function middleOfNode(node: Element): any;

export {topLeftOfNode};


/**
 * Returns the (x,y) coordinates representing the top left corner of a node.
 */
declare function topLeftOfNode(node: Element): any;

export {makeTouches};


/**
 * Returns a list of Touch objects that correspond to an array of positions
 * and a target node. The Touch instances will each have a unique Touch
 * identifier.
 */
declare function makeTouches(xyList: Array<{x: number, y: number}>, node: Element): any;

export {makeSoloTouchEvent};


/**
 * Generates and dispatches a TouchEvent of a given type, at a specified
 * position of a target node.
 */
declare function makeSoloTouchEvent(type: string, xy: {x: number, y: number}, node: Element): void;

export {makeMouseEvent};


/**
 * Fires a mouse event on a specific node, at a given set of coordinates.
 * This event bubbles and is cancellable.
 */
declare function makeMouseEvent(type: string, xy: {x: number, y: number}, node: Element): void;

export {move};


/**
 * Simulates a mouse move action by firing a `move` mouse event on a
 * specific node, between a set of coordinates.
 */
declare function move(node: Element, fromXY: object|null, toXY: object|null, steps?: number|null): void;

export {track};


/**
 * Simulates a mouse dragging action originating in the middle of a specific
 * node.
 */
declare function track(target: Element, dx: number|null, dy: number|null, steps?: number|null): void;

export {down};


/**
 * Fires a `down` mouse event on a specific node, at a given set of coordinates.
 * This event bubbles and is cancellable. If the (x,y) coordinates are
 * not specified, the middle of the node will be used instead.
 */
declare function down(node: Element, xy?: {x: number, y: number}): void;

export {up};


/**
 * Fires an `up` mouse event on a specific node, at a given set of coordinates.
 * This event bubbles and is cancellable. If the (x,y) coordinates are
 * not specified, the middle of the node will be used instead.
 */
declare function up(node: Element, xy?: {x: number, y: number}): void;

export {click};


/**
 * Generate a click event on a given node, optionally at a given coordinate.
 */
declare function click(node: Element, xy?: {x: number, y: number}): void;

export {touchstart};


/**
 * Generate a touchstart event on a given node, optionally at a given
 * coordinate.
 */
declare function touchstart(node: Element, xy?: {x: number, y: number}): void;

export {touchend};


/**
 * Generate a touchend event on a given node, optionally at a given coordinate.
 */
declare function touchend(node: Element, xy?: {x: number, y: number}): void;

export {downAndUp};


/**
 * Simulates a complete mouse click by firing a `down` mouse event, followed
 * by an asynchronous `up` and `tap` events on a specific node. Calls the
 * `callback` after the `tap` event is fired.
 */
declare function downAndUp(target: Element, callback?: Function|null, options?: {emulateTouch: boolean}|null): void;

export {tap};


/**
 * Fires a 'tap' mouse event on a specific node. This respects the
 * pointer-events set on the node, and will not fire on disabled nodes.
 */
declare function tap(node: Element, options?: {emulateTouch: boolean}|null): void;

export {focus};


/**
 * Focuses a node by firing a `focus` event. This event does not bubble.
 */
declare function focus(target: Element): void;

export {blur};


/**
 * Blurs a node by firing a `blur` event. This event does not bubble.
 */
declare function blur(target: Element): void;

export {keyboardEventFor};


/**
 * Returns a keyboard event. This event bubbles and is cancellable.
 */
declare function keyboardEventFor(type: string, keyCode: number, modifiers?: string|string[]|null, key?: string): any;

export {keyEventOn};


/**
 * Fires a keyboard event on a specific node. This event bubbles and is
 * cancellable.
 */
declare function keyEventOn(target: Element, type: string, keyCode: number, modifiers?: string|string[]|null, key?: string): void;

export {keyDownOn};


/**
 * Fires a 'keydown' event on a specific node. This event bubbles and is
 * cancellable.
 */
declare function keyDownOn(target: Element, keyCode: number, modifiers?: string|string[]|null, key?: string): void;

export {keyUpOn};


/**
 * Fires a 'keyup' event on a specific node. This event bubbles and is
 * cancellable.
 */
declare function keyUpOn(target: Element, keyCode: number, modifiers?: string|string[]|null, key?: string): void;

export {pressAndReleaseKeyOn};


/**
 * Simulates a complete key press by firing a `keydown` keyboard event, followed
 * by an asynchronous `keyup` event on a specific node.
 */
declare function pressAndReleaseKeyOn(target: Element, keyCode: number, modifiers?: string|string[]|null, key?: string): void;

export {pressEnter};


/**
 * Simulates a complete 'enter' key press by firing a `keydown` keyboard event,
 * followed by an asynchronous `keyup` event on a specific node.
 */
declare function pressEnter(target: Element): void;

export {pressSpace};


/**
 * Simulates a complete 'space' key press by firing a `keydown` keyboard event,
 * followed by an asynchronous `keyup` event on a specific node.
 */
declare function pressSpace(target: Element): void;
