/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   iron-scroll-threshold.js
 */

import {IronScrollTargetBehavior} from '../iron-scroll-target-behavior/iron-scroll-target-behavior.js';

import {Polymer} from '../polymer/lib/legacy/polymer-fn.js';

import {html} from '../polymer/lib/utils/html-tag.js';

import {LegacyElementMixin} from '../polymer/lib/legacy/legacy-element-mixin.js';

/**
 * `iron-scroll-threshold` is a utility element that listens for `scroll` events
 * from a scrollable region and fires events to indicate when the scroller has
 * reached a pre-defined limit, specified in pixels from the upper and lower bounds
 * of the scrollable region. This element may wrap a scrollable region and will
 * listen for `scroll` events bubbling through it from its children.  In this case,
 * care should be taken that only one scrollable region with the same orientation
 * as this element is contained within. Alternatively, the `scrollTarget` property
 * can be set/bound to a non-child scrollable region, from which it will listen for
 * events.
 *
 * Once a threshold has been reached, a `lower-threshold` or `upper-threshold`
 * event will be fired, at which point the user may perform actions such as
 * lazily-loading more data to be displayed. After any work is done, the user must
 * then clear the threshold by calling the `clearTriggers` method on this element,
 * after which it will begin listening again for the scroll position to reach the
 * threshold again assuming the content in the scrollable region has grown. If the
 * user no longer wishes to receive events (e.g. all data has been exhausted), the
 * threshold property in question (e.g. `lowerThreshold`) may be set to a falsy
 * value to disable events and clear the associated triggered property.
 *
 * ### Example
 *
 * ```html
 * <iron-scroll-threshold on-lower-threshold="loadMoreData">
 *   <div>content</div>
 * </iron-scroll-threshold>
 * ```
 *
 * ```js
 *   loadMoreData: function() {
 *     // load async stuff. e.g. XHR
 *     asyncStuff(function done() {
 *       ironScrollTheshold.clearTriggers();
 *     });
 *   }
 * ```
 *
 * ### Using dom-repeat
 *
 * ```html
 * <iron-scroll-threshold on-lower-threshold="loadMoreData">
 *   <template is="dom-repeat" items="[[items]]">
 *     <div>[[index]]</div>
 *   </template>
 * </iron-scroll-threshold>
 * ```
 *
 * ### Using iron-list
 *
 * ```html
 * <iron-scroll-threshold on-lower-threshold="loadMoreData" id="threshold">
 *   <iron-list scroll-target="threshold" items="[[items]]">
 *     <template>
 *       <div>[[index]]</div>
 *     </template>
 *   </iron-list>
 * </iron-scroll-threshold>
 * ```
 */
interface IronScrollThresholdElement extends IronScrollTargetBehavior, LegacyElementMixin, HTMLElement {
  readonly _defaultScrollTarget: any;

  /**
   * Distance from the top (or left, for horizontal) bound of the scroller
   * where the "upper trigger" will fire.
   */
  upperThreshold: number|null|undefined;

  /**
   * Distance from the bottom (or right, for horizontal) bound of the scroller
   * where the "lower trigger" will fire.
   */
  lowerThreshold: number|null|undefined;

  /**
   * Read-only value that tracks the triggered state of the upper threshold.
   */
  readonly upperTriggered: boolean|null|undefined;

  /**
   * Read-only value that tracks the triggered state of the lower threshold.
   */
  readonly lowerTriggered: boolean|null|undefined;

  /**
   * True if the orientation of the scroller is horizontal.
   */
  horizontal: boolean|null|undefined;
  _scrollHandler(): void;
  _setOverflow(scrollTarget: any): void;
  _initCheck(horizontal: any, isAttached: any): void;

  /**
   * Checks the scroll thresholds.
   * This method is automatically called by iron-scroll-threshold.
   */
  checkScrollThresholds(): void;
  checkScrollThesholds(): void;

  /**
   * Clear the upper and lower threshold states.
   */
  clearTriggers(): void;
}

export {IronScrollThresholdElement};

declare global {

  interface HTMLElementTagNameMap {
    "iron-scroll-threshold": IronScrollThresholdElement;
  }
}
