/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { __decorate } from '../../../tslib/tslib.js';
import { customElement } from '../../../lit/decorators.js';
import { OutlinedSegmentedButtonSet } from './lib/outlined-segmented-button-set.js';
import { styles as outlinedStyles } from './lib/outlined-styles.css.js';
import { styles as sharedStyles } from './lib/shared-styles.css.js';
/**
 * MdOutlinedSegmentedButtonSet is the custom element for the Material
 * Design outlined segmented button set component.
 * @soyCompatible
 * @final
 * @suppress {visibility}
 */
let MdOutlinedSegmentedButtonSet = class MdOutlinedSegmentedButtonSet extends OutlinedSegmentedButtonSet {
};
MdOutlinedSegmentedButtonSet.styles = [sharedStyles, outlinedStyles];
MdOutlinedSegmentedButtonSet = __decorate([
    customElement('md-outlined-segmented-button-set')
], MdOutlinedSegmentedButtonSet);
export { MdOutlinedSegmentedButtonSet };
//# sourceMappingURL=outlined-segmented-button-set.js.map