/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { __decorate, __metadata } from '../../../../tslib/tslib.js';
import { html } from '../../../../lit/index.js';
import { property } from '../../../../lit/decorators.js';
import { classMap } from '../../../../lit/directives/class-map.js';
import { ifDefined } from '../../../../lit/directives/if-defined.js';
import { when } from '../../../../lit/directives/when.js';
import { ripple } from '../../ripple/directive.js';
import { IconButton } from './icon-button.js';
// tslint:disable-next-line:enforce-comments-on-exported-symbols
export class LinkIconButton extends IconButton {
    constructor() {
        super(...arguments);
        /**
         * Sets the underlying `HTMLAnchorElement`'s `href` resource attribute.
         */
        this.linkHref = '';
        /**
         * Link buttons cannot be disabled.
         */
        this.disabled = false;
    }
    willUpdate() {
        this.disabled = false;
    }
    render() {
        return html `<div
        class="md3-icon-button ${classMap(this.getRenderClasses())}"
        @focus="${this.handleFocus}"
        @blur="${this.handleBlur}"
        @pointerdown="${this.handlePointerDown}"
        ${ripple(this.getRipple)}>
        ${this.renderFocusRing()}
        ${when(this.showRipple, this.renderRipple)}
        ${this.renderIcon()}
        ${this.renderTouchTarget()}
      <a class="md3-icon-button__link" href="${this.linkHref}"
          target="${ifDefined(this.linkTarget)}"
          aria-label="${ifDefined(this.ariaLabel)}"
          @focus="${this.handleFocus}"
          @blur="${this.handleBlur}">
      </a>
    </div>`;
    }
}
__decorate([
    property({ type: String }),
    __metadata("design:type", Object)
], LinkIconButton.prototype, "linkHref", void 0);
__decorate([
    property({ type: String }),
    __metadata("design:type", String)
], LinkIconButton.prototype, "linkTarget", void 0);
//# sourceMappingURL=link-icon-button.js.map