/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { html } from '../../../../lit/index.js';
import { FabShared } from './fab-shared.js';
/**
 * @soyCompatible
 */
export class FabExtended extends FabShared {
    /** @soyTemplate */
    getRenderClasses() {
        return {
            ...super.getRenderClasses(),
            'md3-fab--extended': true,
        };
    }
    /** @soyTemplate */
    renderIcon(icon) {
        return '';
    }
    /** @soyTemplate */
    renderLabel() {
        return html `<span class="md3-fab__label">${this.label}</span>`;
    }
}
//# sourceMappingURL=fab-extended.js.map