/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * MDCChipCssClasses provides the named constants for class names.
 */
export var MDCChipCssClasses;
(function (MDCChipCssClasses) {
    MDCChipCssClasses["SELECTING"] = "md3-chip--selecting";
    MDCChipCssClasses["DESELECTING"] = "md3-chip--deselecting";
    MDCChipCssClasses["SELECTING_WITH_PRIMARY_ICON"] = "md3-chip--selecting-with-primary-icon";
    MDCChipCssClasses["DESELECTING_WITH_PRIMARY_ICON"] = "md3-chip--deselecting-with-primary-icon";
    MDCChipCssClasses["DISABLED"] = "md3-chip--disabled";
    MDCChipCssClasses["ENTER"] = "md3n-chip--enter";
    MDCChipCssClasses["EXIT"] = "md3-chip--exit";
    MDCChipCssClasses["SELECTED"] = "md3-chip--selected";
    MDCChipCssClasses["HIDDEN"] = "md3-chip--hidden";
    MDCChipCssClasses["WITH_PRIMARY_ICON"] = "md3-chip--with-primary-icon";
})(MDCChipCssClasses || (MDCChipCssClasses = {}));
/**
 * MDCChipEvents provides the named constants for emitted events.
 */
export var MDCChipEvents;
(function (MDCChipEvents) {
    MDCChipEvents["INTERACTION"] = "MDCChip:interaction";
    MDCChipEvents["NAVIGATION"] = "MDCChip:navigation";
    MDCChipEvents["ANIMATION"] = "MDCChip:animation";
})(MDCChipEvents || (MDCChipEvents = {}));
/**
 * MDCChipAttributes provides the named constants for strings used by the
 * foundation.
 */
export var MDCChipAttributes;
(function (MDCChipAttributes) {
    MDCChipAttributes["DATA_REMOVED_ANNOUNCEMENT"] = "data-md3-removed-announcement";
    MDCChipAttributes["DATA_ADDED_ANNOUNCEMENT"] = "data-md3-added-announcement";
})(MDCChipAttributes || (MDCChipAttributes = {}));
/**
 * MDCChipAnimation provides the names of runnable animations.
 */
export var MDCChipAnimation;
(function (MDCChipAnimation) {
    MDCChipAnimation["ENTER"] = "md3-chip-enter";
    MDCChipAnimation["EXIT"] = "md3-chip-exit";
})(MDCChipAnimation || (MDCChipAnimation = {}));
//# sourceMappingURL=constants.js.map