/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * MDCChipCssClasses provides the named constants for class names.
 */
export declare enum MDCChipCssClasses {
    SELECTING = "md3-chip--selecting",
    DESELECTING = "md3-chip--deselecting",
    SELECTING_WITH_PRIMARY_ICON = "md3-chip--selecting-with-primary-icon",
    DESELECTING_WITH_PRIMARY_ICON = "md3-chip--deselecting-with-primary-icon",
    DISABLED = "md3-chip--disabled",
    ENTER = "md3n-chip--enter",
    EXIT = "md3-chip--exit",
    SELECTED = "md3-chip--selected",
    HIDDEN = "md3-chip--hidden",
    WITH_PRIMARY_ICON = "md3-chip--with-primary-icon"
}
/**
 * MDCChipEvents provides the named constants for emitted events.
 */
export declare enum MDCChipEvents {
    INTERACTION = "MDCChip:interaction",
    NAVIGATION = "MDCChip:navigation",
    ANIMATION = "MDCChip:animation"
}
/**
 * MDCChipAttributes provides the named constants for strings used by the
 * foundation.
 */
export declare enum MDCChipAttributes {
    DATA_REMOVED_ANNOUNCEMENT = "data-md3-removed-announcement",
    DATA_ADDED_ANNOUNCEMENT = "data-md3-added-announcement"
}
/**
 * MDCChipAnimation provides the names of runnable animations.
 */
export declare enum MDCChipAnimation {
    ENTER = "md3-chip-enter",
    EXIT = "md3-chip-exit"
}
