/**
 * @license
 * Copyright 2022 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { html } from '../../../../../lit/index.js';
import { classMap } from '../../../../../lit/directives/class-map.js';
import { ifDefined } from '../../../../../lit/directives/if-defined.js';
import { PrimaryAction } from './primary-action.js';
/** @soyCompatible */
export class PresentationalAction extends PrimaryAction {
    /** @soyTemplate */
    render() {
        return html `
      <span class="${classMap(this.getRootClasses())}"
          aria-label="${ifDefined(this.ariaLabel)}"
          role="presentation">
        ${this.renderGraphic()}
        ${this.renderLabel()}
      </span>`;
    }
    /** @soyTemplate */
    getRootClasses() {
        return {
            ...super.getRootClasses(),
            'md3-chip__action--presentational': true,
        };
    }
}
//# sourceMappingURL=presentational-action.js.map