/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { __decorate, __metadata } from '../../../../tslib/tslib.js';
import { html } from '../../../../lit/index.js';
import { property } from '../../../../lit/decorators.js';
import { classMap } from '../../../../lit/directives/class-map.js';
import { ifDefined } from '../../../../lit/directives/if-defined.js';
import { when } from '../../../../lit/directives/when.js';
import { ripple } from '../../ripple/directive.js';
import { Button } from './button.js';
// tslint:disable-next-line:enforce-comments-on-exported-symbols
export class LinkButton extends Button {
    constructor() {
        super(...arguments);
        /**
         * Link buttons cannot be disabled.
         */
        this.disabled = false;
    }
    // Note: link buttons cannot have trailing icons.
    getRenderClasses() {
        return {
            'md3-button--icon-leading': this.hasIcon,
        };
    }
    render() {
        return html `
      <span class="md3-link-button-wrapper">
        <a class="md3-button ${classMap(this.getRenderClasses())}"
          href="${ifDefined(this.href)}"
          target="${ifDefined(this.target)}"
          aria-label="${ifDefined(this.ariaLabel)}"
          @focus="${this.handleFocus}"
          @blur="${this.handleBlur}"
          @pointerdown="${this.handlePointerDown}"
          @click="${this.handleClick}"
          ${ripple(this.getRipple)}>
            ${this.renderFocusRing()}
            ${this.renderElevation()}
            ${when(this.showRipple, this.renderRipple)}
            ${this.renderOutline()}
            ${this.renderTouchTarget()}
            ${this.renderIcon()}
            ${this.renderLabel()}</a>
      </span>`;
    }
}
__decorate([
    property({ type: String }),
    __metadata("design:type", String)
], LinkButton.prototype, "href", void 0);
__decorate([
    property({ type: String }),
    __metadata("design:type", String)
], LinkButton.prototype, "target", void 0);
//# sourceMappingURL=link-button.js.map