// Copyright 2021 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build !windows
// +build !windows

// Package fileutils contains utility functions for files
package fileutils

import (
	"os"
)

const ExeExt = ""

// IsExe returns true if the file at path is an executable
func IsExe(path string) bool {
	s, err := os.Stat(path)
	if err != nil {
		return false
	}
	return s.Mode()&0100 != 0
}
