// Copyright 2021 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/sem/builtin_type.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/sem/builtin_type.h"

#include <sstream>

namespace tint::sem {

BuiltinType ParseBuiltinType(const std::string& name) {
    if (name == "abs") {
        return BuiltinType::kAbs;
    }
    if (name == "acos") {
        return BuiltinType::kAcos;
    }
    if (name == "acosh") {
        return BuiltinType::kAcosh;
    }
    if (name == "all") {
        return BuiltinType::kAll;
    }
    if (name == "any") {
        return BuiltinType::kAny;
    }
    if (name == "arrayLength") {
        return BuiltinType::kArrayLength;
    }
    if (name == "asin") {
        return BuiltinType::kAsin;
    }
    if (name == "asinh") {
        return BuiltinType::kAsinh;
    }
    if (name == "atan") {
        return BuiltinType::kAtan;
    }
    if (name == "atan2") {
        return BuiltinType::kAtan2;
    }
    if (name == "atanh") {
        return BuiltinType::kAtanh;
    }
    if (name == "ceil") {
        return BuiltinType::kCeil;
    }
    if (name == "clamp") {
        return BuiltinType::kClamp;
    }
    if (name == "cos") {
        return BuiltinType::kCos;
    }
    if (name == "cosh") {
        return BuiltinType::kCosh;
    }
    if (name == "countLeadingZeros") {
        return BuiltinType::kCountLeadingZeros;
    }
    if (name == "countOneBits") {
        return BuiltinType::kCountOneBits;
    }
    if (name == "countTrailingZeros") {
        return BuiltinType::kCountTrailingZeros;
    }
    if (name == "cross") {
        return BuiltinType::kCross;
    }
    if (name == "degrees") {
        return BuiltinType::kDegrees;
    }
    if (name == "determinant") {
        return BuiltinType::kDeterminant;
    }
    if (name == "distance") {
        return BuiltinType::kDistance;
    }
    if (name == "dot") {
        return BuiltinType::kDot;
    }
    if (name == "dot4I8Packed") {
        return BuiltinType::kDot4I8Packed;
    }
    if (name == "dot4U8Packed") {
        return BuiltinType::kDot4U8Packed;
    }
    if (name == "dpdx") {
        return BuiltinType::kDpdx;
    }
    if (name == "dpdxCoarse") {
        return BuiltinType::kDpdxCoarse;
    }
    if (name == "dpdxFine") {
        return BuiltinType::kDpdxFine;
    }
    if (name == "dpdy") {
        return BuiltinType::kDpdy;
    }
    if (name == "dpdyCoarse") {
        return BuiltinType::kDpdyCoarse;
    }
    if (name == "dpdyFine") {
        return BuiltinType::kDpdyFine;
    }
    if (name == "exp") {
        return BuiltinType::kExp;
    }
    if (name == "exp2") {
        return BuiltinType::kExp2;
    }
    if (name == "extractBits") {
        return BuiltinType::kExtractBits;
    }
    if (name == "faceForward") {
        return BuiltinType::kFaceForward;
    }
    if (name == "firstLeadingBit") {
        return BuiltinType::kFirstLeadingBit;
    }
    if (name == "firstTrailingBit") {
        return BuiltinType::kFirstTrailingBit;
    }
    if (name == "floor") {
        return BuiltinType::kFloor;
    }
    if (name == "fma") {
        return BuiltinType::kFma;
    }
    if (name == "fract") {
        return BuiltinType::kFract;
    }
    if (name == "frexp") {
        return BuiltinType::kFrexp;
    }
    if (name == "fwidth") {
        return BuiltinType::kFwidth;
    }
    if (name == "fwidthCoarse") {
        return BuiltinType::kFwidthCoarse;
    }
    if (name == "fwidthFine") {
        return BuiltinType::kFwidthFine;
    }
    if (name == "insertBits") {
        return BuiltinType::kInsertBits;
    }
    if (name == "inverseSqrt") {
        return BuiltinType::kInverseSqrt;
    }
    if (name == "ldexp") {
        return BuiltinType::kLdexp;
    }
    if (name == "length") {
        return BuiltinType::kLength;
    }
    if (name == "log") {
        return BuiltinType::kLog;
    }
    if (name == "log2") {
        return BuiltinType::kLog2;
    }
    if (name == "max") {
        return BuiltinType::kMax;
    }
    if (name == "min") {
        return BuiltinType::kMin;
    }
    if (name == "mix") {
        return BuiltinType::kMix;
    }
    if (name == "modf") {
        return BuiltinType::kModf;
    }
    if (name == "normalize") {
        return BuiltinType::kNormalize;
    }
    if (name == "pack2x16float") {
        return BuiltinType::kPack2X16Float;
    }
    if (name == "pack2x16snorm") {
        return BuiltinType::kPack2X16Snorm;
    }
    if (name == "pack2x16unorm") {
        return BuiltinType::kPack2X16Unorm;
    }
    if (name == "pack4x8snorm") {
        return BuiltinType::kPack4X8Snorm;
    }
    if (name == "pack4x8unorm") {
        return BuiltinType::kPack4X8Unorm;
    }
    if (name == "pow") {
        return BuiltinType::kPow;
    }
    if (name == "quantizeToF16") {
        return BuiltinType::kQuantizeToF16;
    }
    if (name == "radians") {
        return BuiltinType::kRadians;
    }
    if (name == "reflect") {
        return BuiltinType::kReflect;
    }
    if (name == "refract") {
        return BuiltinType::kRefract;
    }
    if (name == "reverseBits") {
        return BuiltinType::kReverseBits;
    }
    if (name == "round") {
        return BuiltinType::kRound;
    }
    if (name == "saturate") {
        return BuiltinType::kSaturate;
    }
    if (name == "select") {
        return BuiltinType::kSelect;
    }
    if (name == "sign") {
        return BuiltinType::kSign;
    }
    if (name == "sin") {
        return BuiltinType::kSin;
    }
    if (name == "sinh") {
        return BuiltinType::kSinh;
    }
    if (name == "smoothstep") {
        return BuiltinType::kSmoothstep;
    }
    if (name == "sqrt") {
        return BuiltinType::kSqrt;
    }
    if (name == "step") {
        return BuiltinType::kStep;
    }
    if (name == "storageBarrier") {
        return BuiltinType::kStorageBarrier;
    }
    if (name == "tan") {
        return BuiltinType::kTan;
    }
    if (name == "tanh") {
        return BuiltinType::kTanh;
    }
    if (name == "transpose") {
        return BuiltinType::kTranspose;
    }
    if (name == "trunc") {
        return BuiltinType::kTrunc;
    }
    if (name == "unpack2x16float") {
        return BuiltinType::kUnpack2X16Float;
    }
    if (name == "unpack2x16snorm") {
        return BuiltinType::kUnpack2X16Snorm;
    }
    if (name == "unpack2x16unorm") {
        return BuiltinType::kUnpack2X16Unorm;
    }
    if (name == "unpack4x8snorm") {
        return BuiltinType::kUnpack4X8Snorm;
    }
    if (name == "unpack4x8unorm") {
        return BuiltinType::kUnpack4X8Unorm;
    }
    if (name == "workgroupBarrier") {
        return BuiltinType::kWorkgroupBarrier;
    }
    if (name == "workgroupUniformLoad") {
        return BuiltinType::kWorkgroupUniformLoad;
    }
    if (name == "textureDimensions") {
        return BuiltinType::kTextureDimensions;
    }
    if (name == "textureGather") {
        return BuiltinType::kTextureGather;
    }
    if (name == "textureGatherCompare") {
        return BuiltinType::kTextureGatherCompare;
    }
    if (name == "textureNumLayers") {
        return BuiltinType::kTextureNumLayers;
    }
    if (name == "textureNumLevels") {
        return BuiltinType::kTextureNumLevels;
    }
    if (name == "textureNumSamples") {
        return BuiltinType::kTextureNumSamples;
    }
    if (name == "textureSample") {
        return BuiltinType::kTextureSample;
    }
    if (name == "textureSampleBias") {
        return BuiltinType::kTextureSampleBias;
    }
    if (name == "textureSampleCompare") {
        return BuiltinType::kTextureSampleCompare;
    }
    if (name == "textureSampleCompareLevel") {
        return BuiltinType::kTextureSampleCompareLevel;
    }
    if (name == "textureSampleGrad") {
        return BuiltinType::kTextureSampleGrad;
    }
    if (name == "textureSampleLevel") {
        return BuiltinType::kTextureSampleLevel;
    }
    if (name == "textureSampleBaseClampToEdge") {
        return BuiltinType::kTextureSampleBaseClampToEdge;
    }
    if (name == "textureStore") {
        return BuiltinType::kTextureStore;
    }
    if (name == "textureLoad") {
        return BuiltinType::kTextureLoad;
    }
    if (name == "atomicLoad") {
        return BuiltinType::kAtomicLoad;
    }
    if (name == "atomicStore") {
        return BuiltinType::kAtomicStore;
    }
    if (name == "atomicAdd") {
        return BuiltinType::kAtomicAdd;
    }
    if (name == "atomicSub") {
        return BuiltinType::kAtomicSub;
    }
    if (name == "atomicMax") {
        return BuiltinType::kAtomicMax;
    }
    if (name == "atomicMin") {
        return BuiltinType::kAtomicMin;
    }
    if (name == "atomicAnd") {
        return BuiltinType::kAtomicAnd;
    }
    if (name == "atomicOr") {
        return BuiltinType::kAtomicOr;
    }
    if (name == "atomicXor") {
        return BuiltinType::kAtomicXor;
    }
    if (name == "atomicExchange") {
        return BuiltinType::kAtomicExchange;
    }
    if (name == "atomicCompareExchangeWeak") {
        return BuiltinType::kAtomicCompareExchangeWeak;
    }
    if (name == "_tint_materialize") {
        return BuiltinType::kTintMaterialize;
    }
    return BuiltinType::kNone;
}

const char* str(BuiltinType i) {
    switch (i) {
        case BuiltinType::kNone:
            return "<none>";
        case BuiltinType::kAbs:
            return "abs";
        case BuiltinType::kAcos:
            return "acos";
        case BuiltinType::kAcosh:
            return "acosh";
        case BuiltinType::kAll:
            return "all";
        case BuiltinType::kAny:
            return "any";
        case BuiltinType::kArrayLength:
            return "arrayLength";
        case BuiltinType::kAsin:
            return "asin";
        case BuiltinType::kAsinh:
            return "asinh";
        case BuiltinType::kAtan:
            return "atan";
        case BuiltinType::kAtan2:
            return "atan2";
        case BuiltinType::kAtanh:
            return "atanh";
        case BuiltinType::kCeil:
            return "ceil";
        case BuiltinType::kClamp:
            return "clamp";
        case BuiltinType::kCos:
            return "cos";
        case BuiltinType::kCosh:
            return "cosh";
        case BuiltinType::kCountLeadingZeros:
            return "countLeadingZeros";
        case BuiltinType::kCountOneBits:
            return "countOneBits";
        case BuiltinType::kCountTrailingZeros:
            return "countTrailingZeros";
        case BuiltinType::kCross:
            return "cross";
        case BuiltinType::kDegrees:
            return "degrees";
        case BuiltinType::kDeterminant:
            return "determinant";
        case BuiltinType::kDistance:
            return "distance";
        case BuiltinType::kDot:
            return "dot";
        case BuiltinType::kDot4I8Packed:
            return "dot4I8Packed";
        case BuiltinType::kDot4U8Packed:
            return "dot4U8Packed";
        case BuiltinType::kDpdx:
            return "dpdx";
        case BuiltinType::kDpdxCoarse:
            return "dpdxCoarse";
        case BuiltinType::kDpdxFine:
            return "dpdxFine";
        case BuiltinType::kDpdy:
            return "dpdy";
        case BuiltinType::kDpdyCoarse:
            return "dpdyCoarse";
        case BuiltinType::kDpdyFine:
            return "dpdyFine";
        case BuiltinType::kExp:
            return "exp";
        case BuiltinType::kExp2:
            return "exp2";
        case BuiltinType::kExtractBits:
            return "extractBits";
        case BuiltinType::kFaceForward:
            return "faceForward";
        case BuiltinType::kFirstLeadingBit:
            return "firstLeadingBit";
        case BuiltinType::kFirstTrailingBit:
            return "firstTrailingBit";
        case BuiltinType::kFloor:
            return "floor";
        case BuiltinType::kFma:
            return "fma";
        case BuiltinType::kFract:
            return "fract";
        case BuiltinType::kFrexp:
            return "frexp";
        case BuiltinType::kFwidth:
            return "fwidth";
        case BuiltinType::kFwidthCoarse:
            return "fwidthCoarse";
        case BuiltinType::kFwidthFine:
            return "fwidthFine";
        case BuiltinType::kInsertBits:
            return "insertBits";
        case BuiltinType::kInverseSqrt:
            return "inverseSqrt";
        case BuiltinType::kLdexp:
            return "ldexp";
        case BuiltinType::kLength:
            return "length";
        case BuiltinType::kLog:
            return "log";
        case BuiltinType::kLog2:
            return "log2";
        case BuiltinType::kMax:
            return "max";
        case BuiltinType::kMin:
            return "min";
        case BuiltinType::kMix:
            return "mix";
        case BuiltinType::kModf:
            return "modf";
        case BuiltinType::kNormalize:
            return "normalize";
        case BuiltinType::kPack2X16Float:
            return "pack2x16float";
        case BuiltinType::kPack2X16Snorm:
            return "pack2x16snorm";
        case BuiltinType::kPack2X16Unorm:
            return "pack2x16unorm";
        case BuiltinType::kPack4X8Snorm:
            return "pack4x8snorm";
        case BuiltinType::kPack4X8Unorm:
            return "pack4x8unorm";
        case BuiltinType::kPow:
            return "pow";
        case BuiltinType::kQuantizeToF16:
            return "quantizeToF16";
        case BuiltinType::kRadians:
            return "radians";
        case BuiltinType::kReflect:
            return "reflect";
        case BuiltinType::kRefract:
            return "refract";
        case BuiltinType::kReverseBits:
            return "reverseBits";
        case BuiltinType::kRound:
            return "round";
        case BuiltinType::kSaturate:
            return "saturate";
        case BuiltinType::kSelect:
            return "select";
        case BuiltinType::kSign:
            return "sign";
        case BuiltinType::kSin:
            return "sin";
        case BuiltinType::kSinh:
            return "sinh";
        case BuiltinType::kSmoothstep:
            return "smoothstep";
        case BuiltinType::kSqrt:
            return "sqrt";
        case BuiltinType::kStep:
            return "step";
        case BuiltinType::kStorageBarrier:
            return "storageBarrier";
        case BuiltinType::kTan:
            return "tan";
        case BuiltinType::kTanh:
            return "tanh";
        case BuiltinType::kTranspose:
            return "transpose";
        case BuiltinType::kTrunc:
            return "trunc";
        case BuiltinType::kUnpack2X16Float:
            return "unpack2x16float";
        case BuiltinType::kUnpack2X16Snorm:
            return "unpack2x16snorm";
        case BuiltinType::kUnpack2X16Unorm:
            return "unpack2x16unorm";
        case BuiltinType::kUnpack4X8Snorm:
            return "unpack4x8snorm";
        case BuiltinType::kUnpack4X8Unorm:
            return "unpack4x8unorm";
        case BuiltinType::kWorkgroupBarrier:
            return "workgroupBarrier";
        case BuiltinType::kWorkgroupUniformLoad:
            return "workgroupUniformLoad";
        case BuiltinType::kTextureDimensions:
            return "textureDimensions";
        case BuiltinType::kTextureGather:
            return "textureGather";
        case BuiltinType::kTextureGatherCompare:
            return "textureGatherCompare";
        case BuiltinType::kTextureNumLayers:
            return "textureNumLayers";
        case BuiltinType::kTextureNumLevels:
            return "textureNumLevels";
        case BuiltinType::kTextureNumSamples:
            return "textureNumSamples";
        case BuiltinType::kTextureSample:
            return "textureSample";
        case BuiltinType::kTextureSampleBias:
            return "textureSampleBias";
        case BuiltinType::kTextureSampleCompare:
            return "textureSampleCompare";
        case BuiltinType::kTextureSampleCompareLevel:
            return "textureSampleCompareLevel";
        case BuiltinType::kTextureSampleGrad:
            return "textureSampleGrad";
        case BuiltinType::kTextureSampleLevel:
            return "textureSampleLevel";
        case BuiltinType::kTextureSampleBaseClampToEdge:
            return "textureSampleBaseClampToEdge";
        case BuiltinType::kTextureStore:
            return "textureStore";
        case BuiltinType::kTextureLoad:
            return "textureLoad";
        case BuiltinType::kAtomicLoad:
            return "atomicLoad";
        case BuiltinType::kAtomicStore:
            return "atomicStore";
        case BuiltinType::kAtomicAdd:
            return "atomicAdd";
        case BuiltinType::kAtomicSub:
            return "atomicSub";
        case BuiltinType::kAtomicMax:
            return "atomicMax";
        case BuiltinType::kAtomicMin:
            return "atomicMin";
        case BuiltinType::kAtomicAnd:
            return "atomicAnd";
        case BuiltinType::kAtomicOr:
            return "atomicOr";
        case BuiltinType::kAtomicXor:
            return "atomicXor";
        case BuiltinType::kAtomicExchange:
            return "atomicExchange";
        case BuiltinType::kAtomicCompareExchangeWeak:
            return "atomicCompareExchangeWeak";
        case BuiltinType::kTintMaterialize:
            return "_tint_materialize";
    }
    return "<unknown>";
}

std::ostream& operator<<(std::ostream& out, BuiltinType i) {
    out << str(i);
    return out;
}

}  // namespace tint::sem
