// Copyright 2021 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/resolver/intrinsic_table.inl.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

// clang-format off

/// TypeMatcher for 'type bool'
class Bool : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Bool::Match(MatchState& state, const type::Type* ty) const {
  if (!match_bool(state, ty)) {
    return nullptr;
  }
  return build_bool(state);
}

std::string Bool::String(MatchState*) const {
  return "bool";
}

/// TypeMatcher for 'type ia'
class Ia : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Ia::Match(MatchState& state, const type::Type* ty) const {
  if (!match_ia(state, ty)) {
    return nullptr;
  }
  return build_ia(state);
}

std::string Ia::String(MatchState*) const {
  std::stringstream ss;
  ss << "abstract-int";
  return ss.str();
}

/// TypeMatcher for 'type fa'
class Fa : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Fa::Match(MatchState& state, const type::Type* ty) const {
  if (!match_fa(state, ty)) {
    return nullptr;
  }
  return build_fa(state);
}

std::string Fa::String(MatchState*) const {
  std::stringstream ss;
  ss << "abstract-float";
  return ss.str();
}

/// TypeMatcher for 'type i32'
class I32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* I32::Match(MatchState& state, const type::Type* ty) const {
  if (!match_i32(state, ty)) {
    return nullptr;
  }
  return build_i32(state);
}

std::string I32::String(MatchState*) const {
  return "i32";
}

/// TypeMatcher for 'type u32'
class U32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* U32::Match(MatchState& state, const type::Type* ty) const {
  if (!match_u32(state, ty)) {
    return nullptr;
  }
  return build_u32(state);
}

std::string U32::String(MatchState*) const {
  return "u32";
}

/// TypeMatcher for 'type f32'
class F32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* F32::Match(MatchState& state, const type::Type* ty) const {
  if (!match_f32(state, ty)) {
    return nullptr;
  }
  return build_f32(state);
}

std::string F32::String(MatchState*) const {
  return "f32";
}

/// TypeMatcher for 'type f16'
class F16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* F16::Match(MatchState& state, const type::Type* ty) const {
  if (!match_f16(state, ty)) {
    return nullptr;
  }
  return build_f16(state);
}

std::string F16::String(MatchState*) const {
  return "f16";
}

/// TypeMatcher for 'type vec2'
class Vec2 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Vec2::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_vec2(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_vec2(state, T);
}

std::string Vec2::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "vec2<" + T + ">";
}

/// TypeMatcher for 'type vec3'
class Vec3 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Vec3::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_vec3(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_vec3(state, T);
}

std::string Vec3::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "vec3<" + T + ">";
}

/// TypeMatcher for 'type vec4'
class Vec4 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Vec4::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_vec4(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_vec4(state, T);
}

std::string Vec4::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "vec4<" + T + ">";
}

/// TypeMatcher for 'type mat2x2'
class Mat2X2 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat2X2::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat2x2(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat2x2(state, T);
}

std::string Mat2X2::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat2x2<" + T + ">";
}

/// TypeMatcher for 'type mat2x3'
class Mat2X3 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat2X3::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat2x3(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat2x3(state, T);
}

std::string Mat2X3::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat2x3<" + T + ">";
}

/// TypeMatcher for 'type mat2x4'
class Mat2X4 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat2X4::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat2x4(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat2x4(state, T);
}

std::string Mat2X4::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat2x4<" + T + ">";
}

/// TypeMatcher for 'type mat3x2'
class Mat3X2 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat3X2::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat3x2(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat3x2(state, T);
}

std::string Mat3X2::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat3x2<" + T + ">";
}

/// TypeMatcher for 'type mat3x3'
class Mat3X3 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat3X3::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat3x3(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat3x3(state, T);
}

std::string Mat3X3::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat3x3<" + T + ">";
}

/// TypeMatcher for 'type mat3x4'
class Mat3X4 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat3X4::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat3x4(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat3x4(state, T);
}

std::string Mat3X4::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat3x4<" + T + ">";
}

/// TypeMatcher for 'type mat4x2'
class Mat4X2 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat4X2::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat4x2(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat4x2(state, T);
}

std::string Mat4X2::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat4x2<" + T + ">";
}

/// TypeMatcher for 'type mat4x3'
class Mat4X3 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat4X3::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat4x3(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat4x3(state, T);
}

std::string Mat4X3::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat4x3<" + T + ">";
}

/// TypeMatcher for 'type mat4x4'
class Mat4X4 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat4X4::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_mat4x4(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat4x4(state, T);
}

std::string Mat4X4::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "mat4x4<" + T + ">";
}

/// TypeMatcher for 'type vec'
class Vec : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Vec::Match(MatchState& state, const type::Type* ty) const {
  Number N = Number::invalid;
  const type::Type* T = nullptr;
  if (!match_vec(state, ty, N, T)) {
    return nullptr;
  }
  N = state.Num(N);
  if (!N.IsValid()) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_vec(state, N, T);
}

std::string Vec::String(MatchState* state) const {
  const std::string N = state->NumName();
  const std::string T = state->TypeName();
  std::stringstream ss;
  ss << "vec" << N << "<" << T << ">";
  return ss.str();
}

/// TypeMatcher for 'type mat'
class Mat : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Mat::Match(MatchState& state, const type::Type* ty) const {
  Number N = Number::invalid;
  Number M = Number::invalid;
  const type::Type* T = nullptr;
  if (!match_mat(state, ty, N, M, T)) {
    return nullptr;
  }
  N = state.Num(N);
  if (!N.IsValid()) {
    return nullptr;
  }
  M = state.Num(M);
  if (!M.IsValid()) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_mat(state, N, M, T);
}

std::string Mat::String(MatchState* state) const {
  const std::string N = state->NumName();
  const std::string M = state->NumName();
  const std::string T = state->TypeName();
  std::stringstream ss;
  ss << "mat" << N << "x" << M << "<" << T << ">";
  return ss.str();
}

/// TypeMatcher for 'type ptr'
class Ptr : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Ptr::Match(MatchState& state, const type::Type* ty) const {
  Number S = Number::invalid;
  const type::Type* T = nullptr;
  Number A = Number::invalid;
  if (!match_ptr(state, ty, S, T, A)) {
    return nullptr;
  }
  S = state.Num(S);
  if (!S.IsValid()) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  A = state.Num(A);
  if (!A.IsValid()) {
    return nullptr;
  }
  return build_ptr(state, S, T, A);
}

std::string Ptr::String(MatchState* state) const {
  const std::string S = state->NumName();
  const std::string T = state->TypeName();
  const std::string A = state->NumName();
  return "ptr<" + S + ", " + T + ", " + A + ">";
}

/// TypeMatcher for 'type atomic'
class Atomic : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Atomic::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_atomic(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_atomic(state, T);
}

std::string Atomic::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "atomic<" + T + ">";
}

/// TypeMatcher for 'type array'
class Array : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Array::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_array(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_array(state, T);
}

std::string Array::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "array<" + T + ">";
}

/// TypeMatcher for 'type sampler'
class Sampler : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Sampler::Match(MatchState& state, const type::Type* ty) const {
  if (!match_sampler(state, ty)) {
    return nullptr;
  }
  return build_sampler(state);
}

std::string Sampler::String(MatchState*) const {
  return "sampler";
}

/// TypeMatcher for 'type sampler_comparison'
class SamplerComparison : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* SamplerComparison::Match(MatchState& state, const type::Type* ty) const {
  if (!match_sampler_comparison(state, ty)) {
    return nullptr;
  }
  return build_sampler_comparison(state);
}

std::string SamplerComparison::String(MatchState*) const {
  return "sampler_comparison";
}

/// TypeMatcher for 'type texture_1d'
class Texture1D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Texture1D::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_texture_1d(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_texture_1d(state, T);
}

std::string Texture1D::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "texture_1d<" + T + ">";
}

/// TypeMatcher for 'type texture_2d'
class Texture2D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Texture2D::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_texture_2d(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_texture_2d(state, T);
}

std::string Texture2D::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "texture_2d<" + T + ">";
}

/// TypeMatcher for 'type texture_2d_array'
class Texture2DArray : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Texture2DArray::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_texture_2d_array(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_texture_2d_array(state, T);
}

std::string Texture2DArray::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "texture_2d_array<" + T + ">";
}

/// TypeMatcher for 'type texture_3d'
class Texture3D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Texture3D::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_texture_3d(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_texture_3d(state, T);
}

std::string Texture3D::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "texture_3d<" + T + ">";
}

/// TypeMatcher for 'type texture_cube'
class TextureCube : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureCube::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_texture_cube(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_texture_cube(state, T);
}

std::string TextureCube::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "texture_cube<" + T + ">";
}

/// TypeMatcher for 'type texture_cube_array'
class TextureCubeArray : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureCubeArray::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_texture_cube_array(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_texture_cube_array(state, T);
}

std::string TextureCubeArray::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "texture_cube_array<" + T + ">";
}

/// TypeMatcher for 'type texture_multisampled_2d'
class TextureMultisampled2D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureMultisampled2D::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_texture_multisampled_2d(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_texture_multisampled_2d(state, T);
}

std::string TextureMultisampled2D::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "texture_multisampled_2d<" + T + ">";
}

/// TypeMatcher for 'type texture_depth_2d'
class TextureDepth2D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureDepth2D::Match(MatchState& state, const type::Type* ty) const {
  if (!match_texture_depth_2d(state, ty)) {
    return nullptr;
  }
  return build_texture_depth_2d(state);
}

std::string TextureDepth2D::String(MatchState*) const {
  return "texture_depth_2d";
}

/// TypeMatcher for 'type texture_depth_2d_array'
class TextureDepth2DArray : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureDepth2DArray::Match(MatchState& state, const type::Type* ty) const {
  if (!match_texture_depth_2d_array(state, ty)) {
    return nullptr;
  }
  return build_texture_depth_2d_array(state);
}

std::string TextureDepth2DArray::String(MatchState*) const {
  return "texture_depth_2d_array";
}

/// TypeMatcher for 'type texture_depth_cube'
class TextureDepthCube : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureDepthCube::Match(MatchState& state, const type::Type* ty) const {
  if (!match_texture_depth_cube(state, ty)) {
    return nullptr;
  }
  return build_texture_depth_cube(state);
}

std::string TextureDepthCube::String(MatchState*) const {
  return "texture_depth_cube";
}

/// TypeMatcher for 'type texture_depth_cube_array'
class TextureDepthCubeArray : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureDepthCubeArray::Match(MatchState& state, const type::Type* ty) const {
  if (!match_texture_depth_cube_array(state, ty)) {
    return nullptr;
  }
  return build_texture_depth_cube_array(state);
}

std::string TextureDepthCubeArray::String(MatchState*) const {
  return "texture_depth_cube_array";
}

/// TypeMatcher for 'type texture_depth_multisampled_2d'
class TextureDepthMultisampled2D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureDepthMultisampled2D::Match(MatchState& state, const type::Type* ty) const {
  if (!match_texture_depth_multisampled_2d(state, ty)) {
    return nullptr;
  }
  return build_texture_depth_multisampled_2d(state);
}

std::string TextureDepthMultisampled2D::String(MatchState*) const {
  return "texture_depth_multisampled_2d";
}

/// TypeMatcher for 'type texture_storage_1d'
class TextureStorage1D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureStorage1D::Match(MatchState& state, const type::Type* ty) const {
  Number F = Number::invalid;
  Number A = Number::invalid;
  if (!match_texture_storage_1d(state, ty, F, A)) {
    return nullptr;
  }
  F = state.Num(F);
  if (!F.IsValid()) {
    return nullptr;
  }
  A = state.Num(A);
  if (!A.IsValid()) {
    return nullptr;
  }
  return build_texture_storage_1d(state, F, A);
}

std::string TextureStorage1D::String(MatchState* state) const {
  const std::string F = state->NumName();
  const std::string A = state->NumName();
  return "texture_storage_1d<" + F + ", " + A + ">";
}

/// TypeMatcher for 'type texture_storage_2d'
class TextureStorage2D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureStorage2D::Match(MatchState& state, const type::Type* ty) const {
  Number F = Number::invalid;
  Number A = Number::invalid;
  if (!match_texture_storage_2d(state, ty, F, A)) {
    return nullptr;
  }
  F = state.Num(F);
  if (!F.IsValid()) {
    return nullptr;
  }
  A = state.Num(A);
  if (!A.IsValid()) {
    return nullptr;
  }
  return build_texture_storage_2d(state, F, A);
}

std::string TextureStorage2D::String(MatchState* state) const {
  const std::string F = state->NumName();
  const std::string A = state->NumName();
  return "texture_storage_2d<" + F + ", " + A + ">";
}

/// TypeMatcher for 'type texture_storage_2d_array'
class TextureStorage2DArray : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureStorage2DArray::Match(MatchState& state, const type::Type* ty) const {
  Number F = Number::invalid;
  Number A = Number::invalid;
  if (!match_texture_storage_2d_array(state, ty, F, A)) {
    return nullptr;
  }
  F = state.Num(F);
  if (!F.IsValid()) {
    return nullptr;
  }
  A = state.Num(A);
  if (!A.IsValid()) {
    return nullptr;
  }
  return build_texture_storage_2d_array(state, F, A);
}

std::string TextureStorage2DArray::String(MatchState* state) const {
  const std::string F = state->NumName();
  const std::string A = state->NumName();
  return "texture_storage_2d_array<" + F + ", " + A + ">";
}

/// TypeMatcher for 'type texture_storage_3d'
class TextureStorage3D : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureStorage3D::Match(MatchState& state, const type::Type* ty) const {
  Number F = Number::invalid;
  Number A = Number::invalid;
  if (!match_texture_storage_3d(state, ty, F, A)) {
    return nullptr;
  }
  F = state.Num(F);
  if (!F.IsValid()) {
    return nullptr;
  }
  A = state.Num(A);
  if (!A.IsValid()) {
    return nullptr;
  }
  return build_texture_storage_3d(state, F, A);
}

std::string TextureStorage3D::String(MatchState* state) const {
  const std::string F = state->NumName();
  const std::string A = state->NumName();
  return "texture_storage_3d<" + F + ", " + A + ">";
}

/// TypeMatcher for 'type texture_external'
class TextureExternal : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* TextureExternal::Match(MatchState& state, const type::Type* ty) const {
  if (!match_texture_external(state, ty)) {
    return nullptr;
  }
  return build_texture_external(state);
}

std::string TextureExternal::String(MatchState*) const {
  return "texture_external";
}

/// TypeMatcher for 'type __modf_result'
class ModfResult : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ModfResult::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_modf_result(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_modf_result(state, T);
}

std::string ModfResult::String(MatchState* state) const {
  const std::string T = state->TypeName();
  std::stringstream ss;
  ss << "__modf_result_" << T;
  return ss.str();
}

/// TypeMatcher for 'type __modf_result_vec'
class ModfResultVec : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ModfResultVec::Match(MatchState& state, const type::Type* ty) const {
  Number N = Number::invalid;
  const type::Type* T = nullptr;
  if (!match_modf_result_vec(state, ty, N, T)) {
    return nullptr;
  }
  N = state.Num(N);
  if (!N.IsValid()) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_modf_result_vec(state, N, T);
}

std::string ModfResultVec::String(MatchState* state) const {
  const std::string N = state->NumName();
  const std::string T = state->TypeName();
  std::stringstream ss;
  ss << "__modf_result_vec" << N << "_" << T;
  return ss.str();
}

/// TypeMatcher for 'type __frexp_result'
class FrexpResult : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* FrexpResult::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_frexp_result(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_frexp_result(state, T);
}

std::string FrexpResult::String(MatchState* state) const {
  const std::string T = state->TypeName();
  std::stringstream ss;
  ss << "__frexp_result_" << T;
  return ss.str();
}

/// TypeMatcher for 'type __frexp_result_vec'
class FrexpResultVec : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* FrexpResultVec::Match(MatchState& state, const type::Type* ty) const {
  Number N = Number::invalid;
  const type::Type* T = nullptr;
  if (!match_frexp_result_vec(state, ty, N, T)) {
    return nullptr;
  }
  N = state.Num(N);
  if (!N.IsValid()) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_frexp_result_vec(state, N, T);
}

std::string FrexpResultVec::String(MatchState* state) const {
  const std::string N = state->NumName();
  const std::string T = state->TypeName();
  std::stringstream ss;
  ss << "__frexp_result_vec" << N << "_" << T;
  return ss.str();
}

/// TypeMatcher for 'type __atomic_compare_exchange_result'
class AtomicCompareExchangeResult : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* AtomicCompareExchangeResult::Match(MatchState& state, const type::Type* ty) const {
  const type::Type* T = nullptr;
  if (!match_atomic_compare_exchange_result(state, ty, T)) {
    return nullptr;
  }
  T = state.Type(T);
  if (T == nullptr) {
    return nullptr;
  }
  return build_atomic_compare_exchange_result(state, T);
}

std::string AtomicCompareExchangeResult::String(MatchState* state) const {
  const std::string T = state->TypeName();
  return "__atomic_compare_exchange_result<" + T + ">";
}

/// TypeMatcher for 'match scalar'
class Scalar : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Scalar::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  if (match_bool(state, ty)) {
    return build_bool(state);
  }
  return nullptr;
}

std::string Scalar::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << ", " << Fa().String(nullptr) << ", " << F32().String(nullptr) << ", " << F16().String(nullptr) << ", " << I32().String(nullptr) << ", " << U32().String(nullptr) << " or " << Bool().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match concrete_scalar'
class ConcreteScalar : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ConcreteScalar::Match(MatchState& state, const type::Type* ty) const {
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  if (match_bool(state, ty)) {
    return build_bool(state);
  }
  return nullptr;
}

std::string ConcreteScalar::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << F32().String(nullptr) << ", " << F16().String(nullptr) << ", " << I32().String(nullptr) << ", " << U32().String(nullptr) << " or " << Bool().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match scalar_no_f32'
class ScalarNoF32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ScalarNoF32::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  if (match_bool(state, ty)) {
    return build_bool(state);
  }
  return nullptr;
}

std::string ScalarNoF32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << ", " << Fa().String(nullptr) << ", " << I32().String(nullptr) << ", " << F16().String(nullptr) << ", " << U32().String(nullptr) << " or " << Bool().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match scalar_no_f16'
class ScalarNoF16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ScalarNoF16::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_bool(state, ty)) {
    return build_bool(state);
  }
  return nullptr;
}

std::string ScalarNoF16::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << ", " << Fa().String(nullptr) << ", " << F32().String(nullptr) << ", " << I32().String(nullptr) << ", " << U32().String(nullptr) << " or " << Bool().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match scalar_no_i32'
class ScalarNoI32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ScalarNoI32::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  if (match_bool(state, ty)) {
    return build_bool(state);
  }
  return nullptr;
}

std::string ScalarNoI32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << ", " << Fa().String(nullptr) << ", " << F32().String(nullptr) << ", " << F16().String(nullptr) << ", " << U32().String(nullptr) << " or " << Bool().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match scalar_no_u32'
class ScalarNoU32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ScalarNoU32::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  if (match_bool(state, ty)) {
    return build_bool(state);
  }
  return nullptr;
}

std::string ScalarNoU32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << ", " << Fa().String(nullptr) << ", " << F32().String(nullptr) << ", " << F16().String(nullptr) << ", " << I32().String(nullptr) << " or " << Bool().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match scalar_no_bool'
class ScalarNoBool : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* ScalarNoBool::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  return nullptr;
}

std::string ScalarNoBool::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << ", " << Fa().String(nullptr) << ", " << F32().String(nullptr) << ", " << F16().String(nullptr) << ", " << I32().String(nullptr) << " or " << U32().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fia_fiu32_f16'
class FiaFiu32F16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* FiaFiu32F16::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  return nullptr;
}

std::string FiaFiu32F16::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Fa().String(nullptr) << ", " << Ia().String(nullptr) << ", " << F32().String(nullptr) << ", " << I32().String(nullptr) << ", " << U32().String(nullptr) << " or " << F16().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fia_fi32_f16'
class FiaFi32F16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* FiaFi32F16::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  return nullptr;
}

std::string FiaFi32F16::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Fa().String(nullptr) << ", " << Ia().String(nullptr) << ", " << F32().String(nullptr) << ", " << I32().String(nullptr) << " or " << F16().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fia_fiu32'
class FiaFiu32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* FiaFiu32::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  return nullptr;
}

std::string FiaFiu32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Fa().String(nullptr) << ", " << Ia().String(nullptr) << ", " << F32().String(nullptr) << ", " << I32().String(nullptr) << " or " << U32().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fa_f32'
class FaF32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* FaF32::Match(MatchState& state, const type::Type* ty) const {
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  return nullptr;
}

std::string FaF32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Fa().String(nullptr) << " or " << F32().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fa_f32_f16'
class FaF32F16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* FaF32F16::Match(MatchState& state, const type::Type* ty) const {
  if (match_fa(state, ty)) {
    return build_fa(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  return nullptr;
}

std::string FaF32F16::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Fa().String(nullptr) << ", " << F32().String(nullptr) << " or " << F16().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match ia_iu32'
class IaIu32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* IaIu32::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  return nullptr;
}

std::string IaIu32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << ", " << I32().String(nullptr) << " or " << U32().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match ia_i32'
class IaI32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* IaI32::Match(MatchState& state, const type::Type* ty) const {
  if (match_ia(state, ty)) {
    return build_ia(state);
  }
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  return nullptr;
}

std::string IaI32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << Ia().String(nullptr) << " or " << I32().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fiu32_f16'
class Fiu32F16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Fiu32F16::Match(MatchState& state, const type::Type* ty) const {
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  return nullptr;
}

std::string Fiu32F16::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << F32().String(nullptr) << ", " << I32().String(nullptr) << ", " << U32().String(nullptr) << " or " << F16().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fiu32'
class Fiu32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Fiu32::Match(MatchState& state, const type::Type* ty) const {
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  return nullptr;
}

std::string Fiu32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << F32().String(nullptr) << ", " << I32().String(nullptr) << " or " << U32().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fi32_f16'
class Fi32F16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Fi32F16::Match(MatchState& state, const type::Type* ty) const {
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  return nullptr;
}

std::string Fi32F16::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << F32().String(nullptr) << ", " << I32().String(nullptr) << " or " << F16().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match fi32'
class Fi32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Fi32::Match(MatchState& state, const type::Type* ty) const {
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  return nullptr;
}

std::string Fi32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << F32().String(nullptr) << " or " << I32().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match f32_f16'
class F32F16 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* F32F16::Match(MatchState& state, const type::Type* ty) const {
  if (match_f32(state, ty)) {
    return build_f32(state);
  }
  if (match_f16(state, ty)) {
    return build_f16(state);
  }
  return nullptr;
}

std::string F32F16::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << F32().String(nullptr) << " or " << F16().String(nullptr);
  return ss.str();
}

/// TypeMatcher for 'match iu32'
class Iu32 : public TypeMatcher {
 public:
  /// Checks whether the given type matches the matcher rules, and returns the
  /// expected, canonicalized type on success.
  /// Match may define and refine the template types and numbers in state.
  /// @param state the MatchState
  /// @param type the type to match
  /// @returns the canonicalized type on match, otherwise nullptr
  const type::Type* Match(MatchState& state,
                         const type::Type* type) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

const type::Type* Iu32::Match(MatchState& state, const type::Type* ty) const {
  if (match_i32(state, ty)) {
    return build_i32(state);
  }
  if (match_u32(state, ty)) {
    return build_u32(state);
  }
  return nullptr;
}

std::string Iu32::String(MatchState*) const {
  std::stringstream ss;
  // Note: We pass nullptr to the TypeMatcher::String() functions, as 'matcher's do not support
  // template arguments, nor can they match sub-types. As such, they have no use for the MatchState.
  ss << I32().String(nullptr) << " or " << U32().String(nullptr);
  return ss.str();
}

/// EnumMatcher for 'match f32_texel_format'
class F32TexelFormat : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number F32TexelFormat::Match(MatchState&, Number number) const {
  switch (static_cast<TexelFormat>(number.Value())) {
    case TexelFormat::kBgra8Unorm:
    case TexelFormat::kRgba8Unorm:
    case TexelFormat::kRgba8Snorm:
    case TexelFormat::kRgba16Float:
    case TexelFormat::kR32Float:
    case TexelFormat::kRg32Float:
    case TexelFormat::kRgba32Float:
      return number;
    default:
      return Number::invalid;
  }
}

std::string F32TexelFormat::String(MatchState*) const {
  return "bgra8unorm, rgba8unorm, rgba8snorm, rgba16float, r32float, rg32float or rgba32float";
}

/// EnumMatcher for 'match i32_texel_format'
class I32TexelFormat : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number I32TexelFormat::Match(MatchState&, Number number) const {
  switch (static_cast<TexelFormat>(number.Value())) {
    case TexelFormat::kRgba8Sint:
    case TexelFormat::kRgba16Sint:
    case TexelFormat::kR32Sint:
    case TexelFormat::kRg32Sint:
    case TexelFormat::kRgba32Sint:
      return number;
    default:
      return Number::invalid;
  }
}

std::string I32TexelFormat::String(MatchState*) const {
  return "rgba8sint, rgba16sint, r32sint, rg32sint or rgba32sint";
}

/// EnumMatcher for 'match u32_texel_format'
class U32TexelFormat : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number U32TexelFormat::Match(MatchState&, Number number) const {
  switch (static_cast<TexelFormat>(number.Value())) {
    case TexelFormat::kRgba8Uint:
    case TexelFormat::kRgba16Uint:
    case TexelFormat::kR32Uint:
    case TexelFormat::kRg32Uint:
    case TexelFormat::kRgba32Uint:
      return number;
    default:
      return Number::invalid;
  }
}

std::string U32TexelFormat::String(MatchState*) const {
  return "rgba8uint, rgba16uint, r32uint, rg32uint or rgba32uint";
}

/// EnumMatcher for 'match write'
class Write : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number Write::Match(MatchState&, Number number) const {
  if (number.IsAny() || number.Value() == static_cast<uint32_t>(Access::kWrite)) {
    return Number(static_cast<uint32_t>(Access::kWrite));
  }
  return Number::invalid;
}

std::string Write::String(MatchState*) const {
  return "write";
}

/// EnumMatcher for 'match read_write'
class ReadWrite : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number ReadWrite::Match(MatchState&, Number number) const {
  if (number.IsAny() || number.Value() == static_cast<uint32_t>(Access::kReadWrite)) {
    return Number(static_cast<uint32_t>(Access::kReadWrite));
  }
  return Number::invalid;
}

std::string ReadWrite::String(MatchState*) const {
  return "read_write";
}

/// EnumMatcher for 'match function_private_workgroup'
class FunctionPrivateWorkgroup : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number FunctionPrivateWorkgroup::Match(MatchState&, Number number) const {
  switch (static_cast<AddressSpace>(number.Value())) {
    case AddressSpace::kFunction:
    case AddressSpace::kPrivate:
    case AddressSpace::kWorkgroup:
      return number;
    default:
      return Number::invalid;
  }
}

std::string FunctionPrivateWorkgroup::String(MatchState*) const {
  return "function, private or workgroup";
}

/// EnumMatcher for 'match workgroup_or_storage'
class WorkgroupOrStorage : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number WorkgroupOrStorage::Match(MatchState&, Number number) const {
  switch (static_cast<AddressSpace>(number.Value())) {
    case AddressSpace::kWorkgroup:
    case AddressSpace::kStorage:
      return number;
    default:
      return Number::invalid;
  }
}

std::string WorkgroupOrStorage::String(MatchState*) const {
  return "workgroup or storage";
}

/// EnumMatcher for 'match storage'
class Storage : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number Storage::Match(MatchState&, Number number) const {
  if (number.IsAny() || number.Value() == static_cast<uint32_t>(AddressSpace::kStorage)) {
    return Number(static_cast<uint32_t>(AddressSpace::kStorage));
  }
  return Number::invalid;
}

std::string Storage::String(MatchState*) const {
  return "storage";
}

/// EnumMatcher for 'match workgroup'
class Workgroup : public NumberMatcher {
 public:
  /// Checks whether the given number matches the enum matcher rules.
  /// Match may define template numbers in state.
  /// @param state the MatchState
  /// @param number the enum value as a Number
  /// @return true if the enum value matches the set
  Number Match(MatchState& state, Number number) const override;
  /// @param state the MatchState
  /// @return a string representation of the matcher.
  std::string String(MatchState* state) const override;
};

Number Workgroup::Match(MatchState&, Number number) const {
  if (number.IsAny() || number.Value() == static_cast<uint32_t>(AddressSpace::kWorkgroup)) {
    return Number(static_cast<uint32_t>(AddressSpace::kWorkgroup));
  }
  return Number::invalid;
}

std::string Workgroup::String(MatchState*) const {
  return "workgroup";
}

/// Matchers holds type and number matchers
class Matchers {
 private:
  TemplateTypeMatcher template_type_0_{0};
  TemplateTypeMatcher template_type_1_{1};
  TemplateTypeMatcher template_type_2_{2};
  TemplateTypeMatcher template_type_3_{3};
  TemplateNumberMatcher template_number_0_{0};
  TemplateNumberMatcher template_number_1_{1};
  TemplateNumberMatcher template_number_2_{2};
  Bool Bool_;
  Ia Ia_;
  Fa Fa_;
  I32 I32_;
  U32 U32_;
  F32 F32_;
  F16 F16_;
  Vec2 Vec2_;
  Vec3 Vec3_;
  Vec4 Vec4_;
  Mat2X2 Mat2X2_;
  Mat2X3 Mat2X3_;
  Mat2X4 Mat2X4_;
  Mat3X2 Mat3X2_;
  Mat3X3 Mat3X3_;
  Mat3X4 Mat3X4_;
  Mat4X2 Mat4X2_;
  Mat4X3 Mat4X3_;
  Mat4X4 Mat4X4_;
  Vec Vec_;
  Mat Mat_;
  Ptr Ptr_;
  Atomic Atomic_;
  Array Array_;
  Sampler Sampler_;
  SamplerComparison SamplerComparison_;
  Texture1D Texture1D_;
  Texture2D Texture2D_;
  Texture2DArray Texture2DArray_;
  Texture3D Texture3D_;
  TextureCube TextureCube_;
  TextureCubeArray TextureCubeArray_;
  TextureMultisampled2D TextureMultisampled2D_;
  TextureDepth2D TextureDepth2D_;
  TextureDepth2DArray TextureDepth2DArray_;
  TextureDepthCube TextureDepthCube_;
  TextureDepthCubeArray TextureDepthCubeArray_;
  TextureDepthMultisampled2D TextureDepthMultisampled2D_;
  TextureStorage1D TextureStorage1D_;
  TextureStorage2D TextureStorage2D_;
  TextureStorage2DArray TextureStorage2DArray_;
  TextureStorage3D TextureStorage3D_;
  TextureExternal TextureExternal_;
  ModfResult ModfResult_;
  ModfResultVec ModfResultVec_;
  FrexpResult FrexpResult_;
  FrexpResultVec FrexpResultVec_;
  AtomicCompareExchangeResult AtomicCompareExchangeResult_;
  Scalar Scalar_;
  ConcreteScalar ConcreteScalar_;
  ScalarNoF32 ScalarNoF32_;
  ScalarNoF16 ScalarNoF16_;
  ScalarNoI32 ScalarNoI32_;
  ScalarNoU32 ScalarNoU32_;
  ScalarNoBool ScalarNoBool_;
  FiaFiu32F16 FiaFiu32F16_;
  FiaFi32F16 FiaFi32F16_;
  FiaFiu32 FiaFiu32_;
  FaF32 FaF32_;
  FaF32F16 FaF32F16_;
  IaIu32 IaIu32_;
  IaI32 IaI32_;
  Fiu32F16 Fiu32F16_;
  Fiu32 Fiu32_;
  Fi32F16 Fi32F16_;
  Fi32 Fi32_;
  F32F16 F32F16_;
  Iu32 Iu32_;
  F32TexelFormat F32TexelFormat_;
  I32TexelFormat I32TexelFormat_;
  U32TexelFormat U32TexelFormat_;
  Write Write_;
  ReadWrite ReadWrite_;
  FunctionPrivateWorkgroup FunctionPrivateWorkgroup_;
  WorkgroupOrStorage WorkgroupOrStorage_;
  Storage Storage_;
  Workgroup Workgroup_;

 public:
  /// Constructor
  Matchers();
  /// Destructor
  ~Matchers();

  /// The template types, types, and type matchers
  TypeMatcher const* const type[72] = {
    /* [0] */ &template_type_0_,
    /* [1] */ &template_type_1_,
    /* [2] */ &template_type_2_,
    /* [3] */ &template_type_3_,
    /* [4] */ &Bool_,
    /* [5] */ &Ia_,
    /* [6] */ &Fa_,
    /* [7] */ &I32_,
    /* [8] */ &U32_,
    /* [9] */ &F32_,
    /* [10] */ &F16_,
    /* [11] */ &Vec2_,
    /* [12] */ &Vec3_,
    /* [13] */ &Vec4_,
    /* [14] */ &Mat2X2_,
    /* [15] */ &Mat2X3_,
    /* [16] */ &Mat2X4_,
    /* [17] */ &Mat3X2_,
    /* [18] */ &Mat3X3_,
    /* [19] */ &Mat3X4_,
    /* [20] */ &Mat4X2_,
    /* [21] */ &Mat4X3_,
    /* [22] */ &Mat4X4_,
    /* [23] */ &Vec_,
    /* [24] */ &Mat_,
    /* [25] */ &Ptr_,
    /* [26] */ &Atomic_,
    /* [27] */ &Array_,
    /* [28] */ &Sampler_,
    /* [29] */ &SamplerComparison_,
    /* [30] */ &Texture1D_,
    /* [31] */ &Texture2D_,
    /* [32] */ &Texture2DArray_,
    /* [33] */ &Texture3D_,
    /* [34] */ &TextureCube_,
    /* [35] */ &TextureCubeArray_,
    /* [36] */ &TextureMultisampled2D_,
    /* [37] */ &TextureDepth2D_,
    /* [38] */ &TextureDepth2DArray_,
    /* [39] */ &TextureDepthCube_,
    /* [40] */ &TextureDepthCubeArray_,
    /* [41] */ &TextureDepthMultisampled2D_,
    /* [42] */ &TextureStorage1D_,
    /* [43] */ &TextureStorage2D_,
    /* [44] */ &TextureStorage2DArray_,
    /* [45] */ &TextureStorage3D_,
    /* [46] */ &TextureExternal_,
    /* [47] */ &ModfResult_,
    /* [48] */ &ModfResultVec_,
    /* [49] */ &FrexpResult_,
    /* [50] */ &FrexpResultVec_,
    /* [51] */ &AtomicCompareExchangeResult_,
    /* [52] */ &Scalar_,
    /* [53] */ &ConcreteScalar_,
    /* [54] */ &ScalarNoF32_,
    /* [55] */ &ScalarNoF16_,
    /* [56] */ &ScalarNoI32_,
    /* [57] */ &ScalarNoU32_,
    /* [58] */ &ScalarNoBool_,
    /* [59] */ &FiaFiu32F16_,
    /* [60] */ &FiaFi32F16_,
    /* [61] */ &FiaFiu32_,
    /* [62] */ &FaF32_,
    /* [63] */ &FaF32F16_,
    /* [64] */ &IaIu32_,
    /* [65] */ &IaI32_,
    /* [66] */ &Fiu32F16_,
    /* [67] */ &Fiu32_,
    /* [68] */ &Fi32F16_,
    /* [69] */ &Fi32_,
    /* [70] */ &F32F16_,
    /* [71] */ &Iu32_,
  };

  /// The template numbers, and number matchers
  NumberMatcher const* const number[12] = {
    /* [0] */ &template_number_0_,
    /* [1] */ &template_number_1_,
    /* [2] */ &template_number_2_,
    /* [3] */ &F32TexelFormat_,
    /* [4] */ &I32TexelFormat_,
    /* [5] */ &U32TexelFormat_,
    /* [6] */ &Write_,
    /* [7] */ &ReadWrite_,
    /* [8] */ &FunctionPrivateWorkgroup_,
    /* [9] */ &WorkgroupOrStorage_,
    /* [10] */ &Storage_,
    /* [11] */ &Workgroup_,
  };
};

Matchers::Matchers() = default;
Matchers::~Matchers() = default;

constexpr MatcherIndex kMatcherIndices[] = {
  /* [0] */ 25,
  /* [1] */ 10,
  /* [2] */ 27,
  /* [3] */ 0,
  /* [4] */ 0,
  /* [5] */ 25,
  /* [6] */ 0,
  /* [7] */ 26,
  /* [8] */ 0,
  /* [9] */ 7,
  /* [10] */ 24,
  /* [11] */ 0,
  /* [12] */ 0,
  /* [13] */ 0,
  /* [14] */ 24,
  /* [15] */ 0,
  /* [16] */ 1,
  /* [17] */ 0,
  /* [18] */ 24,
  /* [19] */ 1,
  /* [20] */ 0,
  /* [21] */ 0,
  /* [22] */ 25,
  /* [23] */ 11,
  /* [24] */ 0,
  /* [25] */ 7,
  /* [26] */ 24,
  /* [27] */ 0,
  /* [28] */ 2,
  /* [29] */ 0,
  /* [30] */ 24,
  /* [31] */ 1,
  /* [32] */ 2,
  /* [33] */ 0,
  /* [34] */ 23,
  /* [35] */ 0,
  /* [36] */ 0,
  /* [37] */ 23,
  /* [38] */ 0,
  /* [39] */ 4,
  /* [40] */ 23,
  /* [41] */ 0,
  /* [42] */ 9,
  /* [43] */ 50,
  /* [44] */ 0,
  /* [45] */ 0,
  /* [46] */ 23,
  /* [47] */ 0,
  /* [48] */ 1,
  /* [49] */ 48,
  /* [50] */ 0,
  /* [51] */ 0,
  /* [52] */ 42,
  /* [53] */ 0,
  /* [54] */ 1,
  /* [55] */ 43,
  /* [56] */ 0,
  /* [57] */ 1,
  /* [58] */ 44,
  /* [59] */ 0,
  /* [60] */ 1,
  /* [61] */ 45,
  /* [62] */ 0,
  /* [63] */ 1,
  /* [64] */ 42,
  /* [65] */ 3,
  /* [66] */ 6,
  /* [67] */ 43,
  /* [68] */ 3,
  /* [69] */ 6,
  /* [70] */ 44,
  /* [71] */ 3,
  /* [72] */ 6,
  /* [73] */ 45,
  /* [74] */ 3,
  /* [75] */ 6,
  /* [76] */ 42,
  /* [77] */ 4,
  /* [78] */ 6,
  /* [79] */ 43,
  /* [80] */ 4,
  /* [81] */ 6,
  /* [82] */ 44,
  /* [83] */ 4,
  /* [84] */ 6,
  /* [85] */ 45,
  /* [86] */ 4,
  /* [87] */ 6,
  /* [88] */ 42,
  /* [89] */ 5,
  /* [90] */ 6,
  /* [91] */ 43,
  /* [92] */ 5,
  /* [93] */ 6,
  /* [94] */ 44,
  /* [95] */ 5,
  /* [96] */ 6,
  /* [97] */ 45,
  /* [98] */ 5,
  /* [99] */ 6,
  /* [100] */ 23,
  /* [101] */ 1,
  /* [102] */ 0,
  /* [103] */ 23,
  /* [104] */ 0,
  /* [105] */ 8,
  /* [106] */ 12,
  /* [107] */ 0,
  /* [108] */ 49,
  /* [109] */ 0,
  /* [110] */ 47,
  /* [111] */ 0,
  /* [112] */ 11,
  /* [113] */ 9,
  /* [114] */ 13,
  /* [115] */ 9,
  /* [116] */ 30,
  /* [117] */ 0,
  /* [118] */ 31,
  /* [119] */ 0,
  /* [120] */ 11,
  /* [121] */ 8,
  /* [122] */ 32,
  /* [123] */ 0,
  /* [124] */ 33,
  /* [125] */ 0,
  /* [126] */ 12,
  /* [127] */ 8,
  /* [128] */ 34,
  /* [129] */ 0,
  /* [130] */ 35,
  /* [131] */ 0,
  /* [132] */ 36,
  /* [133] */ 0,
  /* [134] */ 13,
  /* [135] */ 0,
  /* [136] */ 11,
  /* [137] */ 7,
  /* [138] */ 12,
  /* [139] */ 9,
  /* [140] */ 30,
  /* [141] */ 9,
  /* [142] */ 31,
  /* [143] */ 9,
  /* [144] */ 32,
  /* [145] */ 9,
  /* [146] */ 33,
  /* [147] */ 9,
  /* [148] */ 12,
  /* [149] */ 7,
  /* [150] */ 34,
  /* [151] */ 9,
  /* [152] */ 35,
  /* [153] */ 9,
  /* [154] */ 13,
  /* [155] */ 7,
  /* [156] */ 13,
  /* [157] */ 8,
  /* [158] */ 11,
  /* [159] */ 1,
  /* [160] */ 12,
  /* [161] */ 1,
  /* [162] */ 51,
  /* [163] */ 0,
  /* [164] */ 11,
  /* [165] */ 10,
  /* [166] */ 11,
  /* [167] */ 4,
  /* [168] */ 12,
  /* [169] */ 10,
  /* [170] */ 12,
  /* [171] */ 4,
  /* [172] */ 13,
  /* [173] */ 1,
  /* [174] */ 13,
  /* [175] */ 10,
  /* [176] */ 13,
  /* [177] */ 4,
  /* [178] */ 14,
  /* [179] */ 0,
  /* [180] */ 14,
  /* [181] */ 9,
  /* [182] */ 14,
  /* [183] */ 10,
  /* [184] */ 15,
  /* [185] */ 0,
  /* [186] */ 15,
  /* [187] */ 9,
  /* [188] */ 15,
  /* [189] */ 10,
  /* [190] */ 16,
  /* [191] */ 0,
  /* [192] */ 16,
  /* [193] */ 9,
  /* [194] */ 16,
  /* [195] */ 10,
  /* [196] */ 17,
  /* [197] */ 0,
  /* [198] */ 17,
  /* [199] */ 9,
  /* [200] */ 17,
  /* [201] */ 10,
  /* [202] */ 18,
  /* [203] */ 0,
  /* [204] */ 18,
  /* [205] */ 9,
  /* [206] */ 18,
  /* [207] */ 10,
  /* [208] */ 19,
  /* [209] */ 0,
  /* [210] */ 19,
  /* [211] */ 9,
  /* [212] */ 19,
  /* [213] */ 10,
  /* [214] */ 20,
  /* [215] */ 0,
  /* [216] */ 20,
  /* [217] */ 9,
  /* [218] */ 20,
  /* [219] */ 10,
  /* [220] */ 21,
  /* [221] */ 0,
  /* [222] */ 21,
  /* [223] */ 9,
  /* [224] */ 21,
  /* [225] */ 10,
  /* [226] */ 22,
  /* [227] */ 0,
  /* [228] */ 22,
  /* [229] */ 9,
  /* [230] */ 22,
  /* [231] */ 10,
  /* [232] */ 37,
  /* [233] */ 38,
  /* [234] */ 39,
  /* [235] */ 40,
  /* [236] */ 41,
  /* [237] */ 46,
  /* [238] */ 28,
  /* [239] */ 29,
};

// Assert that the MatcherIndex is big enough to index all the matchers, plus
// kNoMatcher.
static_assert(static_cast<int>(sizeof(kMatcherIndices) / sizeof(kMatcherIndices[0])) <
              static_cast<int>(std::numeric_limits<MatcherIndex>::max() - 1),
              "MatcherIndex is not large enough to index kMatcherIndices");

constexpr ParameterInfo kParameters[] = {
  {
    /* [0] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [1] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [2] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [3] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [4] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [5] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [6] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [7] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [8] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [9] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [10] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [11] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [12] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [13] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [14] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [15] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [16] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [17] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [18] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [19] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [20] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [21] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [22] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [23] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [24] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [25] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [26] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [27] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [28] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [29] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [30] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [31] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [32] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [33] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [34] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [35] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [36] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [37] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [38] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [39] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [40] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [41] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [42] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [43] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [44] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [45] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [46] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [47] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [48] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [49] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [50] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [51] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [52] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [53] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [54] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [55] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [56] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [57] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [58] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [59] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [60] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [61] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [62] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [63] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [64] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [65] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [66] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [67] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [68] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [69] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [70] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [71] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [72] */
    /* usage */ ParameterUsage::kComponent,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [73] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[122],
  },
  {
    /* [74] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [75] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [76] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [77] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [78] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [79] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [80] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [81] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [82] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [83] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [84] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [85] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [86] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [87] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [88] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [89] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [90] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [91] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [92] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [93] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [94] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [95] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [96] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [97] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [98] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [99] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [100] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [101] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [102] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [103] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [104] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [105] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [106] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [107] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [108] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [109] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [110] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [111] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [112] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [113] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [114] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [115] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [116] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [117] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [118] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [119] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[148],
  },
  {
    /* [120] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[152],
  },
  {
    /* [121] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [122] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [123] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [124] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [125] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [126] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [127] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [128] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [129] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [130] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [131] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [132] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [133] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [134] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [135] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [136] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [137] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [138] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [139] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [140] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [141] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [142] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [143] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [144] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [145] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [146] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [147] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [148] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [149] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [150] */
    /* usage */ ParameterUsage::kComponent,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [151] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[118],
  },
  {
    /* [152] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [153] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [154] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [155] */
    /* usage */ ParameterUsage::kComponent,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [156] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[122],
  },
  {
    /* [157] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [158] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [159] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [160] */
    /* usage */ ParameterUsage::kComponent,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [161] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[130],
  },
  {
    /* [162] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [163] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [164] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [165] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [166] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [167] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [168] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [169] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [170] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [171] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [172] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [173] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [174] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [175] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [176] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [177] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [178] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [179] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [180] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [181] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [182] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [183] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [184] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [185] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [186] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [187] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [188] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [189] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [190] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [191] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [192] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [193] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [194] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [195] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [196] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [197] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [198] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [199] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [200] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [201] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [202] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [203] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [204] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [205] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [206] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [207] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [208] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [209] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[148],
  },
  {
    /* [210] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[152],
  },
  {
    /* [211] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [212] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [213] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [214] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [215] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [216] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [217] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [218] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [219] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [220] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [221] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [222] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [223] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [224] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [225] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [226] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [227] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [228] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [229] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [230] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [231] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [232] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [233] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [234] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [235] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [236] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [237] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [238] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [239] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [240] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [241] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [242] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [243] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [244] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [245] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [246] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [247] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [248] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [249] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [250] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [251] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [252] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [253] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [254] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [255] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[150],
  },
  {
    /* [256] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [257] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [258] */
    /* usage */ ParameterUsage::kDdx,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [259] */
    /* usage */ ParameterUsage::kDdy,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [260] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [261] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [262] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [263] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [264] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [265] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [266] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [267] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [268] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [269] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [270] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [271] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [272] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [273] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [274] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[148],
  },
  {
    /* [275] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[152],
  },
  {
    /* [276] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [277] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [278] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [279] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [280] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [281] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [282] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [283] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [284] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [285] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [286] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [287] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [288] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [289] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [290] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [291] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [292] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [293] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [294] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [295] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [296] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [297] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [298] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [299] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [300] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [301] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [302] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [303] */
    /* usage */ ParameterUsage::kComponent,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [304] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[118],
  },
  {
    /* [305] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [306] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [307] */
    /* usage */ ParameterUsage::kComponent,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [308] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[128],
  },
  {
    /* [309] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [310] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [311] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [312] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [313] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [314] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [315] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [316] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [317] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [318] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [319] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [320] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [321] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [322] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [323] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [324] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [325] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [326] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [327] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [328] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [329] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [330] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [331] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [332] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [333] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [334] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [335] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[144],
  },
  {
    /* [336] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [337] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [338] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [339] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [340] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [341] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [342] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[148],
  },
  {
    /* [343] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[152],
  },
  {
    /* [344] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [345] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [346] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [347] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [348] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [349] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [350] */
    /* usage */ ParameterUsage::kOffset,
    /* matcher indices */ &kMatcherIndices[136],
  },
  {
    /* [351] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [352] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [353] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [354] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [355] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [356] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [357] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [358] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [359] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [360] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [361] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [362] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [363] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [364] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [365] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [366] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [367] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[150],
  },
  {
    /* [368] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [369] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [370] */
    /* usage */ ParameterUsage::kBias,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [371] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [372] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [373] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [374] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [375] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [376] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [377] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [378] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [379] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [380] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [381] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [382] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [383] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [384] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[239],
  },
  {
    /* [385] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [386] */
    /* usage */ ParameterUsage::kDepthRef,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [387] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [388] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [389] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [390] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [391] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [392] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [393] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [394] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [395] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[150],
  },
  {
    /* [396] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [397] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [398] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [399] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [400] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [401] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [402] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [403] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [404] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [405] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [406] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [407] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[70],
  },
  {
    /* [408] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [409] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [410] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[114],
  },
  {
    /* [411] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[82],
  },
  {
    /* [412] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [413] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [414] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[154],
  },
  {
    /* [415] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[94],
  },
  {
    /* [416] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [417] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [418] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[156],
  },
  {
    /* [419] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[122],
  },
  {
    /* [420] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [421] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [422] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[65],
  },
  {
    /* [423] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [424] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [425] */
    /* usage */ ParameterUsage::kArrayIndex,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [426] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [427] */
    /* usage */ ParameterUsage::kX,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [428] */
    /* usage */ ParameterUsage::kY,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [429] */
    /* usage */ ParameterUsage::kZ,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [430] */
    /* usage */ ParameterUsage::kW,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [431] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [432] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [433] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [434] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [435] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [436] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [437] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [438] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [439] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [440] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [441] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [442] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [443] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [444] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [445] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [446] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [447] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [448] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [449] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [450] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [451] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [452] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [453] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [454] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [455] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [456] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [457] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [458] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [459] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [460] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [461] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [462] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [463] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [464] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [465] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [466] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [467] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [468] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [469] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [470] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [471] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [472] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [473] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [474] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [475] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [476] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [477] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [478] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [479] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [480] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [481] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [482] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [483] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [484] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [485] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [486] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [487] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [488] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [489] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [490] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [491] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [492] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [493] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [494] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [495] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [496] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [497] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [498] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [499] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [500] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [501] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[140],
  },
  {
    /* [502] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [503] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [504] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [505] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [506] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [507] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[146],
  },
  {
    /* [508] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [509] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [510] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[150],
  },
  {
    /* [511] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [512] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [513] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [514] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [515] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [516] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [517] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [518] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[138],
  },
  {
    /* [519] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[142],
  },
  {
    /* [520] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [521] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [522] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[237],
  },
  {
    /* [523] */
    /* usage */ ParameterUsage::kSampler,
    /* matcher indices */ &kMatcherIndices[238],
  },
  {
    /* [524] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [525] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[64],
  },
  {
    /* [526] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [527] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[114],
  },
  {
    /* [528] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[67],
  },
  {
    /* [529] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [530] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[114],
  },
  {
    /* [531] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[73],
  },
  {
    /* [532] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [533] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[114],
  },
  {
    /* [534] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[76],
  },
  {
    /* [535] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [536] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[154],
  },
  {
    /* [537] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[79],
  },
  {
    /* [538] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [539] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[154],
  },
  {
    /* [540] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[85],
  },
  {
    /* [541] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [542] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[154],
  },
  {
    /* [543] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[88],
  },
  {
    /* [544] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [545] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[156],
  },
  {
    /* [546] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[91],
  },
  {
    /* [547] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [548] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[156],
  },
  {
    /* [549] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[97],
  },
  {
    /* [550] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[148],
  },
  {
    /* [551] */
    /* usage */ ParameterUsage::kValue,
    /* matcher indices */ &kMatcherIndices[156],
  },
  {
    /* [552] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[116],
  },
  {
    /* [553] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [554] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [555] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[118],
  },
  {
    /* [556] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [557] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [558] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[124],
  },
  {
    /* [559] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[160],
  },
  {
    /* [560] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [561] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[132],
  },
  {
    /* [562] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [563] */
    /* usage */ ParameterUsage::kSampleIndex,
    /* matcher indices */ &kMatcherIndices[28],
  },
  {
    /* [564] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [565] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [566] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [567] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[236],
  },
  {
    /* [568] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [569] */
    /* usage */ ParameterUsage::kSampleIndex,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [570] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [571] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [572] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [573] */
    /* usage */ ParameterUsage::kX,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [574] */
    /* usage */ ParameterUsage::kY,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [575] */
    /* usage */ ParameterUsage::kZ,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [576] */
    /* usage */ ParameterUsage::kXy,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [577] */
    /* usage */ ParameterUsage::kZ,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [578] */
    /* usage */ ParameterUsage::kW,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [579] */
    /* usage */ ParameterUsage::kX,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [580] */
    /* usage */ ParameterUsage::kYz,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [581] */
    /* usage */ ParameterUsage::kW,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [582] */
    /* usage */ ParameterUsage::kX,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [583] */
    /* usage */ ParameterUsage::kY,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [584] */
    /* usage */ ParameterUsage::kZw,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [585] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [586] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [587] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [588] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [589] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [590] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [591] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [592] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [593] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [594] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [595] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [596] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [597] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [598] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [599] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [600] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [601] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [602] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [603] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [604] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [605] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [606] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [607] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [608] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [609] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [610] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [611] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [612] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [613] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[46],
  },
  {
    /* [614] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [615] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [616] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [617] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [618] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [619] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [620] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [621] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [622] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [623] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [624] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [625] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [626] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [627] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [628] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [629] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [630] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [631] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [632] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[116],
  },
  {
    /* [633] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [634] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[118],
  },
  {
    /* [635] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [636] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[122],
  },
  {
    /* [637] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [638] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[124],
  },
  {
    /* [639] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [640] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[128],
  },
  {
    /* [641] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [642] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[130],
  },
  {
    /* [643] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[16],
  },
  {
    /* [644] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [645] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [646] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [647] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [648] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [649] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [650] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [651] */
    /* usage */ ParameterUsage::kLevel,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [652] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[237],
  },
  {
    /* [653] */
    /* usage */ ParameterUsage::kCoords,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [654] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [655] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [656] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [657] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [658] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [659] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [660] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [661] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [662] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [663] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [664] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [665] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [666] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [667] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [668] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [669] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [670] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [671] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [672] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [673] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [674] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [675] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [676] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [677] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [678] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [679] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [680] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [681] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [682] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [683] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [684] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [685] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [686] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [687] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [688] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [689] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [690] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [691] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [692] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [693] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [694] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [695] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [696] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [697] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [698] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [699] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [700] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [701] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [702] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [703] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [704] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [705] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [706] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[100],
  },
  {
    /* [707] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [708] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[26],
  },
  {
    /* [709] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[18],
  },
  {
    /* [710] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [711] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [712] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [713] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [714] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [715] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [716] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [717] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [718] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [719] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [720] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [721] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [722] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [723] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [724] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [725] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [726] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [727] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [728] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [729] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [730] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [731] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [732] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [733] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [734] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [735] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [736] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [737] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [738] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [739] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [740] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [741] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [742] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [743] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [744] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [745] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [746] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [747] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [748] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [749] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [750] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [751] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [752] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [753] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [754] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [755] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [756] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [757] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [758] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [759] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [760] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [761] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [762] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [763] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [764] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [765] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [766] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [767] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [768] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [769] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [770] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [771] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [772] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [773] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [774] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [775] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [776] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [777] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[103],
  },
  {
    /* [778] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [779] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [780] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [781] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[103],
  },
  {
    /* [782] */
    /* usage */ ParameterUsage::kX,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [783] */
    /* usage */ ParameterUsage::kY,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [784] */
    /* usage */ ParameterUsage::kXy,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [785] */
    /* usage */ ParameterUsage::kZ,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [786] */
    /* usage */ ParameterUsage::kX,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [787] */
    /* usage */ ParameterUsage::kYz,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [788] */
    /* usage */ ParameterUsage::kXy,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [789] */
    /* usage */ ParameterUsage::kZw,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [790] */
    /* usage */ ParameterUsage::kXyz,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [791] */
    /* usage */ ParameterUsage::kW,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [792] */
    /* usage */ ParameterUsage::kX,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [793] */
    /* usage */ ParameterUsage::kZyw,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [794] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [795] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [796] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [797] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [798] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [799] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [800] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [801] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [802] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [803] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [804] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [805] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [806] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [807] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [808] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [809] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [810] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[0],
  },
  {
    /* [811] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [812] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [813] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [814] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [815] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [816] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [817] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [818] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [819] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [820] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [821] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [822] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [823] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [824] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [825] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [826] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [827] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [828] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [829] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [830] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [831] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [832] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [833] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[10],
  },
  {
    /* [834] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [835] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [836] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [837] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [838] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [839] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [840] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [841] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [842] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [843] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [844] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [845] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [846] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [847] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [848] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [849] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [850] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [851] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [852] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [853] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [854] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [855] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [856] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [857] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [858] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [859] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [860] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [861] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [862] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [863] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [864] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [865] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [866] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [867] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [868] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [869] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [870] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [871] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [872] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [873] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [874] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [875] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [876] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [877] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [878] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [879] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[112],
  },
  {
    /* [880] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[114],
  },
  {
    /* [881] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[114],
  },
  {
    /* [882] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [883] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[40],
  },
  {
    /* [884] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [885] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [886] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [887] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [888] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [889] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [890] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [891] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [892] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [893] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [894] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [895] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [896] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [897] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [898] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [899] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [900] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [901] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [902] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [903] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [904] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[14],
  },
  {
    /* [905] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [906] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [907] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [908] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [909] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [910] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [911] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [912] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[22],
  },
  {
    /* [913] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[116],
  },
  {
    /* [914] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[118],
  },
  {
    /* [915] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[122],
  },
  {
    /* [916] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[124],
  },
  {
    /* [917] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[128],
  },
  {
    /* [918] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[130],
  },
  {
    /* [919] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[132],
  },
  {
    /* [920] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [921] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [922] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [923] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [924] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[236],
  },
  {
    /* [925] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[52],
  },
  {
    /* [926] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[55],
  },
  {
    /* [927] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[58],
  },
  {
    /* [928] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[61],
  },
  {
    /* [929] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[237],
  },
  {
    /* [930] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[122],
  },
  {
    /* [931] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[130],
  },
  {
    /* [932] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [933] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [934] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[58],
  },
  {
    /* [935] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[116],
  },
  {
    /* [936] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[118],
  },
  {
    /* [937] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[122],
  },
  {
    /* [938] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[124],
  },
  {
    /* [939] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[128],
  },
  {
    /* [940] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[130],
  },
  {
    /* [941] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[232],
  },
  {
    /* [942] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[233],
  },
  {
    /* [943] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[234],
  },
  {
    /* [944] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[235],
  },
  {
    /* [945] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[132],
  },
  {
    /* [946] */
    /* usage */ ParameterUsage::kTexture,
    /* matcher indices */ &kMatcherIndices[236],
  },
  {
    /* [947] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[5],
  },
  {
    /* [948] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [949] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [950] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[37],
  },
  {
    /* [951] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [952] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [953] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [954] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[34],
  },
  {
    /* [955] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[9],
  },
  {
    /* [956] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [957] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[105],
  },
  {
    /* [958] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [959] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[42],
  },
  {
    /* [960] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [961] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[1],
  },
  {
    /* [962] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [963] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[39],
  },
  {
    /* [964] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [965] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[23],
  },
  {
    /* [966] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [967] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [968] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [969] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [970] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [971] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[158],
  },
  {
    /* [972] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[106],
  },
  {
    /* [973] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [974] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[160],
  },
  {
    /* [975] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[160],
  },
  {
    /* [976] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[160],
  },
  {
    /* [977] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[160],
  },
  {
    /* [978] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[160],
  },
  {
    /* [979] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[134],
  },
  {
    /* [980] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[3],
  },
  {
    /* [981] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[172],
  },
  {
    /* [982] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[172],
  },
  {
    /* [983] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[172],
  },
  {
    /* [984] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[172],
  },
  {
    /* [985] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[172],
  },
  {
    /* [986] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[178],
  },
  {
    /* [987] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[180],
  },
  {
    /* [988] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[182],
  },
  {
    /* [989] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[184],
  },
  {
    /* [990] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[186],
  },
  {
    /* [991] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[188],
  },
  {
    /* [992] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[190],
  },
  {
    /* [993] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[192],
  },
  {
    /* [994] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[194],
  },
  {
    /* [995] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[196],
  },
  {
    /* [996] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[198],
  },
  {
    /* [997] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[200],
  },
  {
    /* [998] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[202],
  },
  {
    /* [999] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[204],
  },
  {
    /* [1000] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[206],
  },
  {
    /* [1001] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[208],
  },
  {
    /* [1002] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[210],
  },
  {
    /* [1003] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[212],
  },
  {
    /* [1004] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[214],
  },
  {
    /* [1005] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[216],
  },
  {
    /* [1006] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[218],
  },
  {
    /* [1007] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[220],
  },
  {
    /* [1008] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[222],
  },
  {
    /* [1009] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[224],
  },
  {
    /* [1010] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[226],
  },
  {
    /* [1011] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[228],
  },
  {
    /* [1012] */
    /* usage */ ParameterUsage::kNone,
    /* matcher indices */ &kMatcherIndices[230],
  },
};

constexpr TemplateTypeInfo kTemplateTypes[] = {
  {
    /* [0] */
    /* name */ "T",
    /* matcher index */ 67,
  },
  {
    /* [1] */
    /* name */ "C",
    /* matcher index */ 71,
  },
  {
    /* [2] */
    /* name */ "A",
    /* matcher index */ 71,
  },
  {
    /* [3] */
    /* name */ "L",
    /* matcher index */ 71,
  },
  {
    /* [4] */
    /* name */ "T",
    /* matcher index */ 67,
  },
  {
    /* [5] */
    /* name */ "C",
    /* matcher index */ 71,
  },
  {
    /* [6] */
    /* name */ "L",
    /* matcher index */ 71,
  },
  {
    /* [7] */
    /* name */ "T",
    /* matcher index */ 67,
  },
  {
    /* [8] */
    /* name */ "C",
    /* matcher index */ 71,
  },
  {
    /* [9] */
    /* name */ "S",
    /* matcher index */ 71,
  },
  {
    /* [10] */
    /* name */ "T",
    /* matcher index */ 63,
  },
  {
    /* [11] */
    /* name */ "U",
    /* matcher index */ 65,
  },
  {
    /* [12] */
    /* name */ "T",
    /* matcher index */ 67,
  },
  {
    /* [13] */
    /* name */ "L",
    /* matcher index */ 71,
  },
  {
    /* [14] */
    /* name */ "T",
    /* matcher index */ 9,
  },
  {
    /* [15] */
    /* name */ "U",
    /* matcher index */ 54,
  },
  {
    /* [16] */
    /* name */ "T",
    /* matcher index */ 10,
  },
  {
    /* [17] */
    /* name */ "U",
    /* matcher index */ 55,
  },
  {
    /* [18] */
    /* name */ "T",
    /* matcher index */ 7,
  },
  {
    /* [19] */
    /* name */ "U",
    /* matcher index */ 56,
  },
  {
    /* [20] */
    /* name */ "T",
    /* matcher index */ 8,
  },
  {
    /* [21] */
    /* name */ "U",
    /* matcher index */ 57,
  },
  {
    /* [22] */
    /* name */ "T",
    /* matcher index */ 4,
  },
  {
    /* [23] */
    /* name */ "U",
    /* matcher index */ 58,
  },
  {
    /* [24] */
    /* name */ "T",
    /* matcher index */ 59,
  },
  {
    /* [25] */
    /* name */ "T",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [26] */
    /* name */ "T",
    /* matcher index */ 71,
  },
  {
    /* [27] */
    /* name */ "T",
    /* matcher index */ 52,
  },
  {
    /* [28] */
    /* name */ "T",
    /* matcher index */ 60,
  },
  {
    /* [29] */
    /* name */ "T",
    /* matcher index */ 64,
  },
  {
    /* [30] */
    /* name */ "T",
    /* matcher index */ 66,
  },
  {
    /* [31] */
    /* name */ "T",
    /* matcher index */ 56,
  },
  {
    /* [32] */
    /* name */ "T",
    /* matcher index */ 57,
  },
  {
    /* [33] */
    /* name */ "T",
    /* matcher index */ 54,
  },
  {
    /* [34] */
    /* name */ "T",
    /* matcher index */ 55,
  },
  {
    /* [35] */
    /* name */ "T",
    /* matcher index */ 58,
  },
  {
    /* [36] */
    /* name */ "T",
    /* matcher index */ 53,
  },
  {
    /* [37] */
    /* name */ "T",
    /* matcher index */ 70,
  },
};

constexpr TemplateNumberInfo kTemplateNumbers[] = {
  {
    /* [0] */
    /* name */ "K",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [1] */
    /* name */ "C",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [2] */
    /* name */ "R",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [3] */
    /* name */ "M",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [4] */
    /* name */ "N",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [5] */
    /* name */ "M",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [6] */
    /* name */ "F",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [7] */
    /* name */ "A",
    /* matcher index */ 6,
  },
  {
    /* [8] */
    /* name */ "A",
    /* matcher index */ kNoMatcher,
  },
  {
    /* [9] */
    /* name */ "S",
    /* matcher index */ 9,
  },
};

constexpr OverloadInfo kOverloads[] = {
  {
    /* [0] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[913],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [1] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[12],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[632],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [2] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[914],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [3] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[12],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[634],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [4] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[915],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [5] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[12],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[636],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [6] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[916],
    /* return matcher indices */ &kMatcherIndices[126],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [7] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[12],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[638],
    /* return matcher indices */ &kMatcherIndices[126],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [8] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[917],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [9] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[12],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[640],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [10] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[918],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [11] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[12],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[642],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [12] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[919],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [13] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[920],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [14] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[3],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[644],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [15] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[921],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [16] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[3],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[646],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [17] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[922],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [18] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[3],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[648],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [19] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[923],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [20] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[3],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[650],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [21] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[924],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [22] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[6],
    /* parameters */ &kParameters[925],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [23] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[6],
    /* parameters */ &kParameters[926],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [24] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[6],
    /* parameters */ &kParameters[927],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [25] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[6],
    /* parameters */ &kParameters[928],
    /* return matcher indices */ &kMatcherIndices[126],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [26] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[929],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [27] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[501],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [28] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[504],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [29] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[331],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [30] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[335],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [31] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[185],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [32] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[507],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [33] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[339],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [34] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[510],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [35] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[343],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [36] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[513],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [37] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[347],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [38] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[351],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [39] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[190],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [40] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[516],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [41] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[355],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [42] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[36],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [43] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[979],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [44] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[980],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecSplat,
  },
  {
    /* [45] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[427],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitS,
  },
  {
    /* [46] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[576],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [47] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[579],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [48] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[582],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [49] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[788],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [50] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[790],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [51] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[792],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [52] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[981],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [53] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[982],
    /* return matcher indices */ &kMatcherIndices[174],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [54] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[18],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[983],
    /* return matcher indices */ &kMatcherIndices[154],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [55] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[20],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[984],
    /* return matcher indices */ &kMatcherIndices[156],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [56] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[22],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[985],
    /* return matcher indices */ &kMatcherIndices[176],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [57] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[387],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [58] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[260],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [59] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[265],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [60] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[126],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [61] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[391],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [62] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[270],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [63] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[395],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [64] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[275],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [65] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[3],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[399],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [66] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[3],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[280],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [67] */
    /* num parameters */ 5,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[285],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [68] */
    /* num parameters */ 6,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[132],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [69] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[3],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[403],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [70] */
    /* num parameters */ 5,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[290],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [71] */
    /* num parameters */ 4,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[303],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [72] */
    /* num parameters */ 5,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[150],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [73] */
    /* num parameters */ 5,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[155],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [74] */
    /* num parameters */ 6,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[72],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [75] */
    /* num parameters */ 4,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[307],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [76] */
    /* num parameters */ 5,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[160],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [77] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[495],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [78] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[311],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [79] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[315],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [80] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[165],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [81] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[498],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [82] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[319],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [83] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[525],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [84] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[528],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [85] */
    /* num parameters */ 4,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[407],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [86] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[531],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [87] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[534],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [88] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[537],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [89] */
    /* num parameters */ 4,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[411],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [90] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[540],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [91] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[543],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [92] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[546],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [93] */
    /* num parameters */ 4,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[415],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [94] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[549],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [95] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[36],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[106],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [96] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[972],
    /* return matcher indices */ &kMatcherIndices[106],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [97] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[973],
    /* return matcher indices */ &kMatcherIndices[106],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecSplat,
  },
  {
    /* [98] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[573],
    /* return matcher indices */ &kMatcherIndices[106],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitS,
  },
  {
    /* [99] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[784],
    /* return matcher indices */ &kMatcherIndices[106],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [100] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[786],
    /* return matcher indices */ &kMatcherIndices[106],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitM,
  },
  {
    /* [101] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[974],
    /* return matcher indices */ &kMatcherIndices[138],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [102] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[975],
    /* return matcher indices */ &kMatcherIndices[168],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [103] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[18],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[976],
    /* return matcher indices */ &kMatcherIndices[148],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [104] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[20],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[977],
    /* return matcher indices */ &kMatcherIndices[126],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [105] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[22],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[978],
    /* return matcher indices */ &kMatcherIndices[170],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [106] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[935],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [107] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[936],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [108] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[937],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [109] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[938],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [110] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[939],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [111] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[940],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [112] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[941],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [113] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[942],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [114] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[943],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [115] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[944],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [116] */
    /* num parameters */ 3,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[4],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[552],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [117] */
    /* num parameters */ 3,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[4],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[555],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [118] */
    /* num parameters */ 4,
    /* num template types */ 4,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[419],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [119] */
    /* num parameters */ 3,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[4],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[558],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [120] */
    /* num parameters */ 3,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[7],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[561],
    /* return matcher indices */ &kMatcherIndices[134],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [121] */
    /* num parameters */ 3,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[5],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[564],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [122] */
    /* num parameters */ 4,
    /* num template types */ 3,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[423],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [123] */
    /* num parameters */ 3,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[8],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[567],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [124] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[1],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[652],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [125] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[692],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiply,
  },
  {
    /* [126] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[694],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiply,
  },
  {
    /* [127] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[696],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiply,
  },
  {
    /* [128] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[698],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiply,
  },
  {
    /* [129] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[700],
    /* return matcher indices */ &kMatcherIndices[14],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiply,
  },
  {
    /* [130] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[702],
    /* return matcher indices */ &kMatcherIndices[14],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiply,
  },
  {
    /* [131] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[1],
    /* parameters */ &kParameters[704],
    /* return matcher indices */ &kMatcherIndices[100],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiplyMatVec,
  },
  {
    /* [132] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[1],
    /* parameters */ &kParameters[706],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiplyVecMat,
  },
  {
    /* [133] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 3,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[0],
    /* parameters */ &kParameters[708],
    /* return matcher indices */ &kMatcherIndices[30],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMultiplyMatMat,
  },
  {
    /* [134] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[36],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[23],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [135] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[965],
    /* return matcher indices */ &kMatcherIndices[23],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [136] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[966],
    /* return matcher indices */ &kMatcherIndices[23],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecSplat,
  },
  {
    /* [137] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[782],
    /* return matcher indices */ &kMatcherIndices[23],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::VecInitS,
  },
  {
    /* [138] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[967],
    /* return matcher indices */ &kMatcherIndices[112],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [139] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[968],
    /* return matcher indices */ &kMatcherIndices[164],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [140] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[18],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[969],
    /* return matcher indices */ &kMatcherIndices[136],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [141] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[20],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[970],
    /* return matcher indices */ &kMatcherIndices[120],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [142] */
    /* num parameters */ 1,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[22],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[971],
    /* return matcher indices */ &kMatcherIndices[166],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [143] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[359],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [144] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[195],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [145] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[200],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [146] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[84],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [147] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[363],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [148] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[205],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [149] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[367],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [150] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[210],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [151] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[245],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [152] */
    /* num parameters */ 6,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[102],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [153] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[108],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [154] */
    /* num parameters */ 7,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[65],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [155] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[250],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [156] */
    /* num parameters */ 6,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[114],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [157] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[255],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [158] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[120],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [159] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[323],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [160] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[170],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [161] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[175],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [162] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[78],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [163] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[327],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [164] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[180],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [165] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[371],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [166] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[215],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [167] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[220],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [168] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[90],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [169] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[375],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [170] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[225],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [171] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[379],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [172] */
    /* num parameters */ 5,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[230],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [173] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[235],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [174] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[96],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [175] */
    /* num parameters */ 4,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[383],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [176] */
    /* num parameters */ 5,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[2],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[240],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [177] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[178],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [178] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[986],
    /* return matcher indices */ &kMatcherIndices[178],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [179] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[431],
    /* return matcher indices */ &kMatcherIndices[178],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [180] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[794],
    /* return matcher indices */ &kMatcherIndices[178],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [181] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[987],
    /* return matcher indices */ &kMatcherIndices[182],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [182] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[988],
    /* return matcher indices */ &kMatcherIndices[180],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [183] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[184],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [184] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[989],
    /* return matcher indices */ &kMatcherIndices[184],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [185] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[138],
    /* return matcher indices */ &kMatcherIndices[184],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [186] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[796],
    /* return matcher indices */ &kMatcherIndices[184],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [187] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[990],
    /* return matcher indices */ &kMatcherIndices[188],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [188] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[991],
    /* return matcher indices */ &kMatcherIndices[186],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [189] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[190],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [190] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[992],
    /* return matcher indices */ &kMatcherIndices[190],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [191] */
    /* num parameters */ 8,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[49],
    /* return matcher indices */ &kMatcherIndices[190],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [192] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[798],
    /* return matcher indices */ &kMatcherIndices[190],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [193] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[993],
    /* return matcher indices */ &kMatcherIndices[194],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [194] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[994],
    /* return matcher indices */ &kMatcherIndices[192],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [195] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[196],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [196] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[995],
    /* return matcher indices */ &kMatcherIndices[196],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [197] */
    /* num parameters */ 6,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[144],
    /* return matcher indices */ &kMatcherIndices[196],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [198] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[585],
    /* return matcher indices */ &kMatcherIndices[196],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [199] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[996],
    /* return matcher indices */ &kMatcherIndices[200],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [200] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[997],
    /* return matcher indices */ &kMatcherIndices[198],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [201] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[202],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [202] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[998],
    /* return matcher indices */ &kMatcherIndices[202],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [203] */
    /* num parameters */ 9,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[40],
    /* return matcher indices */ &kMatcherIndices[202],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [204] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[588],
    /* return matcher indices */ &kMatcherIndices[202],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [205] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[999],
    /* return matcher indices */ &kMatcherIndices[206],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [206] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1000],
    /* return matcher indices */ &kMatcherIndices[204],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [207] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[208],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [208] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1001],
    /* return matcher indices */ &kMatcherIndices[208],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [209] */
    /* num parameters */ 12,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[16],
    /* return matcher indices */ &kMatcherIndices[208],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [210] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[591],
    /* return matcher indices */ &kMatcherIndices[208],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [211] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1002],
    /* return matcher indices */ &kMatcherIndices[212],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [212] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1003],
    /* return matcher indices */ &kMatcherIndices[210],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [213] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[214],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [214] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1004],
    /* return matcher indices */ &kMatcherIndices[214],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [215] */
    /* num parameters */ 8,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[57],
    /* return matcher indices */ &kMatcherIndices[214],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [216] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[435],
    /* return matcher indices */ &kMatcherIndices[214],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [217] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1005],
    /* return matcher indices */ &kMatcherIndices[218],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [218] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1006],
    /* return matcher indices */ &kMatcherIndices[216],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [219] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[220],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [220] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1007],
    /* return matcher indices */ &kMatcherIndices[220],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [221] */
    /* num parameters */ 12,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[28],
    /* return matcher indices */ &kMatcherIndices[220],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [222] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[439],
    /* return matcher indices */ &kMatcherIndices[220],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [223] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1008],
    /* return matcher indices */ &kMatcherIndices[224],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [224] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1009],
    /* return matcher indices */ &kMatcherIndices[222],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [225] */
    /* num parameters */ 0,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[226],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [226] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[37],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1010],
    /* return matcher indices */ &kMatcherIndices[226],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [227] */
    /* num parameters */ 16,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[0],
    /* return matcher indices */ &kMatcherIndices[226],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitS,
  },
  {
    /* [228] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[443],
    /* return matcher indices */ &kMatcherIndices[226],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::MatInitV,
  },
  {
    /* [229] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[16],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1011],
    /* return matcher indices */ &kMatcherIndices[230],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [230] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[14],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1012],
    /* return matcher indices */ &kMatcherIndices[228],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [231] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[930],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [232] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[931],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [233] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[932],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [234] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[933],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [235] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[6],
    /* parameters */ &kParameters[934],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [236] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[672],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpPlus,
  },
  {
    /* [237] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[674],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpPlus,
  },
  {
    /* [238] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[676],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpPlus,
  },
  {
    /* [239] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[678],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpPlus,
  },
  {
    /* [240] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[680],
    /* return matcher indices */ &kMatcherIndices[14],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpPlus,
  },
  {
    /* [241] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[682],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMinus,
  },
  {
    /* [242] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[684],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMinus,
  },
  {
    /* [243] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[686],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMinus,
  },
  {
    /* [244] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[688],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMinus,
  },
  {
    /* [245] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[690],
    /* return matcher indices */ &kMatcherIndices[14],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpMinus,
  },
  {
    /* [246] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[710],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpDivide,
  },
  {
    /* [247] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[712],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpDivide,
  },
  {
    /* [248] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[714],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpDivide,
  },
  {
    /* [249] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[716],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpDivide,
  },
  {
    /* [250] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[718],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpModulo,
  },
  {
    /* [251] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[720],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpModulo,
  },
  {
    /* [252] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[722],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpModulo,
  },
  {
    /* [253] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[724],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpModulo,
  },
  {
    /* [254] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[730],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpAnd,
  },
  {
    /* [255] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[732],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpAnd,
  },
  {
    /* [256] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[734],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpAnd,
  },
  {
    /* [257] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[736],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpAnd,
  },
  {
    /* [258] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[738],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpOr,
  },
  {
    /* [259] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[740],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpOr,
  },
  {
    /* [260] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[742],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpOr,
  },
  {
    /* [261] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[744],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpOr,
  },
  {
    /* [262] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[468],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::mix,
  },
  {
    /* [263] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[471],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::mix,
  },
  {
    /* [264] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[474],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::mix,
  },
  {
    /* [265] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[480],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::select_bool,
  },
  {
    /* [266] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[483],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::select_bool,
  },
  {
    /* [267] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[486],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::select_boolvec,
  },
  {
    /* [268] */
    /* num parameters */ 0,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[9],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [269] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[955],
    /* return matcher indices */ &kMatcherIndices[9],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [270] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[31],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[956],
    /* return matcher indices */ &kMatcherIndices[9],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [271] */
    /* num parameters */ 0,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [272] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[957],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [273] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[32],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[958],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [274] */
    /* num parameters */ 0,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [275] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[959],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [276] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[33],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[960],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [277] */
    /* num parameters */ 0,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[1],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [278] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[961],
    /* return matcher indices */ &kMatcherIndices[1],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [279] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[34],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[962],
    /* return matcher indices */ &kMatcherIndices[1],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [280] */
    /* num parameters */ 0,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Zero,
  },
  {
    /* [281] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[963],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsConstructor, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [282] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[35],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[964],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsConverter, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::Conv,
  },
  {
    /* [283] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[800],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::abs,
  },
  {
    /* [284] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[801],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::abs,
  },
  {
    /* [285] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[802],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::acos,
  },
  {
    /* [286] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[803],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::acos,
  },
  {
    /* [287] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[804],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::acosh,
  },
  {
    /* [288] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[805],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::acosh,
  },
  {
    /* [289] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[806],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::all,
  },
  {
    /* [290] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[807],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::all,
  },
  {
    /* [291] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[808],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::any,
  },
  {
    /* [292] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[809],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::any,
  },
  {
    /* [293] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[811],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::asin,
  },
  {
    /* [294] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[812],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::asin,
  },
  {
    /* [295] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[813],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::asinh,
  },
  {
    /* [296] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[814],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::asinh,
  },
  {
    /* [297] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[815],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::atan,
  },
  {
    /* [298] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[816],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::atan,
  },
  {
    /* [299] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[594],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::atan2,
  },
  {
    /* [300] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[596],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::atan2,
  },
  {
    /* [301] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[817],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::atanh,
  },
  {
    /* [302] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[818],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::atanh,
  },
  {
    /* [303] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[819],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::ceil,
  },
  {
    /* [304] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[820],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::ceil,
  },
  {
    /* [305] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[447],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::clamp,
  },
  {
    /* [306] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[450],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::clamp,
  },
  {
    /* [307] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[821],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::cos,
  },
  {
    /* [308] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[822],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::cos,
  },
  {
    /* [309] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[823],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::cosh,
  },
  {
    /* [310] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[824],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::cosh,
  },
  {
    /* [311] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[825],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::countLeadingZeros,
  },
  {
    /* [312] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[826],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::countLeadingZeros,
  },
  {
    /* [313] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[827],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::countOneBits,
  },
  {
    /* [314] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[828],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::countOneBits,
  },
  {
    /* [315] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[829],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::countTrailingZeros,
  },
  {
    /* [316] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[830],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::countTrailingZeros,
  },
  {
    /* [317] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[831],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::degrees,
  },
  {
    /* [318] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[832],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::degrees,
  },
  {
    /* [319] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[600],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::distance,
  },
  {
    /* [320] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[602],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::distance,
  },
  {
    /* [321] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[834],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [322] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[835],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [323] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[836],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [324] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[837],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [325] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[838],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [326] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[839],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [327] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[840],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [328] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[841],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [329] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[842],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [330] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[843],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [331] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[844],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [332] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[845],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [333] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[846],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::exp,
  },
  {
    /* [334] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[847],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::exp,
  },
  {
    /* [335] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[848],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::exp2,
  },
  {
    /* [336] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[849],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::exp2,
  },
  {
    /* [337] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[453],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::extractBits,
  },
  {
    /* [338] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[456],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::extractBits,
  },
  {
    /* [339] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[850],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::firstLeadingBit,
  },
  {
    /* [340] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[851],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::firstLeadingBit,
  },
  {
    /* [341] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[852],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::firstTrailingBit,
  },
  {
    /* [342] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[853],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::firstTrailingBit,
  },
  {
    /* [343] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[854],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::floor,
  },
  {
    /* [344] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[855],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::floor,
  },
  {
    /* [345] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[462],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::fma,
  },
  {
    /* [346] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[465],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::fma,
  },
  {
    /* [347] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[856],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::fract,
  },
  {
    /* [348] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[857],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::fract,
  },
  {
    /* [349] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[858],
    /* return matcher indices */ &kMatcherIndices[108],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::frexp,
  },
  {
    /* [350] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[859],
    /* return matcher indices */ &kMatcherIndices[43],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::frexp,
  },
  {
    /* [351] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[860],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [352] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[861],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [353] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[862],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [354] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[863],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [355] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[864],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [356] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[865],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [357] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[295],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::insertBits,
  },
  {
    /* [358] */
    /* num parameters */ 4,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[299],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::insertBits,
  },
  {
    /* [359] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[866],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::inverseSqrt,
  },
  {
    /* [360] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[867],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::inverseSqrt,
  },
  {
    /* [361] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[610],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::ldexp,
  },
  {
    /* [362] */
    /* num parameters */ 2,
    /* num template types */ 2,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[612],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::ldexp,
  },
  {
    /* [363] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[868],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::length,
  },
  {
    /* [364] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[869],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::length,
  },
  {
    /* [365] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[870],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::log,
  },
  {
    /* [366] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[871],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::log,
  },
  {
    /* [367] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[872],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::log2,
  },
  {
    /* [368] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[873],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::log2,
  },
  {
    /* [369] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[614],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::max,
  },
  {
    /* [370] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[616],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::max,
  },
  {
    /* [371] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[618],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::min,
  },
  {
    /* [372] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[620],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::min,
  },
  {
    /* [373] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[874],
    /* return matcher indices */ &kMatcherIndices[110],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::modf,
  },
  {
    /* [374] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[875],
    /* return matcher indices */ &kMatcherIndices[49],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::modf,
  },
  {
    /* [375] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[622],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::pow,
  },
  {
    /* [376] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[624],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::pow,
  },
  {
    /* [377] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[882],
    /* return matcher indices */ &kMatcherIndices[42],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::quantizeToF16,
  },
  {
    /* [378] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[883],
    /* return matcher indices */ &kMatcherIndices[40],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::quantizeToF16,
  },
  {
    /* [379] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[884],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::radians,
  },
  {
    /* [380] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[885],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::radians,
  },
  {
    /* [381] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[886],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::reverseBits,
  },
  {
    /* [382] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[887],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::reverseBits,
  },
  {
    /* [383] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[888],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::round,
  },
  {
    /* [384] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[889],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::round,
  },
  {
    /* [385] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[890],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::saturate,
  },
  {
    /* [386] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[891],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::saturate,
  },
  {
    /* [387] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[28],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[892],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sign,
  },
  {
    /* [388] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[28],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[893],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sign,
  },
  {
    /* [389] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[894],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sin,
  },
  {
    /* [390] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[895],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sin,
  },
  {
    /* [391] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[896],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sinh,
  },
  {
    /* [392] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[897],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sinh,
  },
  {
    /* [393] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[489],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::smoothstep,
  },
  {
    /* [394] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[492],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::smoothstep,
  },
  {
    /* [395] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[898],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sqrt,
  },
  {
    /* [396] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[899],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::sqrt,
  },
  {
    /* [397] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[628],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::step,
  },
  {
    /* [398] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[630],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::step,
  },
  {
    /* [399] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[900],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::tan,
  },
  {
    /* [400] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[901],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::tan,
  },
  {
    /* [401] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[902],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::tanh,
  },
  {
    /* [402] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[903],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::tanh,
  },
  {
    /* [403] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[905],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::trunc,
  },
  {
    /* [404] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[906],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::trunc,
  },
  {
    /* [405] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[0],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[945],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [406] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[946],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [407] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[519],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [408] */
    /* num parameters */ 3,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[522],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [409] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[949],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpNot,
  },
  {
    /* [410] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[950],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpNot,
  },
  {
    /* [411] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[951],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpComplement,
  },
  {
    /* [412] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[952],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpComplement,
  },
  {
    /* [413] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[28],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[953],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpUnaryMinus,
  },
  {
    /* [414] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[28],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[954],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpUnaryMinus,
  },
  {
    /* [415] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[726],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpXor,
  },
  {
    /* [416] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[728],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpXor,
  },
  {
    /* [417] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[750],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpEqual,
  },
  {
    /* [418] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[752],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpEqual,
  },
  {
    /* [419] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[754],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpNotEqual,
  },
  {
    /* [420] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[27],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[756],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpNotEqual,
  },
  {
    /* [421] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[758],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpLessThan,
  },
  {
    /* [422] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[760],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpLessThan,
  },
  {
    /* [423] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[762],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpGreaterThan,
  },
  {
    /* [424] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[764],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpGreaterThan,
  },
  {
    /* [425] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[766],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpLessThanEqual,
  },
  {
    /* [426] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[768],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpLessThanEqual,
  },
  {
    /* [427] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[770],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpGreaterThanEqual,
  },
  {
    /* [428] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[30],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[772],
    /* return matcher indices */ &kMatcherIndices[37],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpGreaterThanEqual,
  },
  {
    /* [429] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[774],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpShiftLeft,
  },
  {
    /* [430] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[776],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpShiftLeft,
  },
  {
    /* [431] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[778],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpShiftRight,
  },
  {
    /* [432] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[29],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[780],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpShiftRight,
  },
  {
    /* [433] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[25],
    /* template numbers */ &kTemplateNumbers[8],
    /* parameters */ &kParameters[810],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [434] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[598],
    /* return matcher indices */ &kMatcherIndices[106],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::cross,
  },
  {
    /* [435] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[833],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::determinant,
  },
  {
    /* [436] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[24],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[604],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::dot,
  },
  {
    /* [437] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[606],
    /* return matcher indices */ &kMatcherIndices[9],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [438] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[608],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [439] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[459],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::faceForward,
  },
  {
    /* [440] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[876],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::normalize,
  },
  {
    /* [441] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[877],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::pack2x16float,
  },
  {
    /* [442] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[878],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::pack2x16snorm,
  },
  {
    /* [443] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[879],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::pack2x16unorm,
  },
  {
    /* [444] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[880],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::pack4x8snorm,
  },
  {
    /* [445] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[881],
    /* return matcher indices */ &kMatcherIndices[105],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::pack4x8unorm,
  },
  {
    /* [446] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[626],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::reflect,
  },
  {
    /* [447] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[4],
    /* parameters */ &kParameters[477],
    /* return matcher indices */ &kMatcherIndices[34],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::refract,
  },
  {
    /* [448] */
    /* num parameters */ 0,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [449] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 2,
    /* template types */ &kTemplateTypes[10],
    /* template numbers */ &kTemplateNumbers[3],
    /* parameters */ &kParameters[904],
    /* return matcher indices */ &kMatcherIndices[18],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::transpose,
  },
  {
    /* [450] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[907],
    /* return matcher indices */ &kMatcherIndices[112],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::unpack2x16float,
  },
  {
    /* [451] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[908],
    /* return matcher indices */ &kMatcherIndices[112],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::unpack2x16snorm,
  },
  {
    /* [452] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[909],
    /* return matcher indices */ &kMatcherIndices[112],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::unpack2x16unorm,
  },
  {
    /* [453] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[910],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::unpack4x8snorm,
  },
  {
    /* [454] */
    /* num parameters */ 1,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[911],
    /* return matcher indices */ &kMatcherIndices[114],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::unpack4x8unorm,
  },
  {
    /* [455] */
    /* num parameters */ 0,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[1013],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [456] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[25],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[912],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ nullptr,
  },
  {
    /* [457] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[947],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [458] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[654],
    /* return matcher indices */ nullptr,
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [459] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[656],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [460] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[658],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [461] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[660],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [462] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[662],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [463] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[664],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [464] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[666],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [465] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[668],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [466] */
    /* num parameters */ 2,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[670],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [467] */
    /* num parameters */ 3,
    /* num template types */ 1,
    /* num template numbers */ 1,
    /* template types */ &kTemplateTypes[26],
    /* template numbers */ &kTemplateNumbers[9],
    /* parameters */ &kParameters[570],
    /* return matcher indices */ &kMatcherIndices[162],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ nullptr,
  },
  {
    /* [468] */
    /* num parameters */ 1,
    /* num template types */ 1,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[25],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[948],
    /* return matcher indices */ &kMatcherIndices[3],
    /* flags */ OverloadFlags(OverloadFlag::kIsBuiltin, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline),
    /* const eval */ &ConstEval::Identity,
  },
  {
    /* [469] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[746],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpLogicalAnd,
  },
  {
    /* [470] */
    /* num parameters */ 2,
    /* num template types */ 0,
    /* num template numbers */ 0,
    /* template types */ &kTemplateTypes[38],
    /* template numbers */ &kTemplateNumbers[10],
    /* parameters */ &kParameters[748],
    /* return matcher indices */ &kMatcherIndices[39],
    /* flags */ OverloadFlags(OverloadFlag::kIsOperator, OverloadFlag::kSupportsVertexPipeline, OverloadFlag::kSupportsFragmentPipeline, OverloadFlag::kSupportsComputePipeline, OverloadFlag::kMustUse),
    /* const eval */ &ConstEval::OpLogicalOr,
  },
};

constexpr IntrinsicInfo kBuiltins[] = {
  {
    /* [0] */
    /* fn abs<T : fia_fiu32_f16>(T) -> T */
    /* fn abs<N : num, T : fia_fiu32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[283],
  },
  {
    /* [1] */
    /* fn acos<T : fa_f32_f16>(@test_value(0.96891242171) T) -> T */
    /* fn acos<N : num, T : fa_f32_f16>(@test_value(0.96891242171) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[285],
  },
  {
    /* [2] */
    /* fn acosh<T : fa_f32_f16>(@test_value(2) T) -> T */
    /* fn acosh<N : num, T : fa_f32_f16>(@test_value(2) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[287],
  },
  {
    /* [3] */
    /* fn all(bool) -> bool */
    /* fn all<N : num>(vec<N, bool>) -> bool */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[289],
  },
  {
    /* [4] */
    /* fn any(bool) -> bool */
    /* fn any<N : num>(vec<N, bool>) -> bool */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[291],
  },
  {
    /* [5] */
    /* fn arrayLength<T, A : access>(ptr<storage, array<T>, A>) -> u32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[433],
  },
  {
    /* [6] */
    /* fn asin<T : fa_f32_f16>(@test_value(0.479425538604) T) -> T */
    /* fn asin<N : num, T : fa_f32_f16>(@test_value(0.479425538604) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[293],
  },
  {
    /* [7] */
    /* fn asinh<T : fa_f32_f16>(T) -> T */
    /* fn asinh<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[295],
  },
  {
    /* [8] */
    /* fn atan<T : fa_f32_f16>(T) -> T */
    /* fn atan<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[297],
  },
  {
    /* [9] */
    /* fn atan2<T : fa_f32_f16>(T, T) -> T */
    /* fn atan2<T : fa_f32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[299],
  },
  {
    /* [10] */
    /* fn atanh<T : fa_f32_f16>(@test_value(0.5) T) -> T */
    /* fn atanh<N : num, T : fa_f32_f16>(@test_value(0.5) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[301],
  },
  {
    /* [11] */
    /* fn ceil<T : fa_f32_f16>(@test_value(1.5) T) -> T */
    /* fn ceil<N : num, T : fa_f32_f16>(@test_value(1.5) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[303],
  },
  {
    /* [12] */
    /* fn clamp<T : fia_fiu32_f16>(T, T, T) -> T */
    /* fn clamp<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[305],
  },
  {
    /* [13] */
    /* fn cos<T : fa_f32_f16>(@test_value(0) T) -> T */
    /* fn cos<N : num, T : fa_f32_f16>(@test_value(0) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[307],
  },
  {
    /* [14] */
    /* fn cosh<T : fa_f32_f16>(@test_value(0) T) -> T */
    /* fn cosh<N : num, T : fa_f32_f16>(@test_value(0) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[309],
  },
  {
    /* [15] */
    /* fn countLeadingZeros<T : iu32>(T) -> T */
    /* fn countLeadingZeros<N : num, T : iu32>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[311],
  },
  {
    /* [16] */
    /* fn countOneBits<T : iu32>(T) -> T */
    /* fn countOneBits<N : num, T : iu32>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[313],
  },
  {
    /* [17] */
    /* fn countTrailingZeros<T : iu32>(T) -> T */
    /* fn countTrailingZeros<N : num, T : iu32>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[315],
  },
  {
    /* [18] */
    /* fn cross<T : fa_f32_f16>(vec3<T>, vec3<T>) -> vec3<T> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[434],
  },
  {
    /* [19] */
    /* fn degrees<T : fa_f32_f16>(T) -> T */
    /* fn degrees<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[317],
  },
  {
    /* [20] */
    /* fn determinant<N : num, T : fa_f32_f16>(mat<N, N, T>) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[435],
  },
  {
    /* [21] */
    /* fn distance<T : fa_f32_f16>(T, T) -> T */
    /* fn distance<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>) -> T */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[319],
  },
  {
    /* [22] */
    /* fn dot<N : num, T : fia_fiu32_f16>(vec<N, T>, vec<N, T>) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[436],
  },
  {
    /* [23] */
    /* fn dot4I8Packed(u32, u32) -> i32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[437],
  },
  {
    /* [24] */
    /* fn dot4U8Packed(u32, u32) -> u32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[438],
  },
  {
    /* [25] */
    /* fn dpdx(f32) -> f32 */
    /* fn dpdx<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[321],
  },
  {
    /* [26] */
    /* fn dpdxCoarse(f32) -> f32 */
    /* fn dpdxCoarse<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[323],
  },
  {
    /* [27] */
    /* fn dpdxFine(f32) -> f32 */
    /* fn dpdxFine<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[325],
  },
  {
    /* [28] */
    /* fn dpdy(f32) -> f32 */
    /* fn dpdy<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[327],
  },
  {
    /* [29] */
    /* fn dpdyCoarse(f32) -> f32 */
    /* fn dpdyCoarse<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[329],
  },
  {
    /* [30] */
    /* fn dpdyFine(f32) -> f32 */
    /* fn dpdyFine<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[331],
  },
  {
    /* [31] */
    /* fn exp<T : fa_f32_f16>(T) -> T */
    /* fn exp<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[333],
  },
  {
    /* [32] */
    /* fn exp2<T : fa_f32_f16>(T) -> T */
    /* fn exp2<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[335],
  },
  {
    /* [33] */
    /* fn extractBits<T : iu32>(T, u32, u32) -> T */
    /* fn extractBits<N : num, T : iu32>(vec<N, T>, u32, u32) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[337],
  },
  {
    /* [34] */
    /* fn faceForward<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[439],
  },
  {
    /* [35] */
    /* fn firstLeadingBit<T : iu32>(T) -> T */
    /* fn firstLeadingBit<N : num, T : iu32>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[339],
  },
  {
    /* [36] */
    /* fn firstTrailingBit<T : iu32>(T) -> T */
    /* fn firstTrailingBit<N : num, T : iu32>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[341],
  },
  {
    /* [37] */
    /* fn floor<T : fa_f32_f16>(@test_value(1.5) T) -> T */
    /* fn floor<N : num, T : fa_f32_f16>(@test_value(1.5) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[343],
  },
  {
    /* [38] */
    /* fn fma<T : fa_f32_f16>(T, T, T) -> T */
    /* fn fma<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[345],
  },
  {
    /* [39] */
    /* fn fract<T : fa_f32_f16>(@test_value(1.25) T) -> T */
    /* fn fract<N : num, T : fa_f32_f16>(@test_value(1.25) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[347],
  },
  {
    /* [40] */
    /* fn frexp<T : fa_f32_f16>(T) -> __frexp_result<T> */
    /* fn frexp<N : num, T : fa_f32_f16>(vec<N, T>) -> __frexp_result_vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[349],
  },
  {
    /* [41] */
    /* fn fwidth(f32) -> f32 */
    /* fn fwidth<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[351],
  },
  {
    /* [42] */
    /* fn fwidthCoarse(f32) -> f32 */
    /* fn fwidthCoarse<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[353],
  },
  {
    /* [43] */
    /* fn fwidthFine(f32) -> f32 */
    /* fn fwidthFine<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[355],
  },
  {
    /* [44] */
    /* fn insertBits<T : iu32>(T, T, u32, u32) -> T */
    /* fn insertBits<N : num, T : iu32>(vec<N, T>, vec<N, T>, u32, u32) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[357],
  },
  {
    /* [45] */
    /* fn inverseSqrt<T : fa_f32_f16>(T) -> T */
    /* fn inverseSqrt<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[359],
  },
  {
    /* [46] */
    /* fn ldexp<T : fa_f32_f16, U : ia_i32>(T, U) -> T */
    /* fn ldexp<N : num, T : fa_f32_f16, U : ia_i32>(vec<N, T>, vec<N, U>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[361],
  },
  {
    /* [47] */
    /* fn length<T : fa_f32_f16>(@test_value(0) T) -> T */
    /* fn length<N : num, T : fa_f32_f16>(@test_value(0) vec<N, T>) -> T */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[363],
  },
  {
    /* [48] */
    /* fn log<T : fa_f32_f16>(T) -> T */
    /* fn log<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[365],
  },
  {
    /* [49] */
    /* fn log2<T : fa_f32_f16>(T) -> T */
    /* fn log2<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[367],
  },
  {
    /* [50] */
    /* fn max<T : fia_fiu32_f16>(T, T) -> T */
    /* fn max<N : num, T : fia_fiu32_f16>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[369],
  },
  {
    /* [51] */
    /* fn min<T : fia_fiu32_f16>(T, T) -> T */
    /* fn min<N : num, T : fia_fiu32_f16>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[371],
  },
  {
    /* [52] */
    /* fn mix<T : fa_f32_f16>(T, T, T) -> T */
    /* fn mix<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* fn mix<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>, T) -> vec<N, T> */
    /* num overloads */ 3,
    /* overloads */ &kOverloads[262],
  },
  {
    /* [53] */
    /* fn modf<T : fa_f32_f16>(@test_value(-1.5) T) -> __modf_result<T> */
    /* fn modf<N : num, T : fa_f32_f16>(@test_value(-1.5) vec<N, T>) -> __modf_result_vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[373],
  },
  {
    /* [54] */
    /* fn normalize<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[440],
  },
  {
    /* [55] */
    /* fn pack2x16float(vec2<f32>) -> u32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[441],
  },
  {
    /* [56] */
    /* fn pack2x16snorm(vec2<f32>) -> u32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[442],
  },
  {
    /* [57] */
    /* fn pack2x16unorm(vec2<f32>) -> u32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[443],
  },
  {
    /* [58] */
    /* fn pack4x8snorm(vec4<f32>) -> u32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[444],
  },
  {
    /* [59] */
    /* fn pack4x8unorm(vec4<f32>) -> u32 */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[445],
  },
  {
    /* [60] */
    /* fn pow<T : fa_f32_f16>(T, T) -> T */
    /* fn pow<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[375],
  },
  {
    /* [61] */
    /* fn quantizeToF16(f32) -> f32 */
    /* fn quantizeToF16<N : num>(vec<N, f32>) -> vec<N, f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[377],
  },
  {
    /* [62] */
    /* fn radians<T : fa_f32_f16>(T) -> T */
    /* fn radians<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[379],
  },
  {
    /* [63] */
    /* fn reflect<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[446],
  },
  {
    /* [64] */
    /* fn refract<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>, T) -> vec<N, T> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[447],
  },
  {
    /* [65] */
    /* fn reverseBits<T : iu32>(T) -> T */
    /* fn reverseBits<N : num, T : iu32>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[381],
  },
  {
    /* [66] */
    /* fn round<T : fa_f32_f16>(@test_value(3.4) T) -> T */
    /* fn round<N : num, T : fa_f32_f16>(@test_value(3.4) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[383],
  },
  {
    /* [67] */
    /* fn saturate<T : fa_f32_f16>(@test_value(2) T) -> T */
    /* fn saturate<T : fa_f32_f16, N : num>(@test_value(2) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[385],
  },
  {
    /* [68] */
    /* fn select<T : scalar>(T, T, bool) -> T */
    /* fn select<T : scalar, N : num>(vec<N, T>, vec<N, T>, bool) -> vec<N, T> */
    /* fn select<N : num, T : scalar>(vec<N, T>, vec<N, T>, vec<N, bool>) -> vec<N, T> */
    /* num overloads */ 3,
    /* overloads */ &kOverloads[265],
  },
  {
    /* [69] */
    /* fn sign<T : fia_fi32_f16>(T) -> T */
    /* fn sign<N : num, T : fia_fi32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[387],
  },
  {
    /* [70] */
    /* fn sin<T : fa_f32_f16>(T) -> T */
    /* fn sin<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[389],
  },
  {
    /* [71] */
    /* fn sinh<T : fa_f32_f16>(T) -> T */
    /* fn sinh<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[391],
  },
  {
    /* [72] */
    /* fn smoothstep<T : fa_f32_f16>(@test_value(2) T, @test_value(4) T, @test_value(3) T) -> T */
    /* fn smoothstep<N : num, T : fa_f32_f16>(@test_value(2) vec<N, T>, @test_value(4) vec<N, T>, @test_value(3) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[393],
  },
  {
    /* [73] */
    /* fn sqrt<T : fa_f32_f16>(T) -> T */
    /* fn sqrt<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[395],
  },
  {
    /* [74] */
    /* fn step<T : fa_f32_f16>(T, T) -> T */
    /* fn step<N : num, T : fa_f32_f16>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[397],
  },
  {
    /* [75] */
    /* fn storageBarrier() */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[448],
  },
  {
    /* [76] */
    /* fn tan<T : fa_f32_f16>(T) -> T */
    /* fn tan<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[399],
  },
  {
    /* [77] */
    /* fn tanh<T : fa_f32_f16>(T) -> T */
    /* fn tanh<N : num, T : fa_f32_f16>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[401],
  },
  {
    /* [78] */
    /* fn transpose<M : num, N : num, T : fa_f32_f16>(mat<M, N, T>) -> mat<N, M, T> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[449],
  },
  {
    /* [79] */
    /* fn trunc<T : fa_f32_f16>(@test_value(1.5) T) -> T */
    /* fn trunc<N : num, T : fa_f32_f16>(@test_value(1.5) vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[403],
  },
  {
    /* [80] */
    /* fn unpack2x16float(u32) -> vec2<f32> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[450],
  },
  {
    /* [81] */
    /* fn unpack2x16snorm(u32) -> vec2<f32> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[451],
  },
  {
    /* [82] */
    /* fn unpack2x16unorm(u32) -> vec2<f32> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[452],
  },
  {
    /* [83] */
    /* fn unpack4x8snorm(u32) -> vec4<f32> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[453],
  },
  {
    /* [84] */
    /* fn unpack4x8unorm(u32) -> vec4<f32> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[454],
  },
  {
    /* [85] */
    /* fn workgroupBarrier() */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[455],
  },
  {
    /* [86] */
    /* fn workgroupUniformLoad<T>(ptr<workgroup, T, read_write>) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[456],
  },
  {
    /* [87] */
    /* fn textureDimensions<T : fiu32>(texture: texture_1d<T>) -> u32 */
    /* fn textureDimensions<T : fiu32, L : iu32>(texture: texture_1d<T>, level: L) -> u32 */
    /* fn textureDimensions<T : fiu32>(texture: texture_2d<T>) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32, L : iu32>(texture: texture_2d<T>, level: L) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32>(texture: texture_2d_array<T>) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32, L : iu32>(texture: texture_2d_array<T>, level: L) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32>(texture: texture_3d<T>) -> vec3<u32> */
    /* fn textureDimensions<T : fiu32, L : iu32>(texture: texture_3d<T>, level: L) -> vec3<u32> */
    /* fn textureDimensions<T : fiu32>(texture: texture_cube<T>) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32, L : iu32>(texture: texture_cube<T>, level: L) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32>(texture: texture_cube_array<T>) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32, L : iu32>(texture: texture_cube_array<T>, level: L) -> vec2<u32> */
    /* fn textureDimensions<T : fiu32>(texture: texture_multisampled_2d<T>) -> vec2<u32> */
    /* fn textureDimensions(texture: texture_depth_2d) -> vec2<u32> */
    /* fn textureDimensions<L : iu32>(texture: texture_depth_2d, level: L) -> vec2<u32> */
    /* fn textureDimensions(texture: texture_depth_2d_array) -> vec2<u32> */
    /* fn textureDimensions<L : iu32>(texture: texture_depth_2d_array, level: L) -> vec2<u32> */
    /* fn textureDimensions(texture: texture_depth_cube) -> vec2<u32> */
    /* fn textureDimensions<L : iu32>(texture: texture_depth_cube, level: L) -> vec2<u32> */
    /* fn textureDimensions(texture: texture_depth_cube_array) -> vec2<u32> */
    /* fn textureDimensions<L : iu32>(texture: texture_depth_cube_array, level: L) -> vec2<u32> */
    /* fn textureDimensions(texture: texture_depth_multisampled_2d) -> vec2<u32> */
    /* fn textureDimensions<F : texel_format, A : write>(texture: texture_storage_1d<F, A>) -> u32 */
    /* fn textureDimensions<F : texel_format, A : write>(texture: texture_storage_2d<F, A>) -> vec2<u32> */
    /* fn textureDimensions<F : texel_format, A : write>(texture: texture_storage_2d_array<F, A>) -> vec2<u32> */
    /* fn textureDimensions<F : texel_format, A : write>(texture: texture_storage_3d<F, A>) -> vec3<u32> */
    /* fn textureDimensions(texture: texture_external) -> vec2<u32> */
    /* num overloads */ 27,
    /* overloads */ &kOverloads[0],
  },
  {
    /* [88] */
    /* fn textureGather<T : fiu32, C : iu32>(@const component: C, texture: texture_2d<T>, sampler: sampler, coords: vec2<f32>) -> vec4<T> */
    /* fn textureGather<T : fiu32, C : iu32>(@const component: C, texture: texture_2d<T>, sampler: sampler, coords: vec2<f32>, @const offset: vec2<i32>) -> vec4<T> */
    /* fn textureGather<T : fiu32, C : iu32, A : iu32>(@const component: C, texture: texture_2d_array<T>, sampler: sampler, coords: vec2<f32>, array_index: A) -> vec4<T> */
    /* fn textureGather<T : fiu32, C : iu32, A : iu32>(@const component: C, texture: texture_2d_array<T>, sampler: sampler, coords: vec2<f32>, array_index: A, @const offset: vec2<i32>) -> vec4<T> */
    /* fn textureGather<T : fiu32, C : iu32>(@const component: C, texture: texture_cube<T>, sampler: sampler, coords: vec3<f32>) -> vec4<T> */
    /* fn textureGather<T : fiu32, C : iu32, A : iu32>(@const component: C, texture: texture_cube_array<T>, sampler: sampler, coords: vec3<f32>, array_index: A) -> vec4<T> */
    /* fn textureGather(texture: texture_depth_2d, sampler: sampler, coords: vec2<f32>) -> vec4<f32> */
    /* fn textureGather(texture: texture_depth_2d, sampler: sampler, coords: vec2<f32>, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureGather<A : iu32>(texture: texture_depth_2d_array, sampler: sampler, coords: vec2<f32>, array_index: A) -> vec4<f32> */
    /* fn textureGather<A : iu32>(texture: texture_depth_2d_array, sampler: sampler, coords: vec2<f32>, array_index: A, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureGather(texture: texture_depth_cube, sampler: sampler, coords: vec3<f32>) -> vec4<f32> */
    /* fn textureGather<A : iu32>(texture: texture_depth_cube_array, sampler: sampler, coords: vec3<f32>, array_index: A) -> vec4<f32> */
    /* num overloads */ 12,
    /* overloads */ &kOverloads[71],
  },
  {
    /* [89] */
    /* fn textureGatherCompare(texture: texture_depth_2d, sampler: sampler_comparison, coords: vec2<f32>, depth_ref: f32) -> vec4<f32> */
    /* fn textureGatherCompare(texture: texture_depth_2d, sampler: sampler_comparison, coords: vec2<f32>, depth_ref: f32, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureGatherCompare<A : iu32>(texture: texture_depth_2d_array, sampler: sampler_comparison, coords: vec2<f32>, array_index: A, depth_ref: f32) -> vec4<f32> */
    /* fn textureGatherCompare<A : iu32>(texture: texture_depth_2d_array, sampler: sampler_comparison, coords: vec2<f32>, array_index: A, depth_ref: f32, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureGatherCompare(texture: texture_depth_cube, sampler: sampler_comparison, coords: vec3<f32>, depth_ref: f32) -> vec4<f32> */
    /* fn textureGatherCompare<A : iu32>(texture: texture_depth_cube_array, sampler: sampler_comparison, coords: vec3<f32>, array_index: A, depth_ref: f32) -> vec4<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[159],
  },
  {
    /* [90] */
    /* fn textureNumLayers<T : fiu32>(texture: texture_2d_array<T>) -> u32 */
    /* fn textureNumLayers<T : fiu32>(texture: texture_cube_array<T>) -> u32 */
    /* fn textureNumLayers(texture: texture_depth_2d_array) -> u32 */
    /* fn textureNumLayers(texture: texture_depth_cube_array) -> u32 */
    /* fn textureNumLayers<F : texel_format, A : write>(texture: texture_storage_2d_array<F, A>) -> u32 */
    /* num overloads */ 5,
    /* overloads */ &kOverloads[231],
  },
  {
    /* [91] */
    /* fn textureNumLevels<T : fiu32>(texture: texture_1d<T>) -> u32 */
    /* fn textureNumLevels<T : fiu32>(texture: texture_2d<T>) -> u32 */
    /* fn textureNumLevels<T : fiu32>(texture: texture_2d_array<T>) -> u32 */
    /* fn textureNumLevels<T : fiu32>(texture: texture_3d<T>) -> u32 */
    /* fn textureNumLevels<T : fiu32>(texture: texture_cube<T>) -> u32 */
    /* fn textureNumLevels<T : fiu32>(texture: texture_cube_array<T>) -> u32 */
    /* fn textureNumLevels(texture: texture_depth_2d) -> u32 */
    /* fn textureNumLevels(texture: texture_depth_2d_array) -> u32 */
    /* fn textureNumLevels(texture: texture_depth_cube) -> u32 */
    /* fn textureNumLevels(texture: texture_depth_cube_array) -> u32 */
    /* num overloads */ 10,
    /* overloads */ &kOverloads[106],
  },
  {
    /* [92] */
    /* fn textureNumSamples<T : fiu32>(texture: texture_multisampled_2d<T>) -> u32 */
    /* fn textureNumSamples(texture: texture_depth_multisampled_2d) -> u32 */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[405],
  },
  {
    /* [93] */
    /* fn textureSample(texture: texture_1d<f32>, sampler: sampler, coords: f32) -> vec4<f32> */
    /* fn textureSample(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>) -> vec4<f32> */
    /* fn textureSample(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSample<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A) -> vec4<f32> */
    /* fn textureSample<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSample(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>) -> vec4<f32> */
    /* fn textureSample(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>, @const offset: vec3<i32>) -> vec4<f32> */
    /* fn textureSample(texture: texture_cube<f32>, sampler: sampler, coords: vec3<f32>) -> vec4<f32> */
    /* fn textureSample<A : iu32>(texture: texture_cube_array<f32>, sampler: sampler, coords: vec3<f32>, array_index: A) -> vec4<f32> */
    /* fn textureSample(texture: texture_depth_2d, sampler: sampler, coords: vec2<f32>) -> f32 */
    /* fn textureSample(texture: texture_depth_2d, sampler: sampler, coords: vec2<f32>, @const offset: vec2<i32>) -> f32 */
    /* fn textureSample<A : iu32>(texture: texture_depth_2d_array, sampler: sampler, coords: vec2<f32>, array_index: A) -> f32 */
    /* fn textureSample<A : iu32>(texture: texture_depth_2d_array, sampler: sampler, coords: vec2<f32>, array_index: A, @const offset: vec2<i32>) -> f32 */
    /* fn textureSample(texture: texture_depth_cube, sampler: sampler, coords: vec3<f32>) -> f32 */
    /* fn textureSample<A : iu32>(texture: texture_depth_cube_array, sampler: sampler, coords: vec3<f32>, array_index: A) -> f32 */
    /* num overloads */ 15,
    /* overloads */ &kOverloads[27],
  },
  {
    /* [94] */
    /* fn textureSampleBias(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>, bias: f32) -> vec4<f32> */
    /* fn textureSampleBias(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>, bias: f32, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSampleBias<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A, bias: f32) -> vec4<f32> */
    /* fn textureSampleBias<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A, bias: f32, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSampleBias(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>, bias: f32) -> vec4<f32> */
    /* fn textureSampleBias(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>, bias: f32, @const offset: vec3<i32>) -> vec4<f32> */
    /* fn textureSampleBias(texture: texture_cube<f32>, sampler: sampler, coords: vec3<f32>, bias: f32) -> vec4<f32> */
    /* fn textureSampleBias<A : iu32>(texture: texture_cube_array<f32>, sampler: sampler, coords: vec3<f32>, array_index: A, bias: f32) -> vec4<f32> */
    /* num overloads */ 8,
    /* overloads */ &kOverloads[143],
  },
  {
    /* [95] */
    /* fn textureSampleCompare(texture: texture_depth_2d, sampler: sampler_comparison, coords: vec2<f32>, depth_ref: f32) -> f32 */
    /* fn textureSampleCompare(texture: texture_depth_2d, sampler: sampler_comparison, coords: vec2<f32>, depth_ref: f32, @const offset: vec2<i32>) -> f32 */
    /* fn textureSampleCompare<A : iu32>(texture: texture_depth_2d_array, sampler: sampler_comparison, coords: vec2<f32>, array_index: A, depth_ref: f32) -> f32 */
    /* fn textureSampleCompare<A : iu32>(texture: texture_depth_2d_array, sampler: sampler_comparison, coords: vec2<f32>, array_index: A, depth_ref: f32, @const offset: vec2<i32>) -> f32 */
    /* fn textureSampleCompare(texture: texture_depth_cube, sampler: sampler_comparison, coords: vec3<f32>, depth_ref: f32) -> f32 */
    /* fn textureSampleCompare<A : iu32>(texture: texture_depth_cube_array, sampler: sampler_comparison, coords: vec3<f32>, array_index: A, depth_ref: f32) -> f32 */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[165],
  },
  {
    /* [96] */
    /* fn textureSampleCompareLevel(texture: texture_depth_2d, sampler: sampler_comparison, coords: vec2<f32>, depth_ref: f32) -> f32 */
    /* fn textureSampleCompareLevel(texture: texture_depth_2d, sampler: sampler_comparison, coords: vec2<f32>, depth_ref: f32, @const offset: vec2<i32>) -> f32 */
    /* fn textureSampleCompareLevel<A : iu32>(texture: texture_depth_2d_array, sampler: sampler_comparison, coords: vec2<f32>, array_index: A, depth_ref: f32) -> f32 */
    /* fn textureSampleCompareLevel<A : iu32>(texture: texture_depth_2d_array, sampler: sampler_comparison, coords: vec2<f32>, array_index: A, depth_ref: f32, @const offset: vec2<i32>) -> f32 */
    /* fn textureSampleCompareLevel(texture: texture_depth_cube, sampler: sampler_comparison, coords: vec3<f32>, depth_ref: f32) -> f32 */
    /* fn textureSampleCompareLevel<A : iu32>(texture: texture_depth_cube_array, sampler: sampler_comparison, coords: vec3<f32>, array_index: A, depth_ref: f32) -> f32 */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[171],
  },
  {
    /* [97] */
    /* fn textureSampleGrad(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>, ddx: vec2<f32>, ddy: vec2<f32>) -> vec4<f32> */
    /* fn textureSampleGrad(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>, ddx: vec2<f32>, ddy: vec2<f32>, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSampleGrad<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A, ddx: vec2<f32>, ddy: vec2<f32>) -> vec4<f32> */
    /* fn textureSampleGrad<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A, ddx: vec2<f32>, ddy: vec2<f32>, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSampleGrad(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>, ddx: vec3<f32>, ddy: vec3<f32>) -> vec4<f32> */
    /* fn textureSampleGrad(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>, ddx: vec3<f32>, ddy: vec3<f32>, @const offset: vec3<i32>) -> vec4<f32> */
    /* fn textureSampleGrad(texture: texture_cube<f32>, sampler: sampler, coords: vec3<f32>, ddx: vec3<f32>, ddy: vec3<f32>) -> vec4<f32> */
    /* fn textureSampleGrad<A : iu32>(texture: texture_cube_array<f32>, sampler: sampler, coords: vec3<f32>, array_index: A, ddx: vec3<f32>, ddy: vec3<f32>) -> vec4<f32> */
    /* num overloads */ 8,
    /* overloads */ &kOverloads[151],
  },
  {
    /* [98] */
    /* fn textureSampleLevel(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>, level: f32) -> vec4<f32> */
    /* fn textureSampleLevel(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>, level: f32, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSampleLevel<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A, level: f32) -> vec4<f32> */
    /* fn textureSampleLevel<A : iu32>(texture: texture_2d_array<f32>, sampler: sampler, coords: vec2<f32>, array_index: A, level: f32, @const offset: vec2<i32>) -> vec4<f32> */
    /* fn textureSampleLevel(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>, level: f32) -> vec4<f32> */
    /* fn textureSampleLevel(texture: texture_3d<f32>, sampler: sampler, coords: vec3<f32>, level: f32, @const offset: vec3<i32>) -> vec4<f32> */
    /* fn textureSampleLevel(texture: texture_cube<f32>, sampler: sampler, coords: vec3<f32>, level: f32) -> vec4<f32> */
    /* fn textureSampleLevel<A : iu32>(texture: texture_cube_array<f32>, sampler: sampler, coords: vec3<f32>, array_index: A, level: f32) -> vec4<f32> */
    /* fn textureSampleLevel<L : iu32>(texture: texture_depth_2d, sampler: sampler, coords: vec2<f32>, level: L) -> f32 */
    /* fn textureSampleLevel<L : iu32>(texture: texture_depth_2d, sampler: sampler, coords: vec2<f32>, level: L, @const offset: vec2<i32>) -> f32 */
    /* fn textureSampleLevel<A : iu32, L : iu32>(texture: texture_depth_2d_array, sampler: sampler, coords: vec2<f32>, array_index: A, level: L) -> f32 */
    /* fn textureSampleLevel<A : iu32, L : iu32>(texture: texture_depth_2d_array, sampler: sampler, coords: vec2<f32>, array_index: A, level: L, @const offset: vec2<i32>) -> f32 */
    /* fn textureSampleLevel<L : iu32>(texture: texture_depth_cube, sampler: sampler, coords: vec3<f32>, level: L) -> f32 */
    /* fn textureSampleLevel<A : iu32, L : iu32>(texture: texture_depth_cube_array, sampler: sampler, coords: vec3<f32>, array_index: A, level: L) -> f32 */
    /* num overloads */ 14,
    /* overloads */ &kOverloads[57],
  },
  {
    /* [99] */
    /* fn textureSampleBaseClampToEdge(texture: texture_2d<f32>, sampler: sampler, coords: vec2<f32>) -> vec4<f32> */
    /* fn textureSampleBaseClampToEdge(texture: texture_external, sampler: sampler, coords: vec2<f32>) -> vec4<f32> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[407],
  },
  {
    /* [100] */
    /* fn textureStore<C : iu32>(texture: texture_storage_1d<f32_texel_format, write>, coords: C, value: vec4<f32>) */
    /* fn textureStore<C : iu32>(texture: texture_storage_2d<f32_texel_format, write>, coords: vec2<C>, value: vec4<f32>) */
    /* fn textureStore<C : iu32, A : iu32>(texture: texture_storage_2d_array<f32_texel_format, write>, coords: vec2<C>, array_index: A, value: vec4<f32>) */
    /* fn textureStore<C : iu32>(texture: texture_storage_3d<f32_texel_format, write>, coords: vec3<C>, value: vec4<f32>) */
    /* fn textureStore<C : iu32>(texture: texture_storage_1d<i32_texel_format, write>, coords: C, value: vec4<i32>) */
    /* fn textureStore<C : iu32>(texture: texture_storage_2d<i32_texel_format, write>, coords: vec2<C>, value: vec4<i32>) */
    /* fn textureStore<C : iu32, A : iu32>(texture: texture_storage_2d_array<i32_texel_format, write>, coords: vec2<C>, array_index: A, value: vec4<i32>) */
    /* fn textureStore<C : iu32>(texture: texture_storage_3d<i32_texel_format, write>, coords: vec3<C>, value: vec4<i32>) */
    /* fn textureStore<C : iu32>(texture: texture_storage_1d<u32_texel_format, write>, coords: C, value: vec4<u32>) */
    /* fn textureStore<C : iu32>(texture: texture_storage_2d<u32_texel_format, write>, coords: vec2<C>, value: vec4<u32>) */
    /* fn textureStore<C : iu32, A : iu32>(texture: texture_storage_2d_array<u32_texel_format, write>, coords: vec2<C>, array_index: A, value: vec4<u32>) */
    /* fn textureStore(texture: texture_storage_3d<u32_texel_format, write>, coords: vec3<i32>, value: vec4<u32>) */
    /* num overloads */ 12,
    /* overloads */ &kOverloads[83],
  },
  {
    /* [101] */
    /* fn textureLoad<T : fiu32, C : iu32, L : iu32>(texture: texture_1d<T>, coords: C, level: L) -> vec4<T> */
    /* fn textureLoad<T : fiu32, C : iu32, L : iu32>(texture: texture_2d<T>, coords: vec2<C>, level: L) -> vec4<T> */
    /* fn textureLoad<T : fiu32, C : iu32, A : iu32, L : iu32>(texture: texture_2d_array<T>, coords: vec2<C>, array_index: A, level: L) -> vec4<T> */
    /* fn textureLoad<T : fiu32, C : iu32, L : iu32>(texture: texture_3d<T>, coords: vec3<C>, level: L) -> vec4<T> */
    /* fn textureLoad<T : fiu32, C : iu32, S : iu32>(texture: texture_multisampled_2d<T>, coords: vec2<C>, sample_index: S) -> vec4<T> */
    /* fn textureLoad<C : iu32, L : iu32>(texture: texture_depth_2d, coords: vec2<C>, level: L) -> f32 */
    /* fn textureLoad<C : iu32, A : iu32, L : iu32>(texture: texture_depth_2d_array, coords: vec2<C>, array_index: A, level: L) -> f32 */
    /* fn textureLoad<C : iu32, S : iu32>(texture: texture_depth_multisampled_2d, coords: vec2<C>, sample_index: S) -> f32 */
    /* fn textureLoad<C : iu32>(texture: texture_external, coords: vec2<C>) -> vec4<f32> */
    /* num overloads */ 9,
    /* overloads */ &kOverloads[116],
  },
  {
    /* [102] */
    /* fn atomicLoad<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[457],
  },
  {
    /* [103] */
    /* fn atomicStore<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[458],
  },
  {
    /* [104] */
    /* fn atomicAdd<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[459],
  },
  {
    /* [105] */
    /* fn atomicSub<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[460],
  },
  {
    /* [106] */
    /* fn atomicMax<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[461],
  },
  {
    /* [107] */
    /* fn atomicMin<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[462],
  },
  {
    /* [108] */
    /* fn atomicAnd<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[463],
  },
  {
    /* [109] */
    /* fn atomicOr<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[464],
  },
  {
    /* [110] */
    /* fn atomicXor<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[465],
  },
  {
    /* [111] */
    /* fn atomicExchange<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[466],
  },
  {
    /* [112] */
    /* fn atomicCompareExchangeWeak<T : iu32, S : workgroup_or_storage>(ptr<S, atomic<T>, read_write>, T, T) -> __atomic_compare_exchange_result<T> */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[467],
  },
  {
    /* [113] */
    /* fn _tint_materialize<T>(T) -> T */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[468],
  },
};

constexpr IntrinsicInfo kUnaryOperators[] = {
  {
    /* [0] */
    /* op !(bool) -> bool */
    /* op !<N : num>(vec<N, bool>) -> vec<N, bool> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[409],
  },
  {
    /* [1] */
    /* op ~<T : ia_iu32>(T) -> T */
    /* op ~<T : ia_iu32, N : num>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[411],
  },
  {
    /* [2] */
    /* op -<T : fia_fi32_f16>(T) -> T */
    /* op -<T : fia_fi32_f16, N : num>(vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[413],
  },
};
constexpr uint8_t kUnaryOperatorNot = 0;
constexpr uint8_t kUnaryOperatorComplement = 1;
constexpr uint8_t kUnaryOperatorMinus = 2;

constexpr IntrinsicInfo kBinaryOperators[] = {
  {
    /* [0] */
    /* op +<T : fia_fiu32_f16>(T, T) -> T */
    /* op +<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* op +<T : fia_fiu32_f16, N : num>(vec<N, T>, T) -> vec<N, T> */
    /* op +<T : fia_fiu32_f16, N : num>(T, vec<N, T>) -> vec<N, T> */
    /* op +<T : fa_f32_f16, N : num, M : num>(mat<N, M, T>, mat<N, M, T>) -> mat<N, M, T> */
    /* num overloads */ 5,
    /* overloads */ &kOverloads[236],
  },
  {
    /* [1] */
    /* op -<T : fia_fiu32_f16>(T, T) -> T */
    /* op -<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* op -<T : fia_fiu32_f16, N : num>(vec<N, T>, T) -> vec<N, T> */
    /* op -<T : fia_fiu32_f16, N : num>(T, vec<N, T>) -> vec<N, T> */
    /* op -<T : fa_f32_f16, N : num, M : num>(mat<N, M, T>, mat<N, M, T>) -> mat<N, M, T> */
    /* num overloads */ 5,
    /* overloads */ &kOverloads[241],
  },
  {
    /* [2] */
    /* op *<T : fia_fiu32_f16>(T, T) -> T */
    /* op *<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* op *<T : fia_fiu32_f16, N : num>(vec<N, T>, T) -> vec<N, T> */
    /* op *<T : fia_fiu32_f16, N : num>(T, vec<N, T>) -> vec<N, T> */
    /* op *<T : fa_f32_f16, N : num, M : num>(T, mat<N, M, T>) -> mat<N, M, T> */
    /* op *<T : fa_f32_f16, N : num, M : num>(mat<N, M, T>, T) -> mat<N, M, T> */
    /* op *<T : fa_f32_f16, C : num, R : num>(mat<C, R, T>, vec<C, T>) -> vec<R, T> */
    /* op *<T : fa_f32_f16, C : num, R : num>(vec<R, T>, mat<C, R, T>) -> vec<C, T> */
    /* op *<T : fa_f32_f16, K : num, C : num, R : num>(mat<K, R, T>, mat<C, K, T>) -> mat<C, R, T> */
    /* num overloads */ 9,
    /* overloads */ &kOverloads[125],
  },
  {
    /* [3] */
    /* op /<T : fia_fiu32_f16>(T, T) -> T */
    /* op /<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* op /<T : fia_fiu32_f16, N : num>(vec<N, T>, T) -> vec<N, T> */
    /* op /<T : fia_fiu32_f16, N : num>(T, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 4,
    /* overloads */ &kOverloads[246],
  },
  {
    /* [4] */
    /* op %<T : fia_fiu32_f16>(T, T) -> T */
    /* op %<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* op %<T : fia_fiu32_f16, N : num>(vec<N, T>, T) -> vec<N, T> */
    /* op %<T : fia_fiu32_f16, N : num>(T, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 4,
    /* overloads */ &kOverloads[250],
  },
  {
    /* [5] */
    /* op ^<T : ia_iu32>(T, T) -> T */
    /* op ^<T : ia_iu32, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[415],
  },
  {
    /* [6] */
    /* op &(bool, bool) -> bool */
    /* op &<N : num>(vec<N, bool>, vec<N, bool>) -> vec<N, bool> */
    /* op &<T : ia_iu32>(T, T) -> T */
    /* op &<T : ia_iu32, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 4,
    /* overloads */ &kOverloads[254],
  },
  {
    /* [7] */
    /* op |(bool, bool) -> bool */
    /* op |<N : num>(vec<N, bool>, vec<N, bool>) -> vec<N, bool> */
    /* op |<T : ia_iu32>(T, T) -> T */
    /* op |<T : ia_iu32, N : num>(vec<N, T>, vec<N, T>) -> vec<N, T> */
    /* num overloads */ 4,
    /* overloads */ &kOverloads[258],
  },
  {
    /* [8] */
    /* op &&(bool, bool) -> bool */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[469],
  },
  {
    /* [9] */
    /* op ||(bool, bool) -> bool */
    /* num overloads */ 1,
    /* overloads */ &kOverloads[470],
  },
  {
    /* [10] */
    /* op ==<T : scalar>(T, T) -> bool */
    /* op ==<T : scalar, N : num>(vec<N, T>, vec<N, T>) -> vec<N, bool> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[417],
  },
  {
    /* [11] */
    /* op !=<T : scalar>(T, T) -> bool */
    /* op !=<T : scalar, N : num>(vec<N, T>, vec<N, T>) -> vec<N, bool> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[419],
  },
  {
    /* [12] */
    /* op <<T : fia_fiu32_f16>(T, T) -> bool */
    /* op <<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, bool> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[421],
  },
  {
    /* [13] */
    /* op ><T : fia_fiu32_f16>(T, T) -> bool */
    /* op ><T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, bool> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[423],
  },
  {
    /* [14] */
    /* op <=<T : fia_fiu32_f16>(T, T) -> bool */
    /* op <=<T : fia_fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, bool> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[425],
  },
  {
    /* [15] */
    /* op >=<T : fia_fiu32_f16>(T, T) -> bool */
    /* op >=<T : fiu32_f16, N : num>(vec<N, T>, vec<N, T>) -> vec<N, bool> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[427],
  },
  {
    /* [16] */
    /* op <<<T : ia_iu32>(T, u32) -> T */
    /* op <<<T : ia_iu32, N : num>(vec<N, T>, vec<N, u32>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[429],
  },
  {
    /* [17] */
    /* op >><T : ia_iu32>(T, u32) -> T */
    /* op >><T : ia_iu32, N : num>(vec<N, T>, vec<N, u32>) -> vec<N, T> */
    /* num overloads */ 2,
    /* overloads */ &kOverloads[431],
  },
};
constexpr uint8_t kBinaryOperatorPlus = 0;
constexpr uint8_t kBinaryOperatorMinus = 1;
constexpr uint8_t kBinaryOperatorStar = 2;
constexpr uint8_t kBinaryOperatorDivide = 3;
constexpr uint8_t kBinaryOperatorModulo = 4;
constexpr uint8_t kBinaryOperatorXor = 5;
constexpr uint8_t kBinaryOperatorAnd = 6;
constexpr uint8_t kBinaryOperatorOr = 7;
constexpr uint8_t kBinaryOperatorLogicalAnd = 8;
constexpr uint8_t kBinaryOperatorLogicalOr = 9;
constexpr uint8_t kBinaryOperatorEqual = 10;
constexpr uint8_t kBinaryOperatorNotEqual = 11;
constexpr uint8_t kBinaryOperatorLessThan = 12;
constexpr uint8_t kBinaryOperatorGreaterThan = 13;
constexpr uint8_t kBinaryOperatorLessThanEqual = 14;
constexpr uint8_t kBinaryOperatorGreaterThanEqual = 15;
constexpr uint8_t kBinaryOperatorShiftLeft = 16;
constexpr uint8_t kBinaryOperatorShiftRight = 17;

constexpr IntrinsicInfo kConstructorsAndConverters[] = {
  {
    /* [0] */
    /* ctor i32() -> i32 */
    /* ctor i32(i32) -> i32 */
    /* conv i32<T : scalar_no_i32>(T) -> i32 */
    /* num overloads */ 3,
    /* overloads */ &kOverloads[268],
  },
  {
    /* [1] */
    /* ctor u32() -> u32 */
    /* ctor u32(u32) -> u32 */
    /* conv u32<T : scalar_no_u32>(T) -> u32 */
    /* num overloads */ 3,
    /* overloads */ &kOverloads[271],
  },
  {
    /* [2] */
    /* ctor f32() -> f32 */
    /* ctor f32(f32) -> f32 */
    /* conv f32<T : scalar_no_f32>(T) -> f32 */
    /* num overloads */ 3,
    /* overloads */ &kOverloads[274],
  },
  {
    /* [3] */
    /* ctor f16() -> f16 */
    /* ctor f16(f16) -> f16 */
    /* conv f16<T : scalar_no_f16>(T) -> f16 */
    /* num overloads */ 3,
    /* overloads */ &kOverloads[277],
  },
  {
    /* [4] */
    /* ctor bool() -> bool */
    /* ctor bool(bool) -> bool */
    /* conv bool<T : scalar_no_bool>(T) -> bool */
    /* num overloads */ 3,
    /* overloads */ &kOverloads[280],
  },
  {
    /* [5] */
    /* ctor vec2<T : concrete_scalar>() -> vec2<T> */
    /* ctor vec2<T : scalar>(vec2<T>) -> vec2<T> */
    /* ctor vec2<T : scalar>(T) -> vec2<T> */
    /* ctor vec2<T : scalar>(x: T, y: T) -> vec2<T> */
    /* conv vec2<T : f32, U : scalar_no_f32>(vec2<U>) -> vec2<f32> */
    /* conv vec2<T : f16, U : scalar_no_f16>(vec2<U>) -> vec2<f16> */
    /* conv vec2<T : i32, U : scalar_no_i32>(vec2<U>) -> vec2<i32> */
    /* conv vec2<T : u32, U : scalar_no_u32>(vec2<U>) -> vec2<u32> */
    /* conv vec2<T : bool, U : scalar_no_bool>(vec2<U>) -> vec2<bool> */
    /* num overloads */ 9,
    /* overloads */ &kOverloads[134],
  },
  {
    /* [6] */
    /* ctor vec3<T : concrete_scalar>() -> vec3<T> */
    /* ctor vec3<T : scalar>(vec3<T>) -> vec3<T> */
    /* ctor vec3<T : scalar>(T) -> vec3<T> */
    /* ctor vec3<T : scalar>(x: T, y: T, z: T) -> vec3<T> */
    /* ctor vec3<T : scalar>(xy: vec2<T>, z: T) -> vec3<T> */
    /* ctor vec3<T : scalar>(x: T, yz: vec2<T>) -> vec3<T> */
    /* conv vec3<T : f32, U : scalar_no_f32>(vec3<U>) -> vec3<f32> */
    /* conv vec3<T : f16, U : scalar_no_f16>(vec3<U>) -> vec3<f16> */
    /* conv vec3<T : i32, U : scalar_no_i32>(vec3<U>) -> vec3<i32> */
    /* conv vec3<T : u32, U : scalar_no_u32>(vec3<U>) -> vec3<u32> */
    /* conv vec3<T : bool, U : scalar_no_bool>(vec3<U>) -> vec3<bool> */
    /* num overloads */ 11,
    /* overloads */ &kOverloads[95],
  },
  {
    /* [7] */
    /* ctor vec4<T : concrete_scalar>() -> vec4<T> */
    /* ctor vec4<T : scalar>(vec4<T>) -> vec4<T> */
    /* ctor vec4<T : scalar>(T) -> vec4<T> */
    /* ctor vec4<T : scalar>(x: T, y: T, z: T, w: T) -> vec4<T> */
    /* ctor vec4<T : scalar>(xy: vec2<T>, z: T, w: T) -> vec4<T> */
    /* ctor vec4<T : scalar>(x: T, yz: vec2<T>, w: T) -> vec4<T> */
    /* ctor vec4<T : scalar>(x: T, y: T, zw: vec2<T>) -> vec4<T> */
    /* ctor vec4<T : scalar>(xy: vec2<T>, zw: vec2<T>) -> vec4<T> */
    /* ctor vec4<T : scalar>(xyz: vec3<T>, w: T) -> vec4<T> */
    /* ctor vec4<T : scalar>(x: T, zyw: vec3<T>) -> vec4<T> */
    /* conv vec4<T : f32, U : scalar_no_f32>(vec4<U>) -> vec4<f32> */
    /* conv vec4<T : f16, U : scalar_no_f16>(vec4<U>) -> vec4<f16> */
    /* conv vec4<T : i32, U : scalar_no_i32>(vec4<U>) -> vec4<i32> */
    /* conv vec4<T : u32, U : scalar_no_u32>(vec4<U>) -> vec4<u32> */
    /* conv vec4<T : bool, U : scalar_no_bool>(vec4<U>) -> vec4<bool> */
    /* num overloads */ 15,
    /* overloads */ &kOverloads[42],
  },
  {
    /* [8] */
    /* ctor mat2x2<T : f32_f16>() -> mat2x2<T> */
    /* ctor mat2x2<T : f32_f16>(mat2x2<T>) -> mat2x2<T> */
    /* ctor mat2x2<T : fa_f32_f16>(T, T, T, T) -> mat2x2<T> */
    /* ctor mat2x2<T : fa_f32_f16>(vec2<T>, vec2<T>) -> mat2x2<T> */
    /* conv mat2x2<T : f16>(mat2x2<f32>) -> mat2x2<f16> */
    /* conv mat2x2<T : f32>(mat2x2<f16>) -> mat2x2<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[177],
  },
  {
    /* [9] */
    /* ctor mat2x3<T : f32_f16>() -> mat2x3<T> */
    /* ctor mat2x3<T : f32_f16>(mat2x3<T>) -> mat2x3<T> */
    /* ctor mat2x3<T : fa_f32_f16>(T, T, T, T, T, T) -> mat2x3<T> */
    /* ctor mat2x3<T : fa_f32_f16>(vec3<T>, vec3<T>) -> mat2x3<T> */
    /* conv mat2x3<T : f16>(mat2x3<f32>) -> mat2x3<f16> */
    /* conv mat2x3<T : f32>(mat2x3<f16>) -> mat2x3<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[183],
  },
  {
    /* [10] */
    /* ctor mat2x4<T : f32_f16>() -> mat2x4<T> */
    /* ctor mat2x4<T : f32_f16>(mat2x4<T>) -> mat2x4<T> */
    /* ctor mat2x4<T : fa_f32_f16>(T, T, T, T, T, T, T, T) -> mat2x4<T> */
    /* ctor mat2x4<T : fa_f32_f16>(vec4<T>, vec4<T>) -> mat2x4<T> */
    /* conv mat2x4<T : f16>(mat2x4<f32>) -> mat2x4<f16> */
    /* conv mat2x4<T : f32>(mat2x4<f16>) -> mat2x4<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[189],
  },
  {
    /* [11] */
    /* ctor mat3x2<T : f32_f16>() -> mat3x2<T> */
    /* ctor mat3x2<T : f32_f16>(mat3x2<T>) -> mat3x2<T> */
    /* ctor mat3x2<T : fa_f32_f16>(T, T, T, T, T, T) -> mat3x2<T> */
    /* ctor mat3x2<T : fa_f32_f16>(vec2<T>, vec2<T>, vec2<T>) -> mat3x2<T> */
    /* conv mat3x2<T : f16>(mat3x2<f32>) -> mat3x2<f16> */
    /* conv mat3x2<T : f32>(mat3x2<f16>) -> mat3x2<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[195],
  },
  {
    /* [12] */
    /* ctor mat3x3<T : f32_f16>() -> mat3x3<T> */
    /* ctor mat3x3<T : f32_f16>(mat3x3<T>) -> mat3x3<T> */
    /* ctor mat3x3<T : fa_f32_f16>(T, T, T, T, T, T, T, T, T) -> mat3x3<T> */
    /* ctor mat3x3<T : fa_f32_f16>(vec3<T>, vec3<T>, vec3<T>) -> mat3x3<T> */
    /* conv mat3x3<T : f16>(mat3x3<f32>) -> mat3x3<f16> */
    /* conv mat3x3<T : f32>(mat3x3<f16>) -> mat3x3<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[201],
  },
  {
    /* [13] */
    /* ctor mat3x4<T : f32_f16>() -> mat3x4<T> */
    /* ctor mat3x4<T : f32_f16>(mat3x4<T>) -> mat3x4<T> */
    /* ctor mat3x4<T : fa_f32_f16>(T, T, T, T, T, T, T, T, T, T, T, T) -> mat3x4<T> */
    /* ctor mat3x4<T : fa_f32_f16>(vec4<T>, vec4<T>, vec4<T>) -> mat3x4<T> */
    /* conv mat3x4<T : f16>(mat3x4<f32>) -> mat3x4<f16> */
    /* conv mat3x4<T : f32>(mat3x4<f16>) -> mat3x4<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[207],
  },
  {
    /* [14] */
    /* ctor mat4x2<T : f32_f16>() -> mat4x2<T> */
    /* ctor mat4x2<T : f32_f16>(mat4x2<T>) -> mat4x2<T> */
    /* ctor mat4x2<T : fa_f32_f16>(T, T, T, T, T, T, T, T) -> mat4x2<T> */
    /* ctor mat4x2<T : fa_f32_f16>(vec2<T>, vec2<T>, vec2<T>, vec2<T>) -> mat4x2<T> */
    /* conv mat4x2<T : f16>(mat4x2<f32>) -> mat4x2<f16> */
    /* conv mat4x2<T : f32>(mat4x2<f16>) -> mat4x2<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[213],
  },
  {
    /* [15] */
    /* ctor mat4x3<T : f32_f16>() -> mat4x3<T> */
    /* ctor mat4x3<T : f32_f16>(mat4x3<T>) -> mat4x3<T> */
    /* ctor mat4x3<T : fa_f32_f16>(T, T, T, T, T, T, T, T, T, T, T, T) -> mat4x3<T> */
    /* ctor mat4x3<T : fa_f32_f16>(vec3<T>, vec3<T>, vec3<T>, vec3<T>) -> mat4x3<T> */
    /* conv mat4x3<T : f16>(mat4x3<f32>) -> mat4x3<f16> */
    /* conv mat4x3<T : f32>(mat4x3<f16>) -> mat4x3<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[219],
  },
  {
    /* [16] */
    /* ctor mat4x4<T : f32_f16>() -> mat4x4<T> */
    /* ctor mat4x4<T : f32_f16>(mat4x4<T>) -> mat4x4<T> */
    /* ctor mat4x4<T : fa_f32_f16>(T, T, T, T, T, T, T, T, T, T, T, T, T, T, T, T) -> mat4x4<T> */
    /* ctor mat4x4<T : fa_f32_f16>(vec4<T>, vec4<T>, vec4<T>, vec4<T>) -> mat4x4<T> */
    /* conv mat4x4<T : f16>(mat4x4<f32>) -> mat4x4<f16> */
    /* conv mat4x4<T : f32>(mat4x4<f16>) -> mat4x4<f32> */
    /* num overloads */ 6,
    /* overloads */ &kOverloads[225],
  },
};

// clang-format on
