// Copyright 2021 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/resolver/ctor_conv_intrinsic.h.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#ifndef SRC_TINT_RESOLVER_CTOR_CONV_INTRINSIC_H_
#define SRC_TINT_RESOLVER_CTOR_CONV_INTRINSIC_H_

#include <cstdint>

namespace tint::resolver {

/// CtorConvIntrinsic is an enumerator of types that have a constructor or converter overload
/// declared in the intrinsic table.
enum class CtorConvIntrinsic {
    kNone = -1,
    kI32,
    kU32,
    kF32,
    kF16,
    kBool,
    kVec2,
    kVec3,
    kVec4,
    kMat2x2,
    kMat2x3,
    kMat2x4,
    kMat3x2,
    kMat3x3,
    kMat3x4,
    kMat4x2,
    kMat4x3,
    kMat4x4,
};

/// @returns the name of the type.
const char* str(CtorConvIntrinsic i);

/// @param n the width of the vector
/// @return the CtorConvIntrinsic for a vector of width `n`
inline CtorConvIntrinsic VectorCtorConvIntrinsic(uint32_t n) {
    switch (n) {
        case 2:
            return CtorConvIntrinsic::kVec2;
        case 3:
            return CtorConvIntrinsic::kVec3;
        case 4:
            return CtorConvIntrinsic::kVec4;
    }
    return CtorConvIntrinsic::kNone;
}

/// @param c the number of columns in the matrix
/// @param r the number of rows in the matrix
/// @return the CtorConvIntrinsic for a matrix with `c` columns and `r` rows
inline CtorConvIntrinsic MatrixCtorConvIntrinsic(uint32_t c, uint32_t r) {
    switch ((c - 2) * 3 + (r - 2)) {
        case 0:
            return CtorConvIntrinsic::kMat2x2;
        case 1:
            return CtorConvIntrinsic::kMat2x3;
        case 2:
            return CtorConvIntrinsic::kMat2x4;
        case 3:
            return CtorConvIntrinsic::kMat3x2;
        case 4:
            return CtorConvIntrinsic::kMat3x3;
        case 5:
            return CtorConvIntrinsic::kMat3x4;
        case 6:
            return CtorConvIntrinsic::kMat4x2;
        case 7:
            return CtorConvIntrinsic::kMat4x3;
        case 8:
            return CtorConvIntrinsic::kMat4x4;
    }
    return CtorConvIntrinsic::kNone;
}

}  // namespace tint::resolver

#endif  // SRC_TINT_RESOLVER_CTOR_CONV_INTRINSIC_H_
