// Copyright 2022 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/texel_format_bench.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/texel_format.h"

#include <array>

#include "benchmark/benchmark.h"

namespace tint::builtin {
namespace {

void TexelFormatParser(::benchmark::State& state) {
    const char* kStrings[] = {
        "bgraunccrm",     "blranr3",      "bVra8unorm",   "bgra8unorm",   "bgra1unorm",
        "bgrJqqnorm",     "bgr7ll8unorm", "qq32lppHat",   "c2fov",        "r32Goat",
        "r32float",       "r3viiloat",    "r3WWflo8t",    "rxxfMoat",     "rXsingg",
        "3siXt",          "r32s3nt",      "r32sint",      "E32sint",      "rPTTsint",
        "r32sidxx",       "r442uint",     "r3SSuiVVt",    "R32R22t",      "r32uint",
        "rFui9t",         "r32int",       "VOORRHnt",     "rgy2foat",     "l77nnrr2floGt",
        "rg42fl00at",     "rg32float",    "rgoofat",      "rgzzflot",     "g11p2fliia",
        "XXg32sint",      "rII39955nnnt", "aagHH2sinYSS", "rg32sint",     "rkk3it",
        "gj3sRRn",        "r3bsnt",       "rg32jint",     "rg32unt",      "rgqint",
        "rg32uint",       "rg32inNN",     "g3vvint",      "rg2uQQnt",     "rga16floft",
        "rgja16float",    "rgNNww16f2oa", "rgba16float",  "rgba16flot",   "rgba16rrloat",
        "rgGa16float",    "rgba16sFFnt",  "g16sEnt",      "rgb16rrint",   "rgba16sint",
        "gba16sit",       "rXa1DsiJJt",   "rgasint",      "rg111kin",     "rgb16uint",
        "rgJa16uit",      "rgba16uint",   "rgca16uint",   "rgba16Oint",   "KKgba__v6uintt",
        "rgb832fxx5t",    "rgbaqq__lat",  "rgba32qloat",  "rgba32float",  "33gbO2floa66",
        "rgboott6QQloat", "66ba32float",  "xba32zzinO6",  "ryyba32sint",  "rbZ32HinZ",
        "rgba32sint",     "rgba3s4WWnq",  "rgba32sOOt",   "oogba2Yin",    "ga32unt",
        "Fga32uint",      "rgb32uinw",    "rgba32uint",   "rgGf32uit",    "rgbaqKKuint",
        "rFba32ummnt",    "rgba8snt",     "rgq8sint",     "rbbba8bin",    "rgba8sint",
        "rgbisint",       "rgq8sinOO",    "rgbaTTvvint",  "rgFFa8snorm",  "rg00QsnPrm",
        "rgbaPsnorm",     "rgba8snorm",   "rgb77ssnorm",  "rgba8snbbRRC", "rgbXX8snorm",
        "qgCCOO8iOOt",    "rsauuinL",     "rgXa8uint",    "rgba8uint",    "rgba8int",
        "rgbunqq",        "rg22a8uint",   "rybXX0nzzrm",  "rgVVa8iorP",   "rbaCunnnrm",
        "rgba8unorm",     "ba8unoqqHHA",  "rga8unorm",    "rgfa8uKKo",
    };
    for (auto _ : state) {
        for (auto* str : kStrings) {
            auto result = ParseTexelFormat(str);
            benchmark::DoNotOptimize(result);
        }
    }
}

BENCHMARK(TexelFormatParser);

}  // namespace
}  // namespace tint::builtin
