// Copyright 2022 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/texel_format.h.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#ifndef SRC_TINT_BUILTIN_TEXEL_FORMAT_H_
#define SRC_TINT_BUILTIN_TEXEL_FORMAT_H_

#include <ostream>

namespace tint::builtin {

/// Enumerator of texel formats
enum class TexelFormat {
    kUndefined,
    kBgra8Unorm,
    kR32Float,
    kR32Sint,
    kR32Uint,
    kRg32Float,
    kRg32Sint,
    kRg32Uint,
    kRgba16Float,
    kRgba16Sint,
    kRgba16Uint,
    kRgba32Float,
    kRgba32Sint,
    kRgba32Uint,
    kRgba8Sint,
    kRgba8Snorm,
    kRgba8Uint,
    kRgba8Unorm,
};

/// @param out the std::ostream to write to
/// @param value the TexelFormat
/// @returns `out` so calls can be chained
std::ostream& operator<<(std::ostream& out, TexelFormat value);

/// ParseTexelFormat parses a TexelFormat from a string.
/// @param str the string to parse
/// @returns the parsed enum, or TexelFormat::kUndefined if the string could not be parsed.
TexelFormat ParseTexelFormat(std::string_view str);

constexpr const char* kTexelFormatStrings[] = {
    "bgra8unorm", "r32float",    "r32sint",    "r32uint",    "rg32float",   "rg32sint",
    "rg32uint",   "rgba16float", "rgba16sint", "rgba16uint", "rgba32float", "rgba32sint",
    "rgba32uint", "rgba8sint",   "rgba8snorm", "rgba8uint",  "rgba8unorm",
};

}  // namespace tint::builtin

#endif  // SRC_TINT_BUILTIN_TEXEL_FORMAT_H_
