// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/interpolation_type_test.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/interpolation_type.h"

#include <gtest/gtest.h>
#include <string>

#include "src/tint/utils/string.h"

namespace tint::builtin {
namespace {

namespace interpolation_type_tests {

namespace parse_print_tests {

struct Case {
    const char* string;
    InterpolationType value;
};

inline std::ostream& operator<<(std::ostream& out, Case c) {
    return out << "'" << std::string(c.string) << "'";
}

static constexpr Case kValidCases[] = {
    {"flat", InterpolationType::kFlat},
    {"linear", InterpolationType::kLinear},
    {"perspective", InterpolationType::kPerspective},
};

static constexpr Case kInvalidCases[] = {
    {"ccat", InterpolationType::kUndefined},          {"3", InterpolationType::kUndefined},
    {"fVat", InterpolationType::kUndefined},          {"1inear", InterpolationType::kUndefined},
    {"lnqqar", InterpolationType::kUndefined},        {"linell77", InterpolationType::kUndefined},
    {"perppHqective", InterpolationType::kUndefined}, {"cespctve", InterpolationType::kUndefined},
    {"ebGpective", InterpolationType::kUndefined},
};

using InterpolationTypeParseTest = testing::TestWithParam<Case>;

TEST_P(InterpolationTypeParseTest, Parse) {
    const char* string = GetParam().string;
    InterpolationType expect = GetParam().value;
    EXPECT_EQ(expect, ParseInterpolationType(string));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, InterpolationTypeParseTest, testing::ValuesIn(kValidCases));
INSTANTIATE_TEST_SUITE_P(InvalidCases,
                         InterpolationTypeParseTest,
                         testing::ValuesIn(kInvalidCases));

using InterpolationTypePrintTest = testing::TestWithParam<Case>;

TEST_P(InterpolationTypePrintTest, Print) {
    InterpolationType value = GetParam().value;
    const char* expect = GetParam().string;
    EXPECT_EQ(expect, utils::ToString(value));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, InterpolationTypePrintTest, testing::ValuesIn(kValidCases));

}  // namespace parse_print_tests

}  // namespace interpolation_type_tests

}  // namespace
}  // namespace tint::builtin
