// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/interpolation_type_bench.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/interpolation_type.h"

#include <array>

#include "benchmark/benchmark.h"

namespace tint::builtin {
namespace {

void InterpolationTypeParser(::benchmark::State& state) {
    const char* kStrings[] = {
        "ccat",         "3",           "fVat",        "flat",        "1lat",
        "fqaJ",         "flla77",      "lippeHHr",    "cin",         "lbGea",
        "linear",       "liveaii",     "liWWe8r",     "xxiner",      "perggpctXve",
        "ueVspXtve",    "3erspective", "perspective", "perspectivE", "peTTspectiPe",
        "pxxdrspectve",
    };
    for (auto _ : state) {
        for (auto* str : kStrings) {
            auto result = ParseInterpolationType(str);
            benchmark::DoNotOptimize(result);
        }
    }
}

BENCHMARK(InterpolationTypeParser);

}  // namespace
}  // namespace tint::builtin
