// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/interpolation_type.h.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#ifndef SRC_TINT_BUILTIN_INTERPOLATION_TYPE_H_
#define SRC_TINT_BUILTIN_INTERPOLATION_TYPE_H_

#include <ostream>
#include <string>

namespace tint::builtin {

/// The interpolation type.
enum class InterpolationType {
    kUndefined,
    kFlat,
    kLinear,
    kPerspective,
};

/// @param out the std::ostream to write to
/// @param value the InterpolationType
/// @returns `out` so calls can be chained
std::ostream& operator<<(std::ostream& out, InterpolationType value);

/// ParseInterpolationType parses a InterpolationType from a string.
/// @param str the string to parse
/// @returns the parsed enum, or InterpolationType::kUndefined if the string could not be parsed.
InterpolationType ParseInterpolationType(std::string_view str);

constexpr const char* kInterpolationTypeStrings[] = {
    "flat",
    "linear",
    "perspective",
};

}  // namespace tint::builtin

#endif  // SRC_TINT_BUILTIN_INTERPOLATION_TYPE_H_
