// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/interpolation_sampling_bench.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include <array>

#include "benchmark/benchmark.h"
#include "src/tint/builtin/interpolation_sampling.h"

namespace tint::builtin {
namespace {

void InterpolationSamplingParser(::benchmark::State& state) {
    const char* kStrings[] = {
        "ccnter",     "c3r",   "centeV",  "center",   "1enter",    "cnqqer",    "centll77",
        "qqenrppHid", "cntov", "cenGoid", "centroid", "ceviiroid", "ceWWtro8d", "cxxtMoid",
        "saXggl",     "Xmle",  "sam3le",  "sample",   "sEmple",    "amTTlPP",   "ddamxxl",
    };
    for (auto _ : state) {
        for (auto* str : kStrings) {
            auto result = ParseInterpolationSampling(str);
            benchmark::DoNotOptimize(result);
        }
    }
}

BENCHMARK(InterpolationSamplingParser);

}  // namespace
}  // namespace tint::builtin
