// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/interpolation_sampling.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/interpolation_sampling.h"

#include <string>

namespace tint::builtin {

/// ParseInterpolationSampling parses a InterpolationSampling from a string.
/// @param str the string to parse
/// @returns the parsed enum, or InterpolationSampling::kUndefined if the string could not be
/// parsed.
InterpolationSampling ParseInterpolationSampling(std::string_view str) {
    if (str == "center") {
        return InterpolationSampling::kCenter;
    }
    if (str == "centroid") {
        return InterpolationSampling::kCentroid;
    }
    if (str == "sample") {
        return InterpolationSampling::kSample;
    }
    return InterpolationSampling::kUndefined;
}

std::ostream& operator<<(std::ostream& out, InterpolationSampling value) {
    switch (value) {
        case InterpolationSampling::kUndefined:
            return out << "undefined";
        case InterpolationSampling::kCenter:
            return out << "center";
        case InterpolationSampling::kCentroid:
            return out << "centroid";
        case InterpolationSampling::kSample:
            return out << "sample";
    }
    return out << "<unknown>";
}

}  // namespace tint::builtin
