// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/diagnostic_severity_test.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include <string>

#include "gtest/gtest-spi.h"
#include "src/tint/builtin/diagnostic_severity.h"
#include "src/tint/utils/string.h"

namespace tint::builtin {
namespace {

namespace diagnostic_severity_tests {

namespace parse_print_tests {

struct Case {
    const char* string;
    DiagnosticSeverity value;
};

inline std::ostream& operator<<(std::ostream& out, Case c) {
    return out << "'" << std::string(c.string) << "'";
}

static constexpr Case kValidCases[] = {
    {"error", DiagnosticSeverity::kError},
    {"info", DiagnosticSeverity::kInfo},
    {"off", DiagnosticSeverity::kOff},
    {"warning", DiagnosticSeverity::kWarning},
};

static constexpr Case kInvalidCases[] = {
    {"erccr", DiagnosticSeverity::kUndefined},    {"3o", DiagnosticSeverity::kUndefined},
    {"eVror", DiagnosticSeverity::kUndefined},    {"1nfo", DiagnosticSeverity::kUndefined},
    {"iqfJ", DiagnosticSeverity::kUndefined},     {"illf77", DiagnosticSeverity::kUndefined},
    {"oppqH", DiagnosticSeverity::kUndefined},    {"", DiagnosticSeverity::kUndefined},
    {"Gb", DiagnosticSeverity::kUndefined},       {"warniivg", DiagnosticSeverity::kUndefined},
    {"8WWrning", DiagnosticSeverity::kUndefined}, {"wxxning", DiagnosticSeverity::kUndefined},
};

using DiagnosticSeverityParseTest = testing::TestWithParam<Case>;

TEST_P(DiagnosticSeverityParseTest, Parse) {
    const char* string = GetParam().string;
    DiagnosticSeverity expect = GetParam().value;
    EXPECT_EQ(expect, ParseDiagnosticSeverity(string));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, DiagnosticSeverityParseTest, testing::ValuesIn(kValidCases));
INSTANTIATE_TEST_SUITE_P(InvalidCases,
                         DiagnosticSeverityParseTest,
                         testing::ValuesIn(kInvalidCases));

using DiagnosticSeverityPrintTest = testing::TestWithParam<Case>;

TEST_P(DiagnosticSeverityPrintTest, Print) {
    DiagnosticSeverity value = GetParam().value;
    const char* expect = GetParam().string;
    EXPECT_EQ(expect, utils::ToString(value));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, DiagnosticSeverityPrintTest, testing::ValuesIn(kValidCases));

}  // namespace parse_print_tests

}  // namespace diagnostic_severity_tests

}  // namespace
}  // namespace tint::builtin
