// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/diagnostic_severity.h.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#ifndef SRC_TINT_BUILTIN_DIAGNOSTIC_SEVERITY_H_
#define SRC_TINT_BUILTIN_DIAGNOSTIC_SEVERITY_H_

#include <ostream>
#include <string>
#include <unordered_map>

#include "src/tint/builtin/diagnostic_rule.h"
#include "src/tint/diagnostic/diagnostic.h"

namespace tint::builtin {

/// The diagnostic severity control.
enum class DiagnosticSeverity {
    kUndefined,
    kError,
    kInfo,
    kOff,
    kWarning,
};

/// @param out the std::ostream to write to
/// @param value the DiagnosticSeverity
/// @returns `out` so calls can be chained
std::ostream& operator<<(std::ostream& out, DiagnosticSeverity value);

/// ParseDiagnosticSeverity parses a DiagnosticSeverity from a string.
/// @param str the string to parse
/// @returns the parsed enum, or DiagnosticSeverity::kUndefined if the string could not be parsed.
DiagnosticSeverity ParseDiagnosticSeverity(std::string_view str);

constexpr const char* kDiagnosticSeverityStrings[] = {
    "error",
    "info",
    "off",
    "warning",
};

/// Convert a DiagnosticSeverity to the corresponding diag::Severity.
diag::Severity ToSeverity(DiagnosticSeverity sc);

/// DiagnosticRuleSeverities is a map from diagnostic rule to diagnostic severity.
using DiagnosticRuleSeverities = std::unordered_map<DiagnosticRule, DiagnosticSeverity>;

}  // namespace tint::builtin

#endif  // SRC_TINT_BUILTIN_DIAGNOSTIC_SEVERITY_H_
