// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/diagnostic_rule_test.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include <string>

#include "gtest/gtest-spi.h"
#include "src/tint/builtin/diagnostic_rule.h"
#include "src/tint/utils/string.h"

namespace tint::builtin {
namespace {

namespace diagnostic_rule_tests {

namespace parse_print_tests {

struct Case {
    const char* string;
    DiagnosticRule value;
};

inline std::ostream& operator<<(std::ostream& out, Case c) {
    return out << "'" << std::string(c.string) << "'";
}

static constexpr Case kValidCases[] = {
    {"chromium_unreachable_code", DiagnosticRule::kChromiumUnreachableCode},
    {"derivative_uniformity", DiagnosticRule::kDerivativeUniformity},
};

static constexpr Case kInvalidCases[] = {
    {"chromium_unrachaccle_code", DiagnosticRule::kUndefined},
    {"clromium_unreachab3_oe", DiagnosticRule::kUndefined},
    {"chromium_unreachable_Vode", DiagnosticRule::kUndefined},
    {"derivative_uniform1ty", DiagnosticRule::kUndefined},
    {"derivativeJunifqrmity", DiagnosticRule::kUndefined},
    {"derivative_unifllrmit77", DiagnosticRule::kUndefined},
};

using DiagnosticRuleParseTest = testing::TestWithParam<Case>;

TEST_P(DiagnosticRuleParseTest, Parse) {
    const char* string = GetParam().string;
    DiagnosticRule expect = GetParam().value;
    EXPECT_EQ(expect, ParseDiagnosticRule(string));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, DiagnosticRuleParseTest, testing::ValuesIn(kValidCases));
INSTANTIATE_TEST_SUITE_P(InvalidCases, DiagnosticRuleParseTest, testing::ValuesIn(kInvalidCases));

using DiagnosticRulePrintTest = testing::TestWithParam<Case>;

TEST_P(DiagnosticRulePrintTest, Print) {
    DiagnosticRule value = GetParam().value;
    const char* expect = GetParam().string;
    EXPECT_EQ(expect, utils::ToString(value));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, DiagnosticRulePrintTest, testing::ValuesIn(kValidCases));

}  // namespace parse_print_tests

}  // namespace diagnostic_rule_tests

}  // namespace
}  // namespace tint::builtin
