// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/diagnostic_rule_bench.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/diagnostic_rule.h"

#include <array>

#include "benchmark/benchmark.h"

namespace tint::builtin {
namespace {

void DiagnosticRuleParser(::benchmark::State& state) {
    const char* kStrings[] = {
        "chromium_unrachaccle_code",   "clromium_unreachab3_oe",    "chromium_unreachable_Vode",
        "chromium_unreachable_code",   "chro1ium_unreachable_code", "chromium_unreJchableqqcde",
        "chromium77unreallhable_code", "dqqrvatiHHe_uniforppity",   "deriatcv_nvformity",
        "derivatbe_unGformity",        "derivative_uniformity",     "derivative_iinifvrmity",
        "derivat8WWe_uniformity",      "drivaxxive_uniformity",
    };
    for (auto _ : state) {
        for (auto* str : kStrings) {
            auto result = ParseDiagnosticRule(str);
            benchmark::DoNotOptimize(result);
        }
    }
}

BENCHMARK(DiagnosticRuleParser);

}  // namespace
}  // namespace tint::builtin
