// Copyright 2023 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/diagnostic_rule.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/diagnostic_rule.h"

#include <ostream>
#include <string>

namespace tint::builtin {

/// ParseDiagnosticRule parses a DiagnosticRule from a string.
/// @param str the string to parse
/// @returns the parsed enum, or DiagnosticRule::kUndefined if the string could not be parsed.
DiagnosticRule ParseDiagnosticRule(std::string_view str) {
    if (str == "chromium_unreachable_code") {
        return DiagnosticRule::kChromiumUnreachableCode;
    }
    if (str == "derivative_uniformity") {
        return DiagnosticRule::kDerivativeUniformity;
    }
    return DiagnosticRule::kUndefined;
}

std::ostream& operator<<(std::ostream& out, DiagnosticRule value) {
    switch (value) {
        case DiagnosticRule::kUndefined:
            return out << "undefined";
        case DiagnosticRule::kChromiumUnreachableCode:
            return out << "chromium_unreachable_code";
        case DiagnosticRule::kDerivativeUniformity:
            return out << "derivative_uniformity";
    }
    return out << "<unknown>";
}

}  // namespace tint::builtin
