// Copyright 2022 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/builtin_value_test.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/builtin_value.h"

#include <gtest/gtest.h>

#include <string>

#include "src/tint/utils/string.h"

namespace tint::builtin {
namespace {

namespace parse_print_tests {

struct Case {
    const char* string;
    BuiltinValue value;
};

inline std::ostream& operator<<(std::ostream& out, Case c) {
    return out << "'" << std::string(c.string) << "'";
}

static constexpr Case kValidCases[] = {
    {"__point_size", BuiltinValue::kPointSize},
    {"frag_depth", BuiltinValue::kFragDepth},
    {"front_facing", BuiltinValue::kFrontFacing},
    {"global_invocation_id", BuiltinValue::kGlobalInvocationId},
    {"instance_index", BuiltinValue::kInstanceIndex},
    {"local_invocation_id", BuiltinValue::kLocalInvocationId},
    {"local_invocation_index", BuiltinValue::kLocalInvocationIndex},
    {"num_workgroups", BuiltinValue::kNumWorkgroups},
    {"position", BuiltinValue::kPosition},
    {"sample_index", BuiltinValue::kSampleIndex},
    {"sample_mask", BuiltinValue::kSampleMask},
    {"vertex_index", BuiltinValue::kVertexIndex},
    {"workgroup_id", BuiltinValue::kWorkgroupId},
};

static constexpr Case kInvalidCases[] = {
    {"_ccpoint_siz", BuiltinValue::kUndefined},
    {"_3poi_ile", BuiltinValue::kUndefined},
    {"__poiVt_size", BuiltinValue::kUndefined},
    {"frag1depth", BuiltinValue::kUndefined},
    {"fraJqqepth", BuiltinValue::kUndefined},
    {"fra7ll_depth", BuiltinValue::kUndefined},
    {"fonHHpp_facing", BuiltinValue::kUndefined},
    {"fron_facg", BuiltinValue::kUndefined},
    {"frGnt_fbcin", BuiltinValue::kUndefined},
    {"glvbal_iinvocation_id", BuiltinValue::kUndefined},
    {"gl8bal_invocation_WWd", BuiltinValue::kUndefined},
    {"Mlobal_invocaton_xxd", BuiltinValue::kUndefined},
    {"isXance_indegg", BuiltinValue::kUndefined},
    {"insanc_iXVex", BuiltinValue::kUndefined},
    {"instance_in3ex", BuiltinValue::kUndefined},
    {"local_Envocation_id", BuiltinValue::kUndefined},
    {"localiPPvocatioTT_id", BuiltinValue::kUndefined},
    {"localxxnvocationddid", BuiltinValue::kUndefined},
    {"loca44_invocation_index", BuiltinValue::kUndefined},
    {"local_invocSStionVVindex", BuiltinValue::kUndefined},
    {"locRR_invocat22n_index", BuiltinValue::kUndefined},
    {"nuF_workrou9s", BuiltinValue::kUndefined},
    {"numworkgroups", BuiltinValue::kUndefined},
    {"nuRRworVgOOHups", BuiltinValue::kUndefined},
    {"posytio", BuiltinValue::kUndefined},
    {"77orritllnon", BuiltinValue::kUndefined},
    {"04osition", BuiltinValue::kUndefined},
    {"smpe_oonde", BuiltinValue::kUndefined},
    {"smpl_inzzex", BuiltinValue::kUndefined},
    {"saiip11eindep", BuiltinValue::kUndefined},
    {"sample_XXask", BuiltinValue::kUndefined},
    {"samII99l55_mask", BuiltinValue::kUndefined},
    {"samaale_SSrHHYk", BuiltinValue::kUndefined},
    {"verkkeH_de", BuiltinValue::kUndefined},
    {"verRg_injex", BuiltinValue::kUndefined},
    {"vrtexinbex", BuiltinValue::kUndefined},
    {"workjroup_id", BuiltinValue::kUndefined},
    {"wrkgroup_id", BuiltinValue::kUndefined},
    {"qorkgro_id", BuiltinValue::kUndefined},
};

using BuiltinValueParseTest = testing::TestWithParam<Case>;

TEST_P(BuiltinValueParseTest, Parse) {
    const char* string = GetParam().string;
    BuiltinValue expect = GetParam().value;
    EXPECT_EQ(expect, ParseBuiltinValue(string));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, BuiltinValueParseTest, testing::ValuesIn(kValidCases));
INSTANTIATE_TEST_SUITE_P(InvalidCases, BuiltinValueParseTest, testing::ValuesIn(kInvalidCases));

using BuiltinValuePrintTest = testing::TestWithParam<Case>;

TEST_P(BuiltinValuePrintTest, Print) {
    BuiltinValue value = GetParam().value;
    const char* expect = GetParam().string;
    EXPECT_EQ(expect, utils::ToString(value));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, BuiltinValuePrintTest, testing::ValuesIn(kValidCases));

}  // namespace parse_print_tests

}  // namespace
}  // namespace tint::builtin
