// Copyright 2022 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/builtin_value_bench.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/builtin_value.h"

#include <array>

#include "benchmark/benchmark.h"

namespace tint::builtin {
namespace {

void BuiltinValueParser(::benchmark::State& state) {
    const char* kStrings[] = {
        "_ccpoint_siz",
        "_3poi_ile",
        "__poiVt_size",
        "__point_size",
        "1_point_size",
        "__pointJsqze",
        "__lloint_siz77",
        "frqqgppepHHh",
        "fv_dcpt",
        "frabGdeth",
        "frag_depth",
        "frag_veiith",
        "fr8g_depWWh",
        "Mragxxepth",
        "ggroXtfacing",
        "Vot_fuciXg",
        "front_fac3ng",
        "front_facing",
        "front_fEcing",
        "fronPPfaTTing",
        "ddroxxtfacing",
        "global_invocatio44_id",
        "global_invocaSSioVV_id",
        "22loRal_invoRtion_id",
        "global_invocation_id",
        "globalFinvoction_id",
        "gloal_invocation_id",
        "RRlHOOaV_invoction_id",
        "instance_ydex",
        "instGlr77cnn_index",
        "instan04e_index",
        "instance_index",
        "insacoo_inex",
        "izstane_index",
        "nippance_in11ex",
        "local_invXXcation_id",
        "lIIcal_i5599ocation_inn",
        "HHrrcal_inSSocation_Yaa",
        "local_invocation_id",
        "lokkal_invocatini",
        "jocal_invocRRongid",
        "local_inocatbon_i",
        "local_injocation_index",
        "local_invocatio_index",
        "locl_invocqtion_ndex",
        "local_invocation_index",
        "localNNinvocaton_index",
        "local_invocatin_ivvdx",
        "locl_invocatioQQ_index",
        "num_workgffus",
        "num_workgroujs",
        "num_wrkgNNwoup8",
        "num_workgroups",
        "numworkgroups",
        "num_workrrroups",
        "num_worGgroups",
        "pFFsition",
        "pEiio",
        "prrsitio",
        "position",
        "sition",
        "poJJDtin",
        "poi8i",
        "smpke11nde",
        "samle_index",
        "saple_Jndex",
        "sample_index",
        "cample_index",
        "sample_indOx",
        "savvKKl___inttex",
        "sam8le_xx5k",
        "sampqq__msk",
        "sampleqmask",
        "sample_mask",
        "33amOe_mas66",
        "samoott6QQmask",
        "66mple_mask",
        "verzzx_in6Oxx",
        "vertex_yyndex",
        "vetxHHZnZex",
        "vertex_index",
        "vWWteq_in44ex",
        "vrtex_OOndex",
        "hrteYooindx",
        "wogroup_i",
        "wokgrouF_id",
        "worgrwup_id",
        "workgroup_id",
        "workGKou_if",
        "worKKgrouq_id",
        "w3rkgrommp_id",
    };
    for (auto _ : state) {
        for (auto* str : kStrings) {
            auto result = ParseBuiltinValue(str);
            benchmark::DoNotOptimize(result);
        }
    }
}

BENCHMARK(BuiltinValueParser);

}  // namespace
}  // namespace tint::builtin
