// Copyright 2022 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/address_space_test.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/address_space.h"

#include <gtest/gtest.h>

#include <string>

#include "src/tint/utils/string.h"

namespace tint::builtin {
namespace {

namespace parse_print_tests {

struct Case {
    const char* string;
    AddressSpace value;
};

inline std::ostream& operator<<(std::ostream& out, Case c) {
    return out << "'" << std::string(c.string) << "'";
}

static constexpr Case kValidCases[] = {
    {"__in", AddressSpace::kIn},
    {"__out", AddressSpace::kOut},
    {"function", AddressSpace::kFunction},
    {"private", AddressSpace::kPrivate},
    {"push_constant", AddressSpace::kPushConstant},
    {"storage", AddressSpace::kStorage},
    {"uniform", AddressSpace::kUniform},
    {"workgroup", AddressSpace::kWorkgroup},
};

static constexpr Case kInvalidCases[] = {
    {"ccin", AddressSpace::kUndefined},          {"3", AddressSpace::kUndefined},
    {"_Vin", AddressSpace::kUndefined},          {"__ou1", AddressSpace::kUndefined},
    {"qq_Jt", AddressSpace::kUndefined},         {"__oll7t", AddressSpace::kUndefined},
    {"qquntppHon", AddressSpace::kUndefined},    {"cnciv", AddressSpace::kUndefined},
    {"funGion", AddressSpace::kUndefined},       {"priviive", AddressSpace::kUndefined},
    {"8WWivate", AddressSpace::kUndefined},      {"pxxvate", AddressSpace::kUndefined},
    {"pXh_cggnstant", AddressSpace::kUndefined}, {"pX_Vonstanu", AddressSpace::kUndefined},
    {"push_consta3t", AddressSpace::kUndefined}, {"Etorage", AddressSpace::kUndefined},
    {"sPTTrage", AddressSpace::kUndefined},      {"storadxx", AddressSpace::kUndefined},
    {"u44iform", AddressSpace::kUndefined},      {"unSSfoVVm", AddressSpace::kUndefined},
    {"RniR22m", AddressSpace::kUndefined},       {"w9rFroup", AddressSpace::kUndefined},
    {"workgoup", AddressSpace::kUndefined},      {"woVROOrHup", AddressSpace::kUndefined},
};

using AddressSpaceParseTest = testing::TestWithParam<Case>;

TEST_P(AddressSpaceParseTest, Parse) {
    const char* string = GetParam().string;
    AddressSpace expect = GetParam().value;
    EXPECT_EQ(expect, ParseAddressSpace(string));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, AddressSpaceParseTest, testing::ValuesIn(kValidCases));
INSTANTIATE_TEST_SUITE_P(InvalidCases, AddressSpaceParseTest, testing::ValuesIn(kInvalidCases));

using AddressSpacePrintTest = testing::TestWithParam<Case>;

TEST_P(AddressSpacePrintTest, Print) {
    AddressSpace value = GetParam().value;
    const char* expect = GetParam().string;
    EXPECT_EQ(expect, utils::ToString(value));
}

INSTANTIATE_TEST_SUITE_P(ValidCases, AddressSpacePrintTest, testing::ValuesIn(kValidCases));

}  // namespace parse_print_tests

}  // namespace
}  // namespace tint::builtin
