// Copyright 2020 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/address_space.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/address_space.h"

namespace tint::builtin {

/// ParseAddressSpace parses a AddressSpace from a string.
/// @param str the string to parse
/// @returns the parsed enum, or AddressSpace::kUndefined if the string could not be parsed.
AddressSpace ParseAddressSpace(std::string_view str) {
    if (str == "__in") {
        return AddressSpace::kIn;
    }
    if (str == "__out") {
        return AddressSpace::kOut;
    }
    if (str == "function") {
        return AddressSpace::kFunction;
    }
    if (str == "private") {
        return AddressSpace::kPrivate;
    }
    if (str == "push_constant") {
        return AddressSpace::kPushConstant;
    }
    if (str == "storage") {
        return AddressSpace::kStorage;
    }
    if (str == "uniform") {
        return AddressSpace::kUniform;
    }
    if (str == "workgroup") {
        return AddressSpace::kWorkgroup;
    }
    return AddressSpace::kUndefined;
}

std::ostream& operator<<(std::ostream& out, AddressSpace value) {
    switch (value) {
        case AddressSpace::kUndefined:
            return out << "undefined";
        case AddressSpace::kIn:
            return out << "__in";
        case AddressSpace::kOut:
            return out << "__out";
        case AddressSpace::kFunction:
            return out << "function";
        case AddressSpace::kHandle:
            return out << "handle";
        case AddressSpace::kPrivate:
            return out << "private";
        case AddressSpace::kPushConstant:
            return out << "push_constant";
        case AddressSpace::kStorage:
            return out << "storage";
        case AddressSpace::kUniform:
            return out << "uniform";
        case AddressSpace::kWorkgroup:
            return out << "workgroup";
    }
    return out << "<unknown>";
}

}  // namespace tint::builtin
