// Copyright 2022 The Tint Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

////////////////////////////////////////////////////////////////////////////////
// File generated by tools/src/cmd/gen
// using the template:
//   src/tint/builtin/access_bench.cc.tmpl
//
// Do not modify this file directly
////////////////////////////////////////////////////////////////////////////////

#include "src/tint/builtin/access.h"

#include <array>

#include "benchmark/benchmark.h"

namespace tint::builtin {
namespace {

void AccessParser(::benchmark::State& state) {
    const char* kStrings[] = {
        "ccad",       "3",           "rVad",         "read",       "1ead",
        "rqaJ",       "rlla77",      "reqqdppriHHe", "rv_wcit",    "reabGwrte",
        "read_write", "read_vriite", "re8d_wriWWe",  "Meadxxrite", "wggte",
        "VtX",        "writ3",       "write",        "writE",      "TTrPte",
        "wxxidd",
    };
    for (auto _ : state) {
        for (auto* str : kStrings) {
            auto result = ParseAccess(str);
            benchmark::DoNotOptimize(result);
        }
    }
}

BENCHMARK(AccessParser);

}  // namespace
}  // namespace tint::builtin
