// Copyright 2018 The Dawn Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#ifndef SRC_DAWN_NATIVE_VULKAN_PIPELINELAYOUTVK_H_
#define SRC_DAWN_NATIVE_VULKAN_PIPELINELAYOUTVK_H_

#include "dawn/native/PipelineLayout.h"

#include "dawn/common/vulkan_platform.h"
#include "dawn/native/Error.h"

namespace dawn::native::vulkan {

class Device;

// 8 bytes of push constant data are always reserved in the Vulkan pipeline layouts to be used by
// the code generated by the ClampFragDepth Tint transform. TODO(dawn:1576): Optimize usage of push
// constants so that they are only added to a pipeline / pipeline layout if needed.
struct ClampFragDepthArgs {
    float min;
    float max;
};
constexpr size_t kClampFragDepthArgsOffset = 0u;
constexpr size_t kClampFragDepthArgsSize = sizeof(ClampFragDepthArgs);
static_assert(kClampFragDepthArgsSize == 8u);

class PipelineLayout final : public PipelineLayoutBase {
  public:
    static ResultOrError<Ref<PipelineLayout>> Create(Device* device,
                                                     const PipelineLayoutDescriptor* descriptor);

    VkPipelineLayout GetHandle() const;

    // Friend definition of StreamIn which can be found by ADL to override stream::StreamIn<T>.
    friend void StreamIn(stream::Sink* sink, const PipelineLayout& obj) {
        StreamIn(sink, static_cast<const CachedObject&>(obj));
    }

  private:
    ~PipelineLayout() override;
    void DestroyImpl() override;

    using PipelineLayoutBase::PipelineLayoutBase;
    MaybeError Initialize();

    // Dawn API
    void SetLabelImpl() override;

    VkPipelineLayout mHandle = VK_NULL_HANDLE;
};

}  // namespace dawn::native::vulkan

#endif  // SRC_DAWN_NATIVE_VULKAN_PIPELINELAYOUTVK_H_
