// Copyright 2017 The Dawn Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "dawn/native/opengl/SwapChainGL.h"

#include "dawn/native/opengl/DeviceGL.h"
#include "dawn/native/opengl/Forward.h"
#include "dawn/native/opengl/TextureGL.h"

#include "dawn/dawn_wsi.h"

namespace dawn::native::opengl {

SwapChain::SwapChain(Device* device, const SwapChainDescriptor* descriptor)
    : OldSwapChainBase(device, descriptor) {
    const auto& im = GetImplementation();
    im.Init(im.userData, nullptr);
}

SwapChain::~SwapChain() {}

TextureBase* SwapChain::GetNextTextureImpl(const TextureDescriptor* descriptor) {
    const auto& im = GetImplementation();
    DawnSwapChainNextTexture next = {};
    DawnSwapChainError error = im.GetNextTexture(im.userData, &next);
    if (error) {
        GetDevice()->HandleError(InternalErrorType::Internal, error);
        return nullptr;
    }
    GLuint nativeTexture = next.texture.u32;
    return new Texture(ToBackend(GetDevice()), descriptor, nativeTexture,
                       TextureBase::TextureState::OwnedExternal);
}

MaybeError SwapChain::OnBeforePresent(TextureViewBase*) {
    return {};
}

}  // namespace dawn::native::opengl
