# Tint Source Layering

The `BUILD.gn` is setup with small source units for various components
in Tint. The hierarchy of sources almost matches to folder structure in
tint (except for `base` which is a mix of things in `src/tint` and
`src/tint/util`.


```
+-----------------------------------------+
|         Readers | Writers               |
+-----------------------------------------+
                  |
                  V
+-----------------------------------------+
| Val | Demangler | Inspector | Transform |
+-----------------------------------------+
   |              |
   +--------------+------------------------------+
                  |                              |
                  V                              V
+-----------------------------------------+ +-----------+
|                AST                      | |  Utils IO |
+-----------------------------------------+ +-----------+
                  |                              |
                  V                              |
+-----------------------------------------+      |
|        Program  | Sem                   |      |
+-----------------------------------------+      |
                  |                              |
                  V                              |
+-----------------------------------------+      |
|              AST Hdrs                   |      |
|    (program and sem cause a cycle)      |      |
+-----------------------------------------+      |
                  |                              |
                  V                              |
+-----------------------------------------+      |
|        Clone Context Hdrs               |      |
|    (program and sem cause a cycle)      |      |
+-----------------------------------------+      |
                  |                              |
                  V                              |
+-----------------------------------------+      |
|             Constant                    |      |
+-----------------------------------------+      |
                  |                              |
                  V                              |
+-----------------------------------------+      |
|               Types                     |      |
+-----------------------------------------+      |
                  |                              |
                  V                              |
+-----------------------------------------+      |
|              Builtin                    |      |
+-----------------------------------------+      |
                  |                              |
                  |------------------------------+
                  V
+-----------------------------------------+
|               Base                      |
+-----------------------------------------+
                  |
                  V
+-----------------------------------------+ +-------------+
|            Text  (unicode)              | | Initializer |
+-----------------------------------------+ +-------------+
```
