// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is auto-generated from
//    gpu/config/process_json.py
// It's formatted by clang-format using chromium coding style:
//    clang-format -i -style=chromium filename
// DO NOT EDIT!

#ifndef GPU_CONFIG_GPU_CONTROL_LIST_TESTING_ARRAYS_AND_STRUCTS_AUTOGEN_H_
#define GPU_CONFIG_GPU_CONTROL_LIST_TESTING_ARRAYS_AND_STRUCTS_AUTOGEN_H_

#include "gpu/config/gpu_control_list_testing_data.h"

namespace gpu {
const int kFeatureListForGpuControlTestingEntry1[1] = {
    TEST_FEATURE_0,
};

const char* const kDisabledExtensionsForEntry1[2] = {
    "test_extension1",
    "test_extension2",
};

const uint32_t kCrBugsForGpuControlTestingEntry1[2] = {
    1024,
    678,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry1[1] = {
    {0x0640, 0x0},
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry1 = {
    nullptr,  // driver_vendor
    {GpuControlList::kEQ, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "1.6.18",
     nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry1_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry2[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry2_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry3[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry3_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry4[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry4_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::More kMoreForEntry4_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry5[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry5_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::More kMoreForEntry5_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry6[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry6[2] = {
    {0x1023, 0x0},
    {0x0640, 0x0},
};

const GpuControlList::More kMoreForEntry6_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry7[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry7_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry8[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry8_1440601243 = {
    GpuControlList::kGLTypeGLES,  // gl_type
    {GpuControlList::kEQ, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "3.0", nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry9[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry9_1440601243 = {
    GpuControlList::kGLTypeANGLE,  // gl_type
    {GpuControlList::kGT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "2.0", nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry10[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry10_1440601243 = {
    GpuControlList::kGLTypeGL,  // gl_type
    {GpuControlList::kLT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "4.0", nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry11[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::GLStrings kGLStringsForGpuControlTestingEntry11 = {
    "NVIDIA",
    nullptr,
    nullptr,
    nullptr,
};

const GpuControlList::More kMoreForEntry11_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry12[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::GLStrings kGLStringsForGpuControlTestingEntry12 = {
    "X\\.Org.*",
    nullptr,
    nullptr,
    nullptr,
};

const GpuControlList::More kMoreForEntry12_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry13[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::GLStrings kGLStringsForGpuControlTestingEntry13 = {
    nullptr,
    ".*GeForce.*",
    nullptr,
    nullptr,
};

const GpuControlList::More kMoreForEntry13_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry14[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::GLStrings kGLStringsForGpuControlTestingEntry14 = {
    nullptr,
    "(?i).*software.*",
    nullptr,
    nullptr,
};

const GpuControlList::More kMoreForEntry14_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry15[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::GLStrings kGLStringsForGpuControlTestingEntry15 = {
    nullptr,
    nullptr,
    ".*GL_SUN_slice_accum",
    nullptr,
};

const GpuControlList::More kMoreForEntry15_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry16[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry16_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry17[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry17_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry18[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry18 = {
    "NVIDIA.*",  // driver_vendor
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry18_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry19[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry19 = {
    nullptr,  // driver_vendor
    {GpuControlList::kEQ, GpuControlList::kVersionStyleLexical,
     GpuControlList::kVersionSchemaCommon, "8.76", nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry19_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry20[1] = {
    TEST_FEATURE_1,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry20 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "24.20.100.7000",
     nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry20_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry21[1] = {
    TEST_FEATURE_1,
};

const GpuControlList::More kMoreForEntry21_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::GLStrings
    kGLStringsForGpuControlTestingEntry21Exception0 = {
        nullptr,
        ".*mesa.*",
        nullptr,
        nullptr,
};

const GpuControlList::More kMoreForEntry21_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry22[1] = {
    TEST_FEATURE_1,
};

const GpuControlList::More kMoreForEntry22_1440601243 = {
    GpuControlList::kGLTypeGL,  // gl_type
    {GpuControlList::kLT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "3.5", nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry23[3] = {
    TEST_FEATURE_0,
    TEST_FEATURE_1,
    TEST_FEATURE_2,
};

const GpuControlList::More kMoreForEntry23_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry24[2] = {
    TEST_FEATURE_1,
    TEST_FEATURE_2,
};

const GpuControlList::More kMoreForEntry24_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry25[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry25[1] = {
    {0x0640, 0x0},
};

const GpuControlList::More kMoreForEntry25_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry26[1] = {
    TEST_FEATURE_0,
};

const char* const kMachineModelNameForEntry26[4] = {
    "Nexus 4",
    "XT1032",
    "GT-.*",
    "SCH-.*",
};

const GpuControlList::MachineModelInfo kMachineModelInfoForEntry26 = {
    std::size(kMachineModelNameForEntry26),  // machine model name size
    kMachineModelNameForEntry26,             // machine model names
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // machine model version
};

const GpuControlList::More kMoreForEntry26_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry27[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry27_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const char* const kMachineModelNameForEntry27Exception0[1] = {
    "Nexus.*",
};

const GpuControlList::MachineModelInfo kMachineModelInfoForEntry27Exception0 = {
    std::size(
        kMachineModelNameForEntry27Exception0),  // machine model name size
    kMachineModelNameForEntry27Exception0,       // machine model names
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // machine model version
};

const GpuControlList::More kMoreForEntry27_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry28[1] = {
    TEST_FEATURE_0,
};

const char* const kMachineModelNameForEntry28[1] = {
    "MacBookPro",
};

const GpuControlList::MachineModelInfo kMachineModelInfoForEntry28 = {
    std::size(kMachineModelNameForEntry28),  // machine model name size
    kMachineModelNameForEntry28,             // machine model names
    {GpuControlList::kEQ, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "7.1",
     nullptr},  // machine model version
};

const GpuControlList::More kMoreForEntry28_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry29[1] = {
    TEST_FEATURE_0,
};

const char* const kMachineModelNameForEntry29[1] = {
    "MacBookPro",
};

const GpuControlList::MachineModelInfo kMachineModelInfoForEntry29 = {
    std::size(kMachineModelNameForEntry29),  // machine model name size
    kMachineModelNameForEntry29,             // machine model names
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // machine model version
};

const GpuControlList::More kMoreForEntry29_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::MachineModelInfo kMachineModelInfoForEntry29Exception0 = {
    0,        // machine model name size
    nullptr,  // machine model names
    {GpuControlList::kGT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "7.1",
     nullptr},  // machine model version
};

const GpuControlList::More kMoreForEntry29_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry30[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry30[1] = {
    {0x0166, 0x0},
};

const GpuControlList::More kMoreForEntry30_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry31[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry31[1] = {
    {0x0640, 0x0},
};

const GpuControlList::More kMoreForEntry31_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry32[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry32[1] = {
    {0x0166, 0x0},
};

const GpuControlList::More kMoreForEntry32_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry33[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry33[1] = {
    {0x0166, 0x0},
};

const GpuControlList::More kMoreForEntry33_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry34[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry34[1] = {
    {0x0166, 0x0},
};

const GpuControlList::More kMoreForEntry34_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry35[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry35[2] = {
    {0x0166, 0x0},
    {0x0168, 0x0},
};

const GpuControlList::More kMoreForEntry35_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry36[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry36_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry37[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry37[1] = {
    {0x0640, 0x0},
};

const GpuControlList::More kMoreForEntry37_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry38[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry38_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry39[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry39_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kLT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "4.1",
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry40[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry40_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry41[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry41_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry42[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry42_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry43[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry43_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry44[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry44_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry44Exception0[1] =
    {
        {0x2a06, 0x0},
};

const GpuControlList::DriverInfo
    kDriverInfoForGpuControlTestingEntry44Exception0 = {
        nullptr,  // driver_vendor
        {GpuControlList::kGE, GpuControlList::kVersionStyleNumerical,
         GpuControlList::kVersionSchemaCommon, "8.1",
         nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry44_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry44Exception1[1] =
    {
        {0x2a02, 0x0},
};

const GpuControlList::DriverInfo
    kDriverInfoForGpuControlTestingEntry44Exception1 = {
        nullptr,  // driver_vendor
        {GpuControlList::kGE, GpuControlList::kVersionStyleNumerical,
         GpuControlList::kVersionSchemaCommon, "9.1",
         nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry44_1440601243Exception1 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry45[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry45_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry46[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry46_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry47[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry47_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    true,       // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry48[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry48_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry49[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry49 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLE, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "8.17.12.6973",
     nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry49_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry50[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry50 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "12", nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry50_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry51[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry51_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::GLStrings
    kGLStringsForGpuControlTestingEntry51Exception0 = {
        nullptr,
        ".*mesa.*",
        nullptr,
        nullptr,
};

const GpuControlList::More kMoreForEntry51_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry52[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry52_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry53[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry53 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLT, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "10.7", nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry53_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const char* const kDisabledExtensionsForEntry54[2] = {
    "test_extension2",
    "test_extension1",
};

const GpuControlList::More kMoreForEntry54_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const char* const kDisabledExtensionsForEntry55[2] = {
    "test_extension3",
    "test_extension2",
};

const GpuControlList::More kMoreForEntry55_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry56[1] = {
    TEST_FEATURE_1,
};

const GpuControlList::More kMoreForEntry56_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kGE, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "2",
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry57[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry57_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry58[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry58_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    1,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry59[1] = {
    TEST_FEATURE_1,
};

const GpuControlList::More kMoreForEntry59_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    2,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry60[1] = {
    TEST_FEATURE_0,
};

const IntelGpuSeriesType kIntelGpuSeriesForEntry60[2] = {
    IntelGpuSeriesType::kSkylake,
    IntelGpuSeriesType::kKabylake,
};

const GpuControlList::More kMoreForEntry60_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry61[1] = {
    TEST_FEATURE_0,
};

const IntelGpuSeriesType kIntelGpuSeriesForEntry61[1] = {
    IntelGpuSeriesType::kKabylake,
};

const GpuControlList::More kMoreForEntry61_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry62[1] = {
    TEST_FEATURE_0,
};

const IntelGpuSeriesType kIntelGpuSeriesForEntry62[1] = {
    IntelGpuSeriesType::kKabylake,
};

const GpuControlList::More kMoreForEntry62_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry63[1] = {
    TEST_FEATURE_0,
};

const IntelGpuSeriesType kIntelGpuSeriesForEntry63[1] = {
    IntelGpuSeriesType::kKabylake,
};

const GpuControlList::More kMoreForEntry63_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry64[1] = {
    TEST_FEATURE_0,
};

const IntelGpuSeriesType kIntelGpuSeriesForEntry64[1] = {
    IntelGpuSeriesType::kKabylake,
};

const GpuControlList::More kMoreForEntry64_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry65[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry65_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const IntelGpuSeriesType kIntelGpuSeriesForEntry65Exception0[1] = {
    IntelGpuSeriesType::kKabylake,
};

const GpuControlList::More kMoreForEntry65_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry66[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry66 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLE, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "8.15.10.2702",
     nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry66_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry67[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry67_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kUnsupported,  // hardware_overlay
    0,                             // test_group
    GpuControlList::kDontCare,     // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry68[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry68_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry69[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry69_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry70[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry70_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry71[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry71_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry72[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry72_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry73[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry73_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::GLStrings
    kGLStringsForGpuControlTestingEntry73Exception0 = {
        nullptr,
        "Mali.*",
        nullptr,
        nullptr,
};

const GpuControlList::More kMoreForEntry73_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,     // hardware_overlay
    0,                             // test_group
    GpuControlList::kUnsupported,  // subpixel_font_rendering
};

const GpuControlList::GLStrings
    kGLStringsForGpuControlTestingEntry73Exception1 = {
        nullptr,
        "DontCare",
        nullptr,
        nullptr,
};

const GpuControlList::More kMoreForEntry73_1440601243Exception1 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::GLStrings
    kGLStringsForGpuControlTestingEntry73Exception2 = {
        nullptr,
        "Supported",
        nullptr,
        nullptr,
};

const GpuControlList::More kMoreForEntry73_1440601243Exception2 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,   // hardware_overlay
    0,                           // test_group
    GpuControlList::kSupported,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry74[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::GLStrings kGLStringsForGpuControlTestingEntry74 = {
    nullptr,
    "Mali.*",
    nullptr,
    nullptr,
};

const GpuControlList::More kMoreForEntry74_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry75[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry75 = {
    "Intel.*",  // driver_vendor
    {GpuControlList::kBetween, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaIntelDriver, "24.20.100.6000",
     "26.20.100.7000"},  // driver_version
};

const GpuControlList::More kMoreForEntry75_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry76[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry76 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLE, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaIntelDriver, "24.20.100.7000",
     nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry76_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry77[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::More kMoreForEntry77_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry77Exception0[2] =
    {
        {0x15D8, 0x93},
        {0x15DD, 0x86},
};

const GpuControlList::DriverInfo
    kDriverInfoForGpuControlTestingEntry77Exception0 = {
        nullptr,  // driver_vendor
        {GpuControlList::kGE, GpuControlList::kVersionStyleNumerical,
         GpuControlList::kVersionSchemaCommon, "26.20.15023.6032",
         nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry77_1440601243Exception0 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry77Exception1[2] =
    {
        {0x15D8, 0xE1},
        {0x15D8, 0xE2},
};

const GpuControlList::DriverInfo
    kDriverInfoForGpuControlTestingEntry77Exception1 = {
        nullptr,  // driver_vendor
        {GpuControlList::kGE, GpuControlList::kVersionStyleNumerical,
         GpuControlList::kVersionSchemaCommon, "26.20.12055.1000",
         nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry77_1440601243Exception1 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry78[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::Device kDevicesForGpuControlTestingEntry78[2] = {
    {0x15D8, 0x0},
    {0x15DD, 0x0},
};

const GpuControlList::More kMoreForEntry78_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry79[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry79 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLE, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "24.21.13.9826",
     nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry79_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

const int kFeatureListForGpuControlTestingEntry80[1] = {
    TEST_FEATURE_0,
};

const GpuControlList::DriverInfo kDriverInfoForGpuControlTestingEntry80 = {
    nullptr,  // driver_vendor
    {GpuControlList::kLE, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, "24.21.13.9826",
     nullptr},  // driver_version
};

const GpuControlList::More kMoreForEntry80_1440601243 = {
    GpuControlList::kGLTypeNone,  // gl_type
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gl_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // pixel_shader_version
    false,      // in_process_gpu
    0,          // gl_reset_notification_strategy
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr,
     nullptr},  // direct_rendering_version
    {GpuControlList::kUnknown, GpuControlList::kVersionStyleNumerical,
     GpuControlList::kVersionSchemaCommon, nullptr, nullptr},  // gpu_count
    GpuControlList::kDontCare,  // hardware_overlay
    0,                          // test_group
    GpuControlList::kDontCare,  // subpixel_font_rendering
};

}  // namespace gpu

#endif  // GPU_CONFIG_GPU_CONTROL_LIST_TESTING_ARRAYS_AND_STRUCTS_AUTOGEN_H_
