# Learning about Chromium UI

# Getting Started

* As always, feel free to [reach out](/docs/ui/ask/index.md). We're happy to
  assist!
* [Prepare your code for review](bestpractices/prepare_for_code_review.md):
  Common feedback during code review and how to address it.

# Best Practices

* [Colors](bestpractices/colors.md): How to work with Chromium colors.
* [Layout](bestpractices/layout.md): How to use Views layout.
* [Ownership](bestpractices/ownership.md): How to manage Views object lifetimes.

# Chrome UI
* [Activation and Focus](activation_and_focus.md)
* [Animation Builder](/docs/ui/animation_builder/animation_builder.md)
* [Glossary](glossary.md)
* [Input Event Routing](/docs/ui/input_event/index.md)
* [Metadata and Properties](/docs/ui/views/metadata_properties.md)
* [Product Excellence](/docs/ui/product_excellence/index.md)
* [UI Debugging](ui_debugging.md)
* [UI Devtools](/docs/ui/ui_devtools/index.md)
* [Views](/docs/ui/views/overview.md)

# Archival Documentation on Chrome UI.

* [Aura](/docs/ui/aura/index.md)
* [Compositor](/docs/ui/compositor/index.md)

# Processes

* [Frontline Triage Procedures](/docs/ui/frontline_triage.md)

