# Loading metrics changes in Chrome 99

## Navigation optimizations

A few changes are being rolled out that may impact loading metrics, such as
FCP and LCP. Most of these changes are
[browser optimizations](https://blog.chromium.org/2022/03/a-new-speed-milestone-for-chrome.html)
that should improve those loading metrics for everyone.

## `timeOrigin` to take pre-`beforeUnload` IPC into account

We also improved the accuracy of the `timeOrigin` value, on which all loading
metrics are based. It now [takes into account an extra IPC call that happens
before `beforeUnload` event handlers](https://bugs.chromium.org/p/chromium/issues/detail?id=1288485).
In scenarios where traffic to your site is coming from a site with a
`beforeUnload` handler, your timeline metrics are likely to slightly change:
because the `timeOrigin` value is now earlier, durations relative to
`timeOrigin` will appear to be larger.

Note that the duration of the `beforeUnload` event itself is not included in
the `timeOrigin`, as its semantic meaning is not changed.

## How does this affect a site's metrics?
On the whole, users will see significant improvements to both FCP and LCP due
to this effort.

The pre-`beforeUnload` IPC change means that if large parts of the traffic to
your site are coming from sites with a `beforeUnload` handler, you may see a
mix of metric regressions and progressions.
Otherwise, you're likely to see your metrics improve.

## When were users affected?
This change is being rolled out starting from Chrome 99.