# Cumulative Layout Shift Changes in Chrome 90

### Bug fixes involving changes to transform, effect, clip or position

[Source code for change 1](https://chromium-review.googlesource.com/c/chromium/src/+/2660679)
[Source code for change 2](https://chromium-review.googlesource.com/c/chromium/src/+/2666949)
[Source code for change 3](https://chromium-review.googlesource.com/c/chromium/src/+/2665761)
[Source code for change 4](https://chromium-review.googlesource.com/c/chromium/src/+/2690998)

### Consider transform change countering layout shift

Corresponds to [the spec change](https://github.com/WICG/layout-instability/pull/94)
[Source code](https://chromium-review.googlesource.com/c/chromium/src/+/2673965)

### Ignore layout shift for more invisible elements

The following nodes are ignored for layout shift:
* texts with unrenderable font or containing all whitespaces,
* blocks without any decorations or any children.

If you still see layout shift reported for an invisible element, you can
try to add 'visibility:hidden' to the element's style.

[Source code](https://chromium-review.googlesource.com/c/chromium/src/+/2743811)

### Ignore inline direction shift moving from/to out of view

[Source code](https://chromium-review.googlesource.com/c/chromium/src/+/2747689)

### Improvement for shift with counterscroll

[Source code](https://chromium-review.googlesource.com/c/chromium/src/+/2741240)

## When were users affected?

Chrome 90 is currently scheduled to be released the week of April 13, 2021.
