# Security rules

This is a list of the security policies Chromium has published.

* [Rule of Two](rule-of-2.md) - don't handle untrustworthy data in the browser
  process in an unsafe language
* [The browser process should not handle messages from web
  content](handling-messages-from-web-content.md)
* [Behavior should be part of Chrome's binaries or delivered via component
  updater](behavior-over-the-internet.md) rather than delivered dynamically
* Rules for [Android IPC](android-ipc.md)
* [Always assume a compromised renderer](compromised-renderers.md)
* [Use origin not URL for security decisions](origin-vs-url.md)
* [Controlling access to powerful web platform
  features](permissions-for-powerful-web-platform-features.md)
* [Security considerations for browser UI](security-considerations-for-browser-ui.md)

You can also find our position on various matters in the [security FAQ](faq.md):
for example, on local attackers or on the privilege accorded to enterprise
admins.
