# Chromium's credProtect behaviour in WebAuthn

CTAP defines an extension called [`credProtect`](https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#sctn-credProtect-extension) which restricts when credentials on security keys may be used. Support for it is required [in some cases](https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#mandatory-features) and thus it is widely supported by security keys.

Chromium will request a protection level of [userVerificationOptionalWithCredentialIDList](https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#userverificationoptionalwithcredentialidlist) when creating a credential if [`residentKey`](https://www.w3.org/TR/webauthn-2/#dom-authenticatorselectioncriteria-residentkey) is set to `preferred` or `required`. (Setting [`requireResidentKey`](https://www.w3.org/TR/webauthn-2/#dom-authenticatorselectioncriteria-requireresidentkey) is treated the same as `required`.) This ensures that simple physical possession of a security key does not allow the presence of a discoverable credential for a given RP ID to be queried.

Additionally, if [`residentKey`](https://www.w3.org/TR/webauthn-2/#dom-authenticatorselectioncriteria-residentkey) is `required` _and_ [`userVerification`](https://www.w3.org/TR/webauthn-2/#dom-authenticatorselectioncriteria-userverification) is `preferred`, the protection level will be increased to [userVerificationRequired](https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#userverificationrequired). This ensures that physical possession of a security key does not allow sign-in to a site that doesn't demand user verification. (This is not a complete protection; sites should still carefully consider the security of their users.)

If an explicit `credProtect` level is requested by the site, that will override these defaults. These defaults never cause the protection level to be lower than the security key's default, if that is higher.
