/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.api.languages;

/*
 * CompletionSupport.
 *
 * @author Jan Jancura
 */
public class CompletionItem {

    public static enum Type {
        INTERFACE,
        CLASS,
        METHOD,
        FIELD,
        CONSTANT,
        CONSTRUCTOR,
        PARAMETER,
        LOCAL,
        KEYWORD
    };
    
    public static CompletionItem create (
        String          text
    ) {
        return new CompletionItem (text, null, null, null, 200);
    }
    
    public static CompletionItem create (
        String          text,
        String          description,
        String          library,
        Type            type,
        int             priority
    ) {
        return new CompletionItem (text, description, library, type, priority);
    }

    private String      text;
    private String      description;
    private String      library;
    private Type        type;
    private int         priority;

    public CompletionItem (
        String          text, 
        String          description, 
        String          library,
        Type            type, 
        int             priority
    ) {
        this.text =     text;
        this.description = description;
        this.library =  library;
        this.type =     type;
        this.priority = priority;
    }

    public String getText() {
        return text;
    }

    public String getDescription() {
        return description;
    }

    public String getLibrary() {
        return library;
    }

    public Type getType() {
        return type;
    }

    public int getPriority() {
        return priority;
    }
}


