#if 0
#pragma makedep unix
#endif

#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <sys/un.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#include "dvhp.h"
#include <stdint.h>

#ifndef DV_SOCKET
#define DV_SOCKET "/tmp/dv"
#endif

#define VERSION "dvcli_001"

static int enable_log = 0;
#define debug(...)  do{if(enable_log) printf(__VA_ARGS__);}while(0)


#define safe_read(fd, buf, size) do {                    \
        int remaining = size;                    \
        char *ptr = (char *) buf;                \
        int rc;                            \
        while (remaining > 0) {                    \
            rc = read(fd, ptr, remaining);            \
            if ((rc == 0) && (remaining == size)) {        \
                debug("%s:%d: %s: safe_read EOF",    \
                      __FILE__, __LINE__, __func__); \
                goto __fail;                \
            } else if (rc == 0) {                \
                debug("%s:%d: %s: safe_read (%d of %d) EOF", \
                      __FILE__, __LINE__, __func__, \
                      remaining, (int)size);        \
                goto __fail;                \
            } else if (rc < 0) {                \
                if ((errno == EAGAIN) ||        \
                    (errno == EINTR) ||            \
                    (errno == EWOULDBLOCK))        \
                    continue;            \
                debug("%s:%d: %s: safe_read (%d of %d) failed: %m", \
                      __FILE__, __LINE__, __func__, \
                      remaining, (int)size);        \
                goto __fail;                \
            } else {                    \
                ptr += rc;                \
                remaining -= rc;            \
                if (remaining > 0)            \
                    debug("%s:%d: %s: safe_read (%d of %d) partial read", \
                           __FILE__, __LINE__, __func__, \
                           remaining, (int)size);    \
            }                        \
        }                            \
    } while (0)

#define safe_write(fd, buf, size) do {                    \
        int remaining = size;                    \
        char *ptr = (char *) buf;                \
        int rc;                            \
        while(remaining > 0) {                    \
            rc = write(fd, ptr, remaining);            \
             if (rc < 0) {                    \
                if ((errno == EAGAIN) || (errno == EINTR))\
                    continue;            \
                debug("%s:%d: %s: safe_write (%d of %d) failed: %m", \
                      __FILE__, __LINE__, __func__, \
                      remaining, (int)size);        \
                goto __fail;                \
            } else {                    \
                ptr += rc;                \
                remaining -= rc;            \
                if (remaining > 0)            \
                    debug("%s:%d: %s: safe_write (%d of %d) partial write", \
                           __FILE__, __LINE__, __func__, \
                           remaining, (int)size);    \
            }                        \
        }                            \
    } while (0)

#define CHECK_DATA_SIZE 32
int cdv() {
    struct sockaddr_un address;
    int cli_fd;

    enable_log = !!getenv("DV");

    /*创建socket,AF_UNIX通信协议,SOCK_STREAM数据方式*/
    if ((cli_fd = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) goto __fail;

    address.sun_family = AF_UNIX;
    strcpy (address.sun_path, DV_SOCKET);

    /*向服务器发送连接请求*/
    if (connect (cli_fd, (struct sockaddr *)&address, sizeof (address)) == -1) {
        debug("connect failed: %s\n", strerror (errno));
        goto __fail;
    }
    // verify
    uint8_t check_data[CHECK_DATA_SIZE];
    uint8_t signed_data[CHECK_DATA_SIZE];
    int size = CHECK_DATA_SIZE;
    if (create_sign_req(check_data, size) == 0) {
        goto __fail;
    }

    safe_write(cli_fd, &size, sizeof(size));
    safe_write(cli_fd, check_data, size);

    safe_read(cli_fd, signed_data, size);
    close (cli_fd);

    return dv_verify(check_data, size, signed_data, size);

__fail:
    close (cli_fd);
    return 0;
}
