// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from System.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.sys {
  public class System : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("sys.System:1.0.0", null);

    public System(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public System(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new System StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new System(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class IsDaemonRunningResult {
      public bool _ret_;
    }

    public IsDaemonRunningResult isDaemonRunning(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("isDaemonRunning", _parameters);
      var _ret = new IsDaemonRunningResult();
      _ret._ret_ = (bool)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest isDaemonRunning(string name, AsyncRpcResponse<IsDaemonRunningResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return isDaemonRunning(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest isDaemonRunning(string name, AsyncRpcResponse<IsDaemonRunningResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("isDaemonRunning", _parameters,
        _result => {
          try {
            var _ret = new IsDaemonRunningResult();
            _ret._ret_ = (bool)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class RestartDaemonResult {
    }

    public RestartDaemonResult restartDaemon(string name) {
      var _parameters = new LightJson.JsonObject();
      _parameters["name"] = name;

      var _result = RpcCall("restartDaemon", _parameters);
      var _ret = new RestartDaemonResult();
      return _ret;
    }

    public AsyncRequest restartDaemon(string name, AsyncRpcResponse<RestartDaemonResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return restartDaemon(name, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest restartDaemon(string name, AsyncRpcResponse<RestartDaemonResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["name"] = name;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("restartDaemon", _parameters,
        _result => {
          try {
            var _ret = new RestartDaemonResult();
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
