% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue_estimation.R
\name{pvalue_estimation}
\alias{pvalue_estimation}
\title{Estimates the p value of the Jaccard Coefficient for pairs of diseases}
\usage{
pvalue_estimation(
  input,
  database = "CURATED",
  api_key = NULL,
  nboot = 100,
  ncores = 1,
  verbose = FALSE
)
}
\arguments{
\item{database}{Name of the database that will be queried. It can take the values:
\code{'CTD_human'} to use Comparative Toxicogenomics Database, human data;
\code{'UNIPROT'} to use Universal Protein Resource;
\code{'CLINGEN'} to use Clinical Genome Resource;
\code{'CGI'} to use Cancer Genome Interpreter;
\code{'ORPHANET'}, to use Orphanet, the portal for rare diseases and orphan drugs;
\code{'PSYGENET'} to use PSYGENET;
\code{'GENOMICS_ENGLAND'} to use Genomics England PanelApp;
\code{'CURATED'} to use expert curated, human databases;
\code{'HPO'} to use HPO;
\code{'INFERRED'} to use inferred data from HPO, GWASDB, GWASCAT, and CLINVAR;
\code{'CTD_rat'} to use Comparative Toxicogenomics Database, rat data;
\code{'CTD_mouse'} to use Comparative Toxicogenomics Database, mouse data;
\code{'RGD'}, to use Rat Genome Database;
\code{'MGD'}, to use the Mouse Genome Database;
\code{'ANIMAL_MODELS'} to use the expert curated, animal models data;
\code{'GWASCAT'} to use the NHGRI-EBI GWAS Catalog;
\code{'GWASDB'} to use the GWAS Database GWASdb;
\code{'CLINVAR'} to use ClinVar, a public archive of relationships
among sequence variation and human phenotype;
\code{'BEFREE'} to use text mining data, generated using BeFree System;
\code{'ALL'} to use all these databases. Default \code{'CURATED'}.}

\item{nboot}{Number of iterations sued to compute the pvalue associted
to the calculated Jaccard Index. Default: 1000.}

\item{ncores}{Number of cores used to calculate the pvalue associated to
the computed Jaccard Index. Default: 1.}

\item{verbose}{By default \code{FALSE}. Change it to \code{TRUE} to get a
on-time log from the function.}

\item{object}{receives dataframe produced by function disgenetDisDis}
}
\description{
This function estimates the statistic significance of the Jaccard Coefficient with a bootstrap
}
\examples{
ji <- pvalue_estimation( object = dis, "CURATED" )
}
