% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devutils.R
\name{list.data}
\alias{list.data}
\title{List Package Data Objects}
\usage{
list.data(package = NULL)
}
\arguments{
\item{package}{a single character string that specifies the name of a particular
package where to look for data objects.}
}
\value{
a \code{data.frame} object with columns:
\itemize{
\item \code{package}: name of the package that holds the data object.
\item \code{data}: name of the key to use in \link[utils:data]{utils::data} or \link{ldata} to load the data object.
\item \code{object}: name of the (sub-)object that is contained in the data object.
}
}
\description{
Lists data objects that are shipped within package(s).
}
\examples{

# list all data objects
head(list.data())

# list all data objects in package 'datasets'
subset(list.data("datasets"), data \%in\% "beavers")

}
\seealso{
\link[utils:data]{utils::data}, \link{ldata}
}
