% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keyring-package.R, R/package.R
\docType{package}
\name{keyring-package}
\alias{keyring}
\alias{keyring-package}
\title{keyring: Access the System Credential Store from R}
\description{
Platform independent 'API' to access the operating system's credential store. Currently supports: 'Keychain' on 'macOS', Credential Store on 'Windows', the Secret Service 'API' on 'Linux', and simple, platform independent stores implemented with environment variables or encrypted files. Additional storage back-ends can be added easily.

Platform independent API to many system credential store
implementations. Currently supported:
\itemize{
\item Keychain on macOS,
\item Credential Store on Windows,
\item the Secret Service API on Linux, and
\item environment variables on other platforms.
}
}
\section{Configuring an OS-specific backend}{

\itemize{
\item The default is operating system specific, and is described in
\code{\link[=default_backend]{default_backend()}}. In most cases you don't have to configure this.
\item MacOS: \link{backend_macos}
\item Linux: \link{backend_secret_service}
\item Windows: \link{backend_wincred}
\item Or store the secrets in environment variables on other operating
systems: \link{backend_env}
}
}

\section{Query secret keys in a keyring}{


Each keyring can contain one or many secrets (keys). A key is defined by
a service name and a password. Once a key is defined, it persists in the
keyring store of the operating system. This means the keys persist beyond
the termination of and R session. Specifically, you can define a key
once, and then read the key value in completely independent R sessions.
\itemize{
\item Setting a secret interactively: \code{\link[=key_set]{key_set()}}
\item Setting a secret from a script, i.e. non-interactively:
\code{\link[=key_set_with_value]{key_set_with_value()}}
\item Reading a secret: \code{\link[=key_get]{key_get()}}
\item Listing secrets: \code{\link[=key_list]{key_list()}}
\item Deleting a secret: \code{\link[=key_delete]{key_delete()}}
}
}

\section{Managing keyrings}{


A keyring is a collection of keys that can be treated as a unit.
A keyring typically has a name and a password to unlock it.
\itemize{
\item \code{\link[=keyring_create]{keyring_create()}}
\item \code{\link[=keyring_delete]{keyring_delete()}}
\item \code{\link[=keyring_list]{keyring_list()}}
\item \code{\link[=keyring_lock]{keyring_lock()}}
\item \code{\link[=keyring_unlock]{keyring_unlock()}}
}

Note that all platforms have a default keyring, and \code{key_get()}, etc.
will use that automatically. The default keyring is also convenient,
because the OS unlocks it automatically when you log in, so secrets
are available immediately.

You only need to explicitly deal with keyrings and the \verb{keyring_*}
functions if you want to use a different keyring.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://keyring.r-lib.org/}
  \item \url{https://github.com/r-lib/keyring}
  \item Report bugs at \url{https://github.com/r-lib/keyring/issues}
}


Useful links:
\itemize{
  \item \url{https://keyring.r-lib.org/}
  \item \url{https://github.com/r-lib/keyring}
  \item Report bugs at \url{https://github.com/r-lib/keyring/issues}
}

}
\author{
\strong{Maintainer}: Gábor Csárdi \email{csardi.gabor@gmail.com}

Other contributors:
\itemize{
  \item Alec Wong [contributor]
  \item Posit Software, PBC [copyright holder, funder]
}

}
\keyword{internal}
