% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs4_get.R
\name{gs4_get}
\alias{gs4_get}
\title{Get Sheet metadata}
\usage{
gs4_get(ss)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet:
\itemize{
\item its file id as a string or \code{\link[googledrive:drive_id]{drive_id}}
\item a URL from which we can recover the id
\item a one-row \code{\link[googledrive:dribble]{dribble}}, which is how googledrive
represents Drive files
\item an instance of \code{googlesheets4_spreadsheet}, which is what \code{\link[=gs4_get]{gs4_get()}}
returns
}

Processed through \code{\link[=as_sheets_id]{as_sheets_id()}}.}
}
\value{
A list with S3 class \code{googlesheets4_spreadsheet}, for printing
purposes.
}
\description{
Retrieve spreadsheet-specific metadata, such as details on the individual
(work)sheets or named ranges.
\itemize{
\item \code{gs4_get()} complements \code{\link[googledrive:drive_get]{googledrive::drive_get()}}, which
returns metadata that exists for any file on Drive.
}
}
\examples{
\dontshow{if (gs4_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
gs4_get(gs4_example("mini-gap"))
\dontshow{\}) # examplesIf}
}
\seealso{
Wraps the \code{spreadsheets.get} endpoint:
\itemize{
\item \url{https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/get}
}
}
