% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{gradient}
\alias{gradient}
\title{Create a matrix from vector to represent colors in gradient}
\usage{
gradient(x, min.color, max.color, alpha = NULL, use.names = TRUE, na.rm = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{min.color}{color of minimum value.}

\item{max.color}{color of maximum value.}

\item{alpha}{logical of whether to include alpha channel. \code{NULL}
to let the function decide by input.}

\item{use.names}{logical of whether to preserve names of input vector.}

\item{na.rm}{logical indicating whether to ignore missing values as \code{x}
is normalized. (defult is \code{TRUE})}
}
\value{
a matrix with rgba columns in which each row corresponds to the rgba
value (0-255) of each element in input vector \code{x}. Use \code{csscolor}
to convert the matrix to css color strings compatible with web browsers.
}
\description{
Create a matrix from vector to represent colors in gradient
}
\examples{
gradient(c(1,2,3,4,5), "white", "red")
gradient(c(5,4,3,2,1), "white", "red")
gradient(c(1,3,2,4,5), "white", "red")
gradient(c(1,3,2,4,5), rgb(0,0,0,0.5), rgb(0,0,0,1), alpha = TRUE)
}
\seealso{
\code{\link{csscolor}}
}
