% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectall.R
\name{selectall}
\alias{selectall}
\alias{as.selectall}
\alias{as.matrix.selectall}
\alias{[.selectall}
\alias{is.na.selectall}
\alias{is.selectall}
\title{Make a column for "select all" input}
\usage{
selectall(...)

as.selectall(x)

\method{as.matrix}{selectall}(x, ...)

\method{[}{selectall}(x, i, j, drop = FALSE)

\method{is.na}{selectall}(x)

is.selectall(x)
}
\arguments{
\item{...}{Named arguments of the same length. These should be logical, numeric (0/1) or a factor with two levels.}

\item{x}{An object of class "selectall"}

\item{i, j, drop}{Arguments to `[.matrix`}
}
\description{
Make a column for "select all" input
}
\examples{
d <- data.frame(grp = rep(c("A", "B"), each = 5))
d$s <- selectall(
  `Option 1` = c(rep(1, 4), rep(0, 6)),
  `Option 2` = c(0, 1, 0, 0, 0, 1, 1, 1, 0, 0),
  `Option 3` = 1,
  `Option 4` = 0
)
summary(tableby(grp ~ s, data = d), text = TRUE)
}
\seealso{
\code{\link{tableby}}, \code{\link{paired}}
}
