% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowMeans2.R
\name{rowMeans2}
\alias{rowMeans2}
\alias{rowMeans2,matrix_OR_array_OR_table_OR_numeric-method}
\alias{rowMeans2,ANY-method}
\alias{colMeans2}
\alias{colMeans2,matrix_OR_array_OR_table_OR_numeric-method}
\alias{colMeans2,ANY-method}
\title{Calculates the mean for each row (column) of a matrix-like object}
\usage{
rowMeans2(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{rowMeans2}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{rowMeans2}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE,
  ..., useNames = TRUE)

colMeans2(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

\S4method{colMeans2}{matrix_OR_array_OR_table_OR_numeric}(x, rows = NULL,
  cols = NULL, na.rm = FALSE, dim. = dim(x), ..., useNames = TRUE)

\S4method{colMeans2}{ANY}(x, rows = NULL, cols = NULL, na.rm = FALSE,
  ..., useNames = TRUE)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{...}{Additional arguments passed to specific methods.}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}

\item{dim.}{An \code{\link{integer}} \code{\link{vector}} of length two
specifying the dimension of \code{x}, essential when x is a
\code{\link{numeric}} vector. Note, that this is not a generic
argument and not all methods need provide it.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the mean for each row (column) of a matrix-like object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowMeans2}} /
\code{matrixStats::\link[matrixStats]{colMeans2}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowMeans2(mat)
colMeans2(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowMeans2}()} and
\code{matrixStats::\link[matrixStats:rowMeans2]{colMeans2}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item See also \code{\link[base:colSums]{rowMeans}()} for the
corresponding function in base R.
\item For variance estimates, see \code{\link{rowVars}()}.
\item See also the base R version \code{base::\link{rowMeans}()}.
}
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
