% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_summaryStats.R
\name{plotBaseProductionRate}
\alias{plotBaseProductionRate}
\title{Plot the mean rate at which bases are recorded}
\usage{
plotBaseProductionRate(summaryData)
}
\arguments{
\item{summaryData}{Object of class \linkS4class{Fast5Summary}.}
}
\value{
Returns an object of class \code{gg} representing the plot.
}
\description{
For each read, the ratio between the total number of bases called in the read
(template and complement strand, but not 2D composite) and the time spent in
the pore is calculated.  This is then plotted against the time the read 
entered the pore, allow us to assess whether the rate at which callable 
bases are read changes during the experiment run time.
}
\details{
This is likely very similar to \code{\link{plotEventRate}}, although one may
find that large number of events occur that can not be base called, 
resulting in a difference between these two plots.
}
\examples{
if( require(minionSummaryData) ) {
   data(s.typhi.rep2, package = 'minionSummaryData')
   plotBaseProductionRate( s.typhi.rep2 )
}
}
